/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.environment.ConfigTokenProvider;
import org.springframework.cloud.config.server.environment.EnvironmentWatch;
import org.springframework.cloud.config.server.environment.VaultEnvironmentProperties;
import org.springframework.cloud.config.server.environment.VaultEnvironmentRepository;
import org.springframework.cloud.config.server.environment.VaultKvAccessStrategy;
import org.springframework.cloud.config.server.environment.VaultKvAccessStrategyFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

public class VaultEnvironmentRepositoryTests {
    private ObjectMapper objectMapper;

    @BeforeEach
    public void init() {
        this.objectMapper = new ObjectMapper();
    }

    @Test
    public void testFindOneNoDefaultKey() {
        RestTemplate rest = (RestTemplate)Mockito.mock(RestTemplate.class);
        ResponseEntity myAppResp = (ResponseEntity)Mockito.mock(ResponseEntity.class);
        Mockito.when((Object)myAppResp.getStatusCode()).thenReturn((Object)HttpStatus.OK);
        VaultKvAccessStrategy.VaultResponse myAppVaultResp = (VaultKvAccessStrategy.VaultResponse)Mockito.mock(VaultKvAccessStrategy.VaultResponse.class);
        Mockito.when((Object)myAppVaultResp.getData()).thenReturn((Object)"{\"foo\":\"bar\"}");
        Mockito.when((Object)((VaultKvAccessStrategy.VaultResponse)myAppResp.getBody())).thenReturn((Object)myAppVaultResp);
        Mockito.when((Object)rest.exchange((String)ArgumentMatchers.eq((Object)"http://127.0.0.1:8200/v1/secret/{key}"), (HttpMethod)ArgumentMatchers.eq((Object)HttpMethod.GET), (HttpEntity)ArgumentMatchers.any(HttpEntity.class), (Class)ArgumentMatchers.eq(VaultKvAccessStrategy.VaultResponse.class), new Object[]{ArgumentMatchers.eq((Object)"myapp")})).thenReturn((Object)myAppResp);
        ResponseEntity appResp = (ResponseEntity)Mockito.mock(ResponseEntity.class);
        Mockito.when((Object)appResp.getStatusCode()).thenReturn((Object)HttpStatus.OK);
        VaultKvAccessStrategy.VaultResponse appVaultResp = (VaultKvAccessStrategy.VaultResponse)Mockito.mock(VaultKvAccessStrategy.VaultResponse.class);
        Mockito.when((Object)appVaultResp.getData()).thenReturn((Object)"{\"def-foo\":\"def-bar\"}");
        Mockito.when((Object)((VaultKvAccessStrategy.VaultResponse)appResp.getBody())).thenReturn((Object)appVaultResp);
        Mockito.when((Object)rest.exchange((String)ArgumentMatchers.eq((Object)"http://127.0.0.1:8200/v1/secret/{key}"), (HttpMethod)ArgumentMatchers.eq((Object)HttpMethod.GET), (HttpEntity)ArgumentMatchers.any(HttpEntity.class), (Class)ArgumentMatchers.eq(VaultKvAccessStrategy.VaultResponse.class), new Object[]{ArgumentMatchers.eq((Object)"application")})).thenReturn((Object)appResp);
        VaultEnvironmentRepository repo = new VaultEnvironmentRepository(this.mockHttpRequest(), (EnvironmentWatch)new EnvironmentWatch.Default(), rest, new VaultEnvironmentProperties(), this.mockTokenProvider());
        Environment e = repo.findOne("myapp", null, null);
        ((AbstractStringAssert)Assertions.assertThat((String)e.getName()).as("Name should be the same as the application argument", new Object[0])).isEqualTo("myapp");
        ((AbstractIntegerAssert)Assertions.assertThat((int)e.getPropertySources().size()).as("Properties for specified application and default application with key 'application' should be returned", new Object[0])).isEqualTo(2);
        HashMap<String, String> firstResult = new HashMap<String, String>();
        firstResult.put("foo", "bar");
        ((MapAssert)Assertions.assertThat((Map)((PropertySource)e.getPropertySources().get(0)).getSource()).as("Properties for specified application should be returned in priority position", new Object[0])).isEqualTo(firstResult);
        HashMap<String, String> secondResult = new HashMap<String, String>();
        secondResult.put("def-foo", "def-bar");
        ((MapAssert)Assertions.assertThat((Map)((PropertySource)e.getPropertySources().get(1)).getSource()).as("Properties for default application with key 'application' should be returned in second position", new Object[0])).isEqualTo(secondResult);
    }

    @Test
    public void testBackendWithSlashes() {
        RestTemplate rest = (RestTemplate)Mockito.mock(RestTemplate.class);
        ResponseEntity myAppResp = (ResponseEntity)Mockito.mock(ResponseEntity.class);
        Mockito.when((Object)myAppResp.getStatusCode()).thenReturn((Object)HttpStatus.OK);
        VaultKvAccessStrategy.VaultResponse myAppVaultResp = (VaultKvAccessStrategy.VaultResponse)Mockito.mock(VaultKvAccessStrategy.VaultResponse.class);
        Mockito.when((Object)myAppVaultResp.getData()).thenReturn((Object)"{\"foo\":\"bar\"}");
        Mockito.when((Object)((VaultKvAccessStrategy.VaultResponse)myAppResp.getBody())).thenReturn((Object)myAppVaultResp);
        Mockito.when((Object)rest.exchange((String)ArgumentMatchers.eq((Object)"http://127.0.0.1:8200/v1/foo/bar/secret/{key}"), (HttpMethod)ArgumentMatchers.eq((Object)HttpMethod.GET), (HttpEntity)ArgumentMatchers.any(HttpEntity.class), (Class)ArgumentMatchers.eq(VaultKvAccessStrategy.VaultResponse.class), new Object[]{ArgumentMatchers.eq((Object)"myapp")})).thenReturn((Object)myAppResp);
        ResponseEntity appResp = (ResponseEntity)Mockito.mock(ResponseEntity.class);
        Mockito.when((Object)appResp.getStatusCode()).thenReturn((Object)HttpStatus.OK);
        VaultKvAccessStrategy.VaultResponse appVaultResp = (VaultKvAccessStrategy.VaultResponse)Mockito.mock(VaultKvAccessStrategy.VaultResponse.class);
        Mockito.when((Object)appVaultResp.getData()).thenReturn((Object)"{\"def-foo\":\"def-bar\"}");
        Mockito.when((Object)((VaultKvAccessStrategy.VaultResponse)appResp.getBody())).thenReturn((Object)appVaultResp);
        Mockito.when((Object)rest.exchange((String)ArgumentMatchers.eq((Object)"http://127.0.0.1:8200/v1/foo/bar/secret/{key}"), (HttpMethod)ArgumentMatchers.eq((Object)HttpMethod.GET), (HttpEntity)ArgumentMatchers.any(HttpEntity.class), (Class)ArgumentMatchers.eq(VaultKvAccessStrategy.VaultResponse.class), new Object[]{ArgumentMatchers.eq((Object)"application")})).thenReturn((Object)appResp);
        VaultEnvironmentProperties properties = new VaultEnvironmentProperties();
        properties.setBackend("foo/bar/secret");
        VaultEnvironmentRepository repo = new VaultEnvironmentRepository(this.mockHttpRequest(), (EnvironmentWatch)new EnvironmentWatch.Default(), rest, properties, this.mockTokenProvider());
        Environment e = repo.findOne("myapp", null, null);
        ((AbstractStringAssert)Assertions.assertThat((String)e.getName()).as("Name should be the same as the application argument", new Object[0])).isEqualTo("myapp");
        ((AbstractIntegerAssert)Assertions.assertThat((int)e.getPropertySources().size()).as("Properties for specified application and default application with key 'application' should be returned", new Object[0])).isEqualTo(2);
        HashMap<String, String> firstResult = new HashMap<String, String>();
        firstResult.put("foo", "bar");
        ((MapAssert)Assertions.assertThat((Map)((PropertySource)e.getPropertySources().get(0)).getSource()).as("Properties for specified application should be returned in priority position", new Object[0])).isEqualTo(firstResult);
        HashMap<String, String> secondResult = new HashMap<String, String>();
        secondResult.put("def-foo", "def-bar");
        ((MapAssert)Assertions.assertThat((Map)((PropertySource)e.getPropertySources().get(1)).getSource()).as("Properties for default application with key 'application' should be returned in second position", new Object[0])).isEqualTo(secondResult);
    }

    @Test
    public void testFindOneDefaultKeySetAndDifferentToApplication() {
        RestTemplate rest = (RestTemplate)Mockito.mock(RestTemplate.class);
        ResponseEntity myAppResp = (ResponseEntity)Mockito.mock(ResponseEntity.class);
        Mockito.when((Object)myAppResp.getStatusCode()).thenReturn((Object)HttpStatus.OK);
        VaultKvAccessStrategy.VaultResponse myAppVaultResp = (VaultKvAccessStrategy.VaultResponse)Mockito.mock(VaultKvAccessStrategy.VaultResponse.class);
        Mockito.when((Object)myAppVaultResp.getData()).thenReturn((Object)"{\"foo\":\"bar\"}");
        Mockito.when((Object)((VaultKvAccessStrategy.VaultResponse)myAppResp.getBody())).thenReturn((Object)myAppVaultResp);
        Mockito.when((Object)rest.exchange((String)ArgumentMatchers.eq((Object)"http://127.0.0.1:8200/v1/secret/{key}"), (HttpMethod)ArgumentMatchers.eq((Object)HttpMethod.GET), (HttpEntity)ArgumentMatchers.any(HttpEntity.class), (Class)ArgumentMatchers.eq(VaultKvAccessStrategy.VaultResponse.class), new Object[]{ArgumentMatchers.eq((Object)"myapp")})).thenReturn((Object)myAppResp);
        ResponseEntity myDefaultKeyResp = (ResponseEntity)Mockito.mock(ResponseEntity.class);
        Mockito.when((Object)myDefaultKeyResp.getStatusCode()).thenReturn((Object)HttpStatus.OK);
        VaultKvAccessStrategy.VaultResponse myDefaultKeyVaultResp = (VaultKvAccessStrategy.VaultResponse)Mockito.mock(VaultKvAccessStrategy.VaultResponse.class);
        Mockito.when((Object)myDefaultKeyVaultResp.getData()).thenReturn((Object)"{\"def-foo\":\"def-bar\"}");
        Mockito.when((Object)((VaultKvAccessStrategy.VaultResponse)myDefaultKeyResp.getBody())).thenReturn((Object)myDefaultKeyVaultResp);
        Mockito.when((Object)rest.exchange((String)ArgumentMatchers.eq((Object)"http://127.0.0.1:8200/v1/secret/{key}"), (HttpMethod)ArgumentMatchers.eq((Object)HttpMethod.GET), (HttpEntity)ArgumentMatchers.any(HttpEntity.class), (Class)ArgumentMatchers.eq(VaultKvAccessStrategy.VaultResponse.class), new Object[]{ArgumentMatchers.eq((Object)"mydefaultkey")})).thenReturn((Object)myDefaultKeyResp);
        VaultEnvironmentRepository repo = new VaultEnvironmentRepository(this.mockHttpRequest(), (EnvironmentWatch)new EnvironmentWatch.Default(), rest, new VaultEnvironmentProperties(), this.mockTokenProvider());
        repo.setDefaultKey("mydefaultkey");
        Environment e = repo.findOne("myapp", null, null);
        ((AbstractStringAssert)Assertions.assertThat((String)e.getName()).as("Name should be the same as the application argument", new Object[0])).isEqualTo("myapp");
        ((AbstractIntegerAssert)Assertions.assertThat((int)e.getPropertySources().size()).as("Properties for specified application and default application with key 'mydefaultkey' should be returned", new Object[0])).isEqualTo(2);
        HashMap<String, String> firstResult = new HashMap<String, String>();
        firstResult.put("foo", "bar");
        ((MapAssert)Assertions.assertThat((Map)((PropertySource)e.getPropertySources().get(0)).getSource()).as("Properties for specified application should be returned in priority position", new Object[0])).isEqualTo(firstResult);
        HashMap<String, String> secondResult = new HashMap<String, String>();
        secondResult.put("def-foo", "def-bar");
        ((MapAssert)Assertions.assertThat((Map)((PropertySource)e.getPropertySources().get(1)).getSource()).as("Properties for default application with key 'mydefaultkey' should be returned in second position", new Object[0])).isEqualTo(secondResult);
    }

    @Test
    public void testFindOneDefaultKeySetAndDifferentToMultipleApplications() {
        RestTemplate rest = (RestTemplate)Mockito.mock(RestTemplate.class);
        ResponseEntity myAppResp = (ResponseEntity)Mockito.mock(ResponseEntity.class);
        Mockito.when((Object)myAppResp.getStatusCode()).thenReturn((Object)HttpStatus.OK);
        VaultKvAccessStrategy.VaultResponse myAppVaultResp = (VaultKvAccessStrategy.VaultResponse)Mockito.mock(VaultKvAccessStrategy.VaultResponse.class);
        Mockito.when((Object)myAppVaultResp.getData()).thenReturn((Object)"{\"myapp-foo\":\"myapp-bar\"}");
        Mockito.when((Object)((VaultKvAccessStrategy.VaultResponse)myAppResp.getBody())).thenReturn((Object)myAppVaultResp);
        Mockito.when((Object)rest.exchange((String)ArgumentMatchers.eq((Object)"http://127.0.0.1:8200/v1/secret/{key}"), (HttpMethod)ArgumentMatchers.eq((Object)HttpMethod.GET), (HttpEntity)ArgumentMatchers.any(HttpEntity.class), (Class)ArgumentMatchers.eq(VaultKvAccessStrategy.VaultResponse.class), new Object[]{ArgumentMatchers.eq((Object)"myapp")})).thenReturn((Object)myAppResp);
        ResponseEntity yourAppResp = (ResponseEntity)Mockito.mock(ResponseEntity.class);
        Mockito.when((Object)yourAppResp.getStatusCode()).thenReturn((Object)HttpStatus.OK);
        VaultKvAccessStrategy.VaultResponse yourAppVaultResp = (VaultKvAccessStrategy.VaultResponse)Mockito.mock(VaultKvAccessStrategy.VaultResponse.class);
        Mockito.when((Object)yourAppVaultResp.getData()).thenReturn((Object)"{\"yourapp-foo\":\"yourapp-bar\"}");
        Mockito.when((Object)((VaultKvAccessStrategy.VaultResponse)yourAppResp.getBody())).thenReturn((Object)yourAppVaultResp);
        Mockito.when((Object)rest.exchange((String)ArgumentMatchers.eq((Object)"http://127.0.0.1:8200/v1/secret/{key}"), (HttpMethod)ArgumentMatchers.eq((Object)HttpMethod.GET), (HttpEntity)ArgumentMatchers.any(HttpEntity.class), (Class)ArgumentMatchers.eq(VaultKvAccessStrategy.VaultResponse.class), new Object[]{ArgumentMatchers.eq((Object)"yourapp")})).thenReturn((Object)yourAppResp);
        ResponseEntity myDefaultKeyResp = (ResponseEntity)Mockito.mock(ResponseEntity.class);
        Mockito.when((Object)myDefaultKeyResp.getStatusCode()).thenReturn((Object)HttpStatus.OK);
        VaultKvAccessStrategy.VaultResponse myDefaultKeyVaultResp = (VaultKvAccessStrategy.VaultResponse)Mockito.mock(VaultKvAccessStrategy.VaultResponse.class);
        Mockito.when((Object)myDefaultKeyVaultResp.getData()).thenReturn((Object)"{\"def-foo\":\"def-bar\"}");
        Mockito.when((Object)((VaultKvAccessStrategy.VaultResponse)myDefaultKeyResp.getBody())).thenReturn((Object)myDefaultKeyVaultResp);
        Mockito.when((Object)rest.exchange((String)ArgumentMatchers.eq((Object)"http://127.0.0.1:8200/v1/secret/{key}"), (HttpMethod)ArgumentMatchers.eq((Object)HttpMethod.GET), (HttpEntity)ArgumentMatchers.any(HttpEntity.class), (Class)ArgumentMatchers.eq(VaultKvAccessStrategy.VaultResponse.class), new Object[]{ArgumentMatchers.eq((Object)"mydefaultkey")})).thenReturn((Object)myDefaultKeyResp);
        VaultEnvironmentRepository repo = new VaultEnvironmentRepository(this.mockHttpRequest(), (EnvironmentWatch)new EnvironmentWatch.Default(), rest, new VaultEnvironmentProperties(), this.mockTokenProvider());
        repo.setDefaultKey("mydefaultkey");
        Environment e = repo.findOne("myapp,yourapp", null, null);
        ((AbstractStringAssert)Assertions.assertThat((String)e.getName()).as("Name should be the same as the application argument", new Object[0])).isEqualTo("myapp,yourapp");
        ((AbstractIntegerAssert)Assertions.assertThat((int)e.getPropertySources().size()).as("Properties for specified applications and default application with key 'mydefaultkey' should be returned", new Object[0])).isEqualTo(3);
        HashMap<String, String> firstResult = new HashMap<String, String>();
        firstResult.put("yourapp-foo", "yourapp-bar");
        ((MapAssert)Assertions.assertThat((Map)((PropertySource)e.getPropertySources().get(0)).getSource()).as("Properties for first specified application should be returned in priority position", new Object[0])).isEqualTo(firstResult);
        HashMap<String, String> secondResult = new HashMap<String, String>();
        secondResult.put("myapp-foo", "myapp-bar");
        ((MapAssert)Assertions.assertThat((Map)((PropertySource)e.getPropertySources().get(1)).getSource()).as("Properties for second specified application should be returned in priority position", new Object[0])).isEqualTo(secondResult);
        HashMap<String, String> thirdResult = new HashMap<String, String>();
        thirdResult.put("def-foo", "def-bar");
        ((MapAssert)Assertions.assertThat((Map)((PropertySource)e.getPropertySources().get(2)).getSource()).as("Properties for default application with key 'mydefaultkey' should be returned in second position", new Object[0])).isEqualTo(thirdResult);
    }

    @Test
    public void testFindOneDefaultKeySetAndEqualToApplication() {
        RestTemplate rest = (RestTemplate)Mockito.mock(RestTemplate.class);
        ResponseEntity myAppResp = (ResponseEntity)Mockito.mock(ResponseEntity.class);
        Mockito.when((Object)myAppResp.getStatusCode()).thenReturn((Object)HttpStatus.OK);
        VaultKvAccessStrategy.VaultResponse myAppVaultResp = (VaultKvAccessStrategy.VaultResponse)Mockito.mock(VaultKvAccessStrategy.VaultResponse.class);
        Mockito.when((Object)myAppVaultResp.getData()).thenReturn((Object)"{\"foo\":\"bar\"}");
        Mockito.when((Object)((VaultKvAccessStrategy.VaultResponse)myAppResp.getBody())).thenReturn((Object)myAppVaultResp);
        Mockito.when((Object)rest.exchange((String)ArgumentMatchers.eq((Object)"http://127.0.0.1:8200/v1/secret/{key}"), (HttpMethod)ArgumentMatchers.eq((Object)HttpMethod.GET), (HttpEntity)ArgumentMatchers.any(HttpEntity.class), (Class)ArgumentMatchers.eq(VaultKvAccessStrategy.VaultResponse.class), new Object[]{ArgumentMatchers.eq((Object)"myapp")})).thenReturn((Object)myAppResp);
        ResponseEntity appResp = (ResponseEntity)Mockito.mock(ResponseEntity.class);
        Mockito.when((Object)appResp.getStatusCode()).thenReturn((Object)HttpStatus.OK);
        VaultKvAccessStrategy.VaultResponse appVaultResp = (VaultKvAccessStrategy.VaultResponse)Mockito.mock(VaultKvAccessStrategy.VaultResponse.class);
        Mockito.when((Object)appVaultResp.getData()).thenReturn((Object)"{\"def-foo\":\"def-bar\"}");
        Mockito.when((Object)((VaultKvAccessStrategy.VaultResponse)appResp.getBody())).thenReturn((Object)appVaultResp);
        Mockito.when((Object)rest.exchange((String)ArgumentMatchers.eq((Object)"http://127.0.0.1:8200/v1/secret/{key}"), (HttpMethod)ArgumentMatchers.eq((Object)HttpMethod.GET), (HttpEntity)ArgumentMatchers.any(HttpEntity.class), (Class)ArgumentMatchers.eq(VaultKvAccessStrategy.VaultResponse.class), new Object[]{ArgumentMatchers.eq((Object)"application")})).thenReturn((Object)appResp);
        VaultEnvironmentRepository repo = new VaultEnvironmentRepository(this.mockHttpRequest(), (EnvironmentWatch)new EnvironmentWatch.Default(), rest, new VaultEnvironmentProperties(), this.mockTokenProvider());
        repo.setDefaultKey("myapp");
        Environment e = repo.findOne("myapp", null, null);
        ((AbstractStringAssert)Assertions.assertThat((String)e.getName()).as("Name should be the same as the application argument", new Object[0])).isEqualTo("myapp");
        ((AbstractIntegerAssert)Assertions.assertThat((int)e.getPropertySources().size()).as("Only properties for specified application should be returned", new Object[0])).isEqualTo(1);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("foo", "bar");
        ((MapAssert)Assertions.assertThat((Map)((PropertySource)e.getPropertySources().get(0)).getSource()).as("Properties should be returned for specified application", new Object[0])).isEqualTo(result);
    }

    @Test
    public void missingConfigToken() {
        Assertions.assertThatThrownBy(() -> {
            ConfigTokenProvider tokenProvider = (ConfigTokenProvider)Mockito.mock(ConfigTokenProvider.class);
            Mockito.when((Object)tokenProvider.getToken()).thenReturn(null);
            VaultEnvironmentRepository repo = new VaultEnvironmentRepository(this.mockHttpRequest(), (EnvironmentWatch)new EnvironmentWatch.Default(), (RestTemplate)Mockito.mock(RestTemplate.class), new VaultEnvironmentProperties(), tokenProvider);
            repo.findOne("myapp", null, null);
        }).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testVaultVersioning() {
        RestTemplate rest = (RestTemplate)Mockito.mock(RestTemplate.class);
        ResponseEntity myAppResp = (ResponseEntity)Mockito.mock(ResponseEntity.class);
        Mockito.when((Object)myAppResp.getStatusCode()).thenReturn((Object)HttpStatus.OK);
        VaultKvAccessStrategy.VaultResponse myAppVaultResp = this.getVaultResponse("{\"data\": {\"data\": {\"foo\": \"bar\"}}}");
        Mockito.when((Object)((VaultKvAccessStrategy.VaultResponse)myAppResp.getBody())).thenReturn((Object)myAppVaultResp);
        Mockito.when((Object)rest.exchange((String)ArgumentMatchers.eq((Object)"http://127.0.0.1:8200/v1/secret/data/{key}"), (HttpMethod)ArgumentMatchers.eq((Object)HttpMethod.GET), (HttpEntity)ArgumentMatchers.any(HttpEntity.class), (Class)ArgumentMatchers.eq(VaultKvAccessStrategy.VaultResponse.class), new Object[]{ArgumentMatchers.eq((Object)"myapp")})).thenReturn((Object)myAppResp);
        ResponseEntity appResp = (ResponseEntity)Mockito.mock(ResponseEntity.class);
        Mockito.when((Object)appResp.getStatusCode()).thenReturn((Object)HttpStatus.OK);
        VaultKvAccessStrategy.VaultResponse appVaultResp = this.getVaultResponse("{\"data\": {\"data\": {\"def-foo\":\"def-bar\"}}}");
        Mockito.when((Object)((VaultKvAccessStrategy.VaultResponse)appResp.getBody())).thenReturn((Object)appVaultResp);
        Mockito.when((Object)rest.exchange((String)ArgumentMatchers.eq((Object)"http://127.0.0.1:8200/v1/secret/data/{key}"), (HttpMethod)ArgumentMatchers.eq((Object)HttpMethod.GET), (HttpEntity)ArgumentMatchers.any(HttpEntity.class), (Class)ArgumentMatchers.eq(VaultKvAccessStrategy.VaultResponse.class), new Object[]{ArgumentMatchers.eq((Object)"application")})).thenReturn((Object)appResp);
        VaultEnvironmentProperties vaultEnvironmentProperties = new VaultEnvironmentProperties();
        vaultEnvironmentProperties.setKvVersion(2);
        VaultEnvironmentRepository repo = new VaultEnvironmentRepository(this.mockHttpRequest(), (EnvironmentWatch)new EnvironmentWatch.Default(), rest, vaultEnvironmentProperties, this.mockTokenProvider());
        Environment e = repo.findOne("myapp", null, null);
        ((AbstractStringAssert)Assertions.assertThat((String)e.getName()).as("Name should be the same as the application argument", new Object[0])).isEqualTo("myapp");
        ((AbstractIntegerAssert)Assertions.assertThat((int)e.getPropertySources().size()).as("Properties for specified application and default application with key 'application' should be returned", new Object[0])).isEqualTo(2);
        HashMap<String, String> firstResult = new HashMap<String, String>();
        firstResult.put("foo", "bar");
        ((MapAssert)Assertions.assertThat((Map)((PropertySource)e.getPropertySources().get(0)).getSource()).as("Properties for specified application should be returned in priority position", new Object[0])).isEqualTo(firstResult);
    }

    @Test
    public void testVaultKV2WithPath2Key() {
        RestTemplate rest = (RestTemplate)Mockito.mock(RestTemplate.class);
        ResponseEntity myAppResp = (ResponseEntity)Mockito.mock(ResponseEntity.class);
        Mockito.when((Object)myAppResp.getStatusCode()).thenReturn((Object)HttpStatus.OK);
        VaultKvAccessStrategy.VaultResponse myAppVaultResp = this.getVaultResponse("{\"data\": {\"data\": {\"foo\": \"bar\"}}}");
        Mockito.when((Object)((VaultKvAccessStrategy.VaultResponse)myAppResp.getBody())).thenReturn((Object)myAppVaultResp);
        Mockito.when((Object)rest.exchange((String)ArgumentMatchers.eq((Object)"http://127.0.0.1:8200/v1/secret/data/myorg/{key}"), (HttpMethod)ArgumentMatchers.eq((Object)HttpMethod.GET), (HttpEntity)ArgumentMatchers.any(HttpEntity.class), (Class)ArgumentMatchers.eq(VaultKvAccessStrategy.VaultResponse.class), new Object[]{ArgumentMatchers.eq((Object)"myapp")})).thenReturn((Object)myAppResp);
        ResponseEntity appResp = (ResponseEntity)Mockito.mock(ResponseEntity.class);
        Mockito.when((Object)appResp.getStatusCode()).thenReturn((Object)HttpStatus.OK);
        VaultKvAccessStrategy.VaultResponse appVaultResp = this.getVaultResponse("{\"data\": {\"data\": {\"def-foo\":\"def-bar\"}}}");
        Mockito.when((Object)((VaultKvAccessStrategy.VaultResponse)appResp.getBody())).thenReturn((Object)appVaultResp);
        Mockito.when((Object)rest.exchange((String)ArgumentMatchers.eq((Object)"http://127.0.0.1:8200/v1/secret/data/myorg/{key}"), (HttpMethod)ArgumentMatchers.eq((Object)HttpMethod.GET), (HttpEntity)ArgumentMatchers.any(HttpEntity.class), (Class)ArgumentMatchers.eq(VaultKvAccessStrategy.VaultResponse.class), new Object[]{ArgumentMatchers.eq((Object)"application")})).thenReturn((Object)appResp);
        VaultEnvironmentProperties vaultEnvironmentProperties = new VaultEnvironmentProperties();
        vaultEnvironmentProperties.setKvVersion(2);
        vaultEnvironmentProperties.setPathToKey("myorg");
        VaultEnvironmentRepository repo = new VaultEnvironmentRepository(this.mockHttpRequest(), (EnvironmentWatch)new EnvironmentWatch.Default(), rest, vaultEnvironmentProperties, this.mockTokenProvider());
        Environment e = repo.findOne("myapp", null, null);
        ((AbstractStringAssert)Assertions.assertThat((String)e.getName()).as("Name should be the same as the application argument", new Object[0])).isEqualTo("myapp");
        ((AbstractIntegerAssert)Assertions.assertThat((int)e.getPropertySources().size()).as("Properties for specified application and default application with key 'application' should be returned", new Object[0])).isEqualTo(2);
        HashMap<String, String> firstResult = new HashMap<String, String>();
        firstResult.put("foo", "bar");
        ((MapAssert)Assertions.assertThat((Map)((PropertySource)e.getPropertySources().get(0)).getSource()).as("Properties for specified application should be returned in priority position", new Object[0])).isEqualTo(firstResult);
    }

    @Test
    public void testNamespaceHeaderSent() {
        RestTemplate rest = (RestTemplate)Mockito.mock(RestTemplate.class);
        ResponseEntity myAppResp = (ResponseEntity)Mockito.mock(ResponseEntity.class);
        Mockito.when((Object)myAppResp.getStatusCode()).thenReturn((Object)HttpStatus.OK);
        VaultKvAccessStrategy.VaultResponse myAppVaultResp = (VaultKvAccessStrategy.VaultResponse)Mockito.mock(VaultKvAccessStrategy.VaultResponse.class);
        Mockito.when((Object)myAppVaultResp.getData()).thenReturn((Object)"{\"foo\":\"bar\"}");
        Mockito.when((Object)((VaultKvAccessStrategy.VaultResponse)myAppResp.getBody())).thenReturn((Object)myAppVaultResp);
        Mockito.when((Object)rest.exchange((String)ArgumentMatchers.eq((Object)"http://127.0.0.1:8200/v1/secret/{key}"), (HttpMethod)ArgumentMatchers.eq((Object)HttpMethod.GET), (HttpEntity)ArgumentMatchers.any(HttpEntity.class), (Class)ArgumentMatchers.eq(VaultKvAccessStrategy.VaultResponse.class), new Object[]{ArgumentMatchers.eq((Object)"myapp")})).thenReturn((Object)myAppResp);
        ResponseEntity appResp = (ResponseEntity)Mockito.mock(ResponseEntity.class);
        Mockito.when((Object)appResp.getStatusCode()).thenReturn((Object)HttpStatus.OK);
        VaultKvAccessStrategy.VaultResponse appVaultResp = (VaultKvAccessStrategy.VaultResponse)Mockito.mock(VaultKvAccessStrategy.VaultResponse.class);
        Mockito.when((Object)appVaultResp.getData()).thenReturn((Object)"{\"def-foo\":\"def-bar\"}");
        Mockito.when((Object)((VaultKvAccessStrategy.VaultResponse)appResp.getBody())).thenReturn((Object)appVaultResp);
        Mockito.when((Object)rest.exchange((String)ArgumentMatchers.eq((Object)"http://127.0.0.1:8200/v1/secret/{key}"), (HttpMethod)ArgumentMatchers.eq((Object)HttpMethod.GET), (HttpEntity)ArgumentMatchers.any(HttpEntity.class), (Class)ArgumentMatchers.eq(VaultKvAccessStrategy.VaultResponse.class), new Object[]{ArgumentMatchers.eq((Object)"application")})).thenReturn((Object)appResp);
        VaultEnvironmentProperties properties = new VaultEnvironmentProperties();
        properties.setNamespace("mynamespace");
        VaultEnvironmentRepository repo = new VaultEnvironmentRepository(this.mockHttpRequest(), (EnvironmentWatch)new EnvironmentWatch.Default(), rest, properties, this.mockTokenProvider());
        TestAccessStrategy accessStrategy = new TestAccessStrategy(rest, properties);
        repo.setAccessStrategy((VaultKvAccessStrategy)accessStrategy);
        repo.findOne("myapp", null, null);
        Assertions.assertThat((Map)accessStrategy.headers).containsEntry((Object)"X-Vault-Namespace", Collections.singletonList("mynamespace"));
    }

    private VaultKvAccessStrategy.VaultResponse getVaultResponse(String json) {
        try {
            return (VaultKvAccessStrategy.VaultResponse)this.objectMapper.readValue(json, VaultKvAccessStrategy.VaultResponse.class);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
            return null;
        }
    }

    private ObjectProvider<HttpServletRequest> mockHttpRequest() {
        ObjectProvider objectProvider = (ObjectProvider)Mockito.mock(ObjectProvider.class);
        Mockito.when((Object)((HttpServletRequest)objectProvider.getIfAvailable())).thenReturn(null);
        return objectProvider;
    }

    private ConfigTokenProvider mockTokenProvider() {
        ConfigTokenProvider tokenProvider = (ConfigTokenProvider)Mockito.mock(ConfigTokenProvider.class);
        Mockito.when((Object)tokenProvider.getToken()).thenReturn((Object)"token");
        return tokenProvider;
    }

    private static class TestAccessStrategy
    implements VaultKvAccessStrategy {
        private final VaultKvAccessStrategy accessStrategy;
        private HttpHeaders headers;

        TestAccessStrategy(RestTemplate restTemplate, VaultEnvironmentProperties properties) {
            String baseUrl = String.format("%s://%s:%s", properties.getScheme(), properties.getHost(), properties.getPort());
            this.accessStrategy = VaultKvAccessStrategyFactory.forVersion((RestOperations)restTemplate, (String)baseUrl, (int)properties.getKvVersion(), (String)"");
        }

        public String getData(HttpHeaders headers, String backend, String key) throws RestClientException {
            this.headers = headers;
            return this.accessStrategy.getData(headers, backend, key);
        }
    }
}

