/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.config.server.environment.VaultKvAccessStrategy;
import org.springframework.cloud.config.server.environment.VaultKvAccessStrategyFactory;
import org.springframework.cloud.config.server.environment.VaultKvAccessStrategySupport;

public class VaultKvAccessStrategyTest {
    private static final String FOO_BAR = "{\"foo\":\"bar\"}";
    private ObjectMapper objectMapper = new ObjectMapper();

    private static VaultKvAccessStrategySupport getStrategy(int version) {
        return (VaultKvAccessStrategySupport)VaultKvAccessStrategyFactory.forVersion(null, (String)"foo", (int)version, (String)"");
    }

    @Test
    public void testV1ExtractFromBody() {
        String json = "{\"data\": {\"foo\": \"bar\"}}";
        String s = VaultKvAccessStrategyTest.getStrategy(1).extractDataFromBody(this.getVaultResponse(json));
        Assertions.assertThat((String)s).isEqualTo(FOO_BAR);
    }

    @Test
    public void testV1ExtractFromBodyNoData() {
        String json = "{}";
        String s = VaultKvAccessStrategyTest.getStrategy(1).extractDataFromBody(this.getVaultResponse(json));
        Assertions.assertThat((String)s).isNull();
    }

    @Test
    public void testV2ExtractFromBody() {
        String json = "{\"data\": {\"data\": {\"foo\": \"bar\"}}}";
        String s = VaultKvAccessStrategyTest.getStrategy(2).extractDataFromBody(this.getVaultResponse(json));
        Assertions.assertThat((String)s).isEqualTo(FOO_BAR);
    }

    @Test
    public void testV2ExtractFromBodyEmptyNestedData() {
        String json = "{\"data\": {}}";
        String s = VaultKvAccessStrategyTest.getStrategy(2).extractDataFromBody(this.getVaultResponse(json));
        Assertions.assertThat((String)s).isNull();
    }

    @Test
    public void testV2ExtractFromBodyNoData() {
        String json = "{}";
        String s = VaultKvAccessStrategyTest.getStrategy(2).extractDataFromBody(this.getVaultResponse(json));
        Assertions.assertThat((String)s).isNull();
    }

    private VaultKvAccessStrategy.VaultResponse getVaultResponse(String json) {
        try {
            return (VaultKvAccessStrategy.VaultResponse)this.objectMapper.readValue(json, VaultKvAccessStrategy.VaultResponse.class);
        }
        catch (IOException e) {
            throw new UndeclaredThrowableException(e);
        }
    }
}

