/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment.vault;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.boot.autoconfigure.AutoConfigurations;
import org.springframework.boot.context.annotation.Configurations;
import org.springframework.boot.context.annotation.UserConfigurations;
import org.springframework.boot.test.context.assertj.ApplicationContextAssert;
import org.springframework.boot.test.context.runner.WebApplicationContextRunner;
import org.springframework.cloud.config.server.config.ConfigServerAutoConfiguration;
import org.springframework.cloud.config.server.config.ConfigServerConfiguration;
import org.springframework.cloud.config.server.environment.VaultEnvironmentProperties;
import org.springframework.cloud.config.server.environment.vault.SpringVaultClientAuthenticationProvider;
import org.springframework.cloud.config.server.environment.vault.SpringVaultClientConfiguration;
import org.springframework.cloud.config.server.environment.vault.authentication.AppRoleClientAuthenticationProvider;
import org.springframework.cloud.config.server.environment.vault.authentication.AwsEc2ClientAuthenticationProvider;
import org.springframework.cloud.config.server.environment.vault.authentication.AwsIamClientAuthenticationProvider;
import org.springframework.cloud.config.server.environment.vault.authentication.AzureMsiClientAuthenticationProvider;
import org.springframework.cloud.config.server.environment.vault.authentication.CertificateClientAuthenticationProvider;
import org.springframework.cloud.config.server.environment.vault.authentication.CubbyholeClientAuthenticationProvider;
import org.springframework.cloud.config.server.environment.vault.authentication.GcpGceClientAuthenticationProvider;
import org.springframework.cloud.config.server.environment.vault.authentication.GcpIamClientAuthenticationProvider;
import org.springframework.cloud.config.server.environment.vault.authentication.KubernetesClientAuthenticationProvider;
import org.springframework.cloud.config.server.environment.vault.authentication.PcfClientAuthenticationProvider;
import org.springframework.cloud.config.server.environment.vault.authentication.TokenClientAuthenticationProvider;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.StaticApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.mock.http.client.MockClientHttpRequest;
import org.springframework.test.util.ReflectionTestUtils;
import org.springframework.util.ClassUtils;
import org.springframework.vault.authentication.AppRoleAuthentication;
import org.springframework.vault.authentication.AwsEc2Authentication;
import org.springframework.vault.authentication.AwsIamAuthentication;
import org.springframework.vault.authentication.AzureMsiAuthentication;
import org.springframework.vault.authentication.AzureMsiAuthenticationOptions;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.authentication.ClientCertificateAuthentication;
import org.springframework.vault.authentication.CubbyholeAuthentication;
import org.springframework.vault.authentication.GcpComputeAuthentication;
import org.springframework.vault.authentication.GcpIamAuthentication;
import org.springframework.vault.authentication.KubernetesAuthentication;
import org.springframework.vault.authentication.PcfAuthentication;
import org.springframework.vault.authentication.TokenAuthentication;
import org.springframework.vault.support.SslConfiguration;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

class SpringVaultClientConfigurationTests {
    private VaultEnvironmentProperties properties = new VaultEnvironmentProperties();
    private List<SpringVaultClientAuthenticationProvider> authProviders;
    private StaticApplicationContext applicationContext;

    SpringVaultClientConfigurationTests() {
    }

    @BeforeEach
    public void setUp() {
        this.authProviders = Arrays.asList(new AppRoleClientAuthenticationProvider(), new AwsEc2ClientAuthenticationProvider(), new AwsIamClientAuthenticationProvider(), new AzureMsiClientAuthenticationProvider(), new CertificateClientAuthenticationProvider(), new CubbyholeClientAuthenticationProvider(), new GcpGceClientAuthenticationProvider(), new GcpIamClientAuthenticationProvider(), new KubernetesClientAuthenticationProvider(), new PcfClientAuthenticationProvider(), new TokenClientAuthenticationProvider());
        this.applicationContext = new StaticApplicationContext();
        this.applicationContext.refresh();
    }

    @AfterEach
    public void teardown() {
        this.applicationContext.close();
    }

    @Test
    public void defaultAuthentication() {
        this.assertClientAuthenticationOfType(this.properties, SpringVaultClientConfiguration.ConfigTokenProviderAuthentication.class);
    }

    @Test
    public void appRoleAuthentication() {
        this.properties.setAuthentication(VaultEnvironmentProperties.AuthenticationMethod.APPROLE);
        this.properties.getAppRole().setRoleId("role-id");
        this.assertClientAuthenticationOfType(this.properties, AppRoleAuthentication.class);
    }

    @Test
    public void awsEc2Authentication() {
        this.properties.setAuthentication(VaultEnvironmentProperties.AuthenticationMethod.AWS_EC2);
        this.properties.getAwsEc2().setRole("server");
        this.properties.getAwsEc2().setAwsEc2Path("aws-ec2");
        this.assertClientAuthenticationOfType(this.properties, AwsEc2Authentication.class);
    }

    @Test
    public void awsIamAuthentication() {
        System.setProperty("aws.accessKeyId", "access-key-id");
        System.setProperty("aws.secretAccessKey", "secret-key");
        this.properties.setAuthentication(VaultEnvironmentProperties.AuthenticationMethod.AWS_IAM);
        this.properties.getAwsIam().setRole("server");
        this.properties.getAwsIam().setAwsPath("aws-iam");
        this.assertClientAuthenticationOfType(this.properties, AwsIamAuthentication.class);
    }

    @Test
    public void azureMsiAuthentication() {
        this.properties.setAuthentication(VaultEnvironmentProperties.AuthenticationMethod.AZURE_MSI);
        this.properties.getAzureMsi().setRole("server");
        this.properties.getAzureMsi().setAzurePath("azure-msi");
        this.assertClientAuthenticationOfType(this.properties, AzureMsiAuthentication.class);
        AzureMsiAuthentication clientAuthentication = (AzureMsiAuthentication)this.getConfiguration(this.properties).clientAuthentication();
        AzureMsiAuthenticationOptions options = (AzureMsiAuthenticationOptions)ReflectionTestUtils.getField((Object)clientAuthentication, (String)"options");
        Assertions.assertThat((URI)options.getIdentityTokenServiceUri()).isEqualTo((Object)AzureMsiAuthenticationOptions.DEFAULT_IDENTITY_TOKEN_SERVICE_URI);
        Assertions.assertThat((URI)options.getInstanceMetadataServiceUri()).isEqualTo((Object)AzureMsiAuthenticationOptions.DEFAULT_INSTANCE_METADATA_SERVICE_URI);
    }

    @Test
    public void clientCertificateAuthentication() {
        this.properties.setAuthentication(VaultEnvironmentProperties.AuthenticationMethod.CERT);
        this.assertClientAuthenticationOfType(this.properties, ClientCertificateAuthentication.class);
    }

    @Test
    public void cubbyholeAuthentication() {
        this.properties.setAuthentication(VaultEnvironmentProperties.AuthenticationMethod.CUBBYHOLE);
        this.properties.setToken("token");
        this.assertClientAuthenticationOfType(this.properties, CubbyholeAuthentication.class);
    }

    @Test
    public void gcpComputeAuthentication() {
        this.properties.setAuthentication(VaultEnvironmentProperties.AuthenticationMethod.GCP_GCE);
        this.properties.getGcpGce().setRole("server");
        this.properties.getGcpGce().setServiceAccount("service-account");
        this.assertClientAuthenticationOfType(this.properties, GcpComputeAuthentication.class);
    }

    @Test
    public void gcpIamAuthentication() {
        String GCE_JSON = "{  \"type\": \"service_account\",  \"project_id\": \"project\",  \"private_key_id\": \"aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa\",  \"private_key\": \"-----BEGIN PRIVATE KEY-----\\nMIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQC5qHafKgP/FAKE\\nxfRl0i47zXKbGQJvGAGpcmiXRgeWkZp+kwNwBguOYNwO1qDcmewKvMPazj7EL0hV\\nXMkPxgshZ9ZSxPwg7/XHHcyGCYBJhDc2hyunQvc2WGUOlQKg/nOlq3Dg8d9c/0yF\\nmFOh2K+IrbV6Vqs3nXsupV1q2FbUCVg6NGB0HCdTBZO4e36tmcaWgC1cKTv/Nh+j\\nf2Bf7qBTk0GOL9AjKoa/HP24Yto5zFoOFLU+2ZkVbb8hhO8OMUKW8dLIynqqRqwv\\noI8e4oiHX3dBvwcS0zZkEUtQiDI80OCbU7ZhPgn5xQpndanD9dZ4TYSgKuXRVTzr\\n1cyoyP7HAgMBAAECggEAV2fOYOSg+V60WvYhN4aaKaFxoT9G/BJrReENCJr5m5N1\\nDr4b0jOmYSOMtpepJ/J3RB7Wfj63Ihm4jieeqQRt3Q5Lwq/mm4MdTN7kmP4EHZhX\\nfh5pGNfYFwfKm/DfSfhBbe+mtuBobhnrZsHuLbYb/db6J1yCQy6q/azwrAqp5iyq\\nGjNN+WiDIcrydPKKiaszMnb9mNH+Y6Ianx1mvSLT35nBEF6Z4rJVERl26diOoo3I\\nF6WadIwTqcoLo5duUO3SaHKKLcoSEEaGkutuTCHcFOzhvZrXbuIyD567Vp5oVFe9\\nSHN10vceQQdWPh2UsKrVQfIdc70+9tlslka5X6BbIQKBgQDss/APs65NNev2lPdb\\nJzdd+0YwKEQXeENWkU1xJJkNH/wF0ZGuYxoKafZR0efs1LnrbaPfHveFCnUcDuXU\\nyDnzG2zMw1Q72F8eGHpLItPSh0ZkfSlN58uM1oYMdTFUE6ezlOYEnKIYdhjmQWiE\\nuEa1G4ZW0aX0NLICet597GnLKQKBgQDIyzRVbOOzOxGUgrWT0RPT12VVNCn7edn1\\nUWLKDl4L2uF8vE4g8WW7gwNkVbuO3VPKqdGuCBDfVyyysOOOCDN0IxSxDk3458VY\\n4I3jAuBcgDsixwC28l0QtFnz2yRuD2fsBhLnoSfsM/T2hNbf7atDtMQhbbgU37me\\nX+Ewtr+obwKBgCdbb/IcbUH3UknI0Sw95A3jZvNA7rl8TK4LMPY8IJq3E7+f7foy\\nDjVnEwbdwRN294b2zwWdb4iWiYxlyb9Mn54VlEyjudDNlFs7tLHjk5bw2TqCOSjz\\n/rtnPBi8L7yMHBlXC7v+k1E/6bn3bDqNLWyVrAuphk+Jp4OUDIShl6GpAoGAFIAC\\nmNIkMTFPqyzpIu1Oq+sq0lcgDiezpAMqJdzvpyAys0x6YYyjyVAn8X97Rau9GUzb\\nNnxmVJcO3jOHGAIoVqwaObVvKoFnOZq7gbjSdT82Smes4ADAlasEIAx4nK//+S3p\\nkjJ24/ut/9kyIuyd9qym9Y7BI4hv6AZ79EBEMwsCgYEAgXzq5+NCfJIi6Zduugym\\niUU3y/3CWc/pLhnw3XZ5r3M5fLXokLhLU6FsNflTpdcf2QoNL58mE0tanPqg09Xh\\n7fHWR/8rISt2TsMlqFjc5rQxWg8yRpdd5Ti/Ln8v7EV3RGbhFlOqlC9hiyqfyd7V\\nqZjZg4zUxPO1I8ae8hbGMWs=\\n-----END PRIVATE KEY-----\\n\",  \"client_email\": \"test@example.com\",  \"client_id\": \"111111111111111111111\",  \"auth_uri\": \"https://accounts.google.com/o/oauth2/auth\",  \"token_uri\": \"https://accounts.google.com/o/oauth2/token\",  \"auth_provider_x509_cert_url\": \"https://www.googleapis.com/oauth2/v1/certs\",  \"client_x509_cert_url\": \"https://www.googleapis.com/robot/v1/metadata/x509/toolsmiths-pcf-sa%40cf-spinnaker.iam.gserviceaccount.com\"}";
        this.properties.setAuthentication(VaultEnvironmentProperties.AuthenticationMethod.GCP_IAM);
        this.properties.getGcpIam().setRole("server");
        this.properties.getGcpIam().setProjectId("project");
        this.properties.getGcpIam().setServiceAccountId("service-account");
        this.properties.getGcpIam().getCredentials().setEncodedKey(this.base64("{  \"type\": \"service_account\",  \"project_id\": \"project\",  \"private_key_id\": \"aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa\",  \"private_key\": \"-----BEGIN PRIVATE KEY-----\\nMIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQC5qHafKgP/FAKE\\nxfRl0i47zXKbGQJvGAGpcmiXRgeWkZp+kwNwBguOYNwO1qDcmewKvMPazj7EL0hV\\nXMkPxgshZ9ZSxPwg7/XHHcyGCYBJhDc2hyunQvc2WGUOlQKg/nOlq3Dg8d9c/0yF\\nmFOh2K+IrbV6Vqs3nXsupV1q2FbUCVg6NGB0HCdTBZO4e36tmcaWgC1cKTv/Nh+j\\nf2Bf7qBTk0GOL9AjKoa/HP24Yto5zFoOFLU+2ZkVbb8hhO8OMUKW8dLIynqqRqwv\\noI8e4oiHX3dBvwcS0zZkEUtQiDI80OCbU7ZhPgn5xQpndanD9dZ4TYSgKuXRVTzr\\n1cyoyP7HAgMBAAECggEAV2fOYOSg+V60WvYhN4aaKaFxoT9G/BJrReENCJr5m5N1\\nDr4b0jOmYSOMtpepJ/J3RB7Wfj63Ihm4jieeqQRt3Q5Lwq/mm4MdTN7kmP4EHZhX\\nfh5pGNfYFwfKm/DfSfhBbe+mtuBobhnrZsHuLbYb/db6J1yCQy6q/azwrAqp5iyq\\nGjNN+WiDIcrydPKKiaszMnb9mNH+Y6Ianx1mvSLT35nBEF6Z4rJVERl26diOoo3I\\nF6WadIwTqcoLo5duUO3SaHKKLcoSEEaGkutuTCHcFOzhvZrXbuIyD567Vp5oVFe9\\nSHN10vceQQdWPh2UsKrVQfIdc70+9tlslka5X6BbIQKBgQDss/APs65NNev2lPdb\\nJzdd+0YwKEQXeENWkU1xJJkNH/wF0ZGuYxoKafZR0efs1LnrbaPfHveFCnUcDuXU\\nyDnzG2zMw1Q72F8eGHpLItPSh0ZkfSlN58uM1oYMdTFUE6ezlOYEnKIYdhjmQWiE\\nuEa1G4ZW0aX0NLICet597GnLKQKBgQDIyzRVbOOzOxGUgrWT0RPT12VVNCn7edn1\\nUWLKDl4L2uF8vE4g8WW7gwNkVbuO3VPKqdGuCBDfVyyysOOOCDN0IxSxDk3458VY\\n4I3jAuBcgDsixwC28l0QtFnz2yRuD2fsBhLnoSfsM/T2hNbf7atDtMQhbbgU37me\\nX+Ewtr+obwKBgCdbb/IcbUH3UknI0Sw95A3jZvNA7rl8TK4LMPY8IJq3E7+f7foy\\nDjVnEwbdwRN294b2zwWdb4iWiYxlyb9Mn54VlEyjudDNlFs7tLHjk5bw2TqCOSjz\\n/rtnPBi8L7yMHBlXC7v+k1E/6bn3bDqNLWyVrAuphk+Jp4OUDIShl6GpAoGAFIAC\\nmNIkMTFPqyzpIu1Oq+sq0lcgDiezpAMqJdzvpyAys0x6YYyjyVAn8X97Rau9GUzb\\nNnxmVJcO3jOHGAIoVqwaObVvKoFnOZq7gbjSdT82Smes4ADAlasEIAx4nK//+S3p\\nkjJ24/ut/9kyIuyd9qym9Y7BI4hv6AZ79EBEMwsCgYEAgXzq5+NCfJIi6Zduugym\\niUU3y/3CWc/pLhnw3XZ5r3M5fLXokLhLU6FsNflTpdcf2QoNL58mE0tanPqg09Xh\\n7fHWR/8rISt2TsMlqFjc5rQxWg8yRpdd5Ti/Ln8v7EV3RGbhFlOqlC9hiyqfyd7V\\nqZjZg4zUxPO1I8ae8hbGMWs=\\n-----END PRIVATE KEY-----\\n\",  \"client_email\": \"test@example.com\",  \"client_id\": \"111111111111111111111\",  \"auth_uri\": \"https://accounts.google.com/o/oauth2/auth\",  \"token_uri\": \"https://accounts.google.com/o/oauth2/token\",  \"auth_provider_x509_cert_url\": \"https://www.googleapis.com/oauth2/v1/certs\",  \"client_x509_cert_url\": \"https://www.googleapis.com/robot/v1/metadata/x509/toolsmiths-pcf-sa%40cf-spinnaker.iam.gserviceaccount.com\"}"));
        this.assertClientAuthenticationOfType(this.properties, GcpIamAuthentication.class);
    }

    @Test
    public void kuberneteAuthentication() throws IOException {
        Files.write(Paths.get("target", "token"), "token".getBytes(), new OpenOption[0]);
        this.properties.setAuthentication(VaultEnvironmentProperties.AuthenticationMethod.KUBERNETES);
        this.properties.getKubernetes().setRole("server");
        this.properties.getKubernetes().setServiceAccountTokenFile("target/token");
        this.assertClientAuthenticationOfType(this.properties, KubernetesAuthentication.class);
    }

    @Test
    public void pcfAuthentication() {
        this.properties.setAuthentication(VaultEnvironmentProperties.AuthenticationMethod.PCF);
        this.properties.getPcf().setRole("my-role");
        this.properties.getPcf().setInstanceKey((Resource)new ClassPathResource("configserver-test.yml"));
        this.properties.getPcf().setInstanceCertificate((Resource)new ClassPathResource("configserver-test.yml"));
        this.assertClientAuthenticationOfType(this.properties, PcfAuthentication.class);
    }

    @Test
    public void tokenAuthentication() {
        this.properties.setAuthentication(VaultEnvironmentProperties.AuthenticationMethod.TOKEN);
        this.properties.setToken("token");
        this.assertClientAuthenticationOfType(this.properties, TokenAuthentication.class);
    }

    @Test
    public void defaultSslConfiguration() {
        VaultEnvironmentProperties properties = new VaultEnvironmentProperties();
        SpringVaultClientConfiguration configuration = this.getConfiguration(properties);
        SslConfiguration sslConfiguration = configuration.sslConfiguration();
        Assertions.assertThat((Object)sslConfiguration.getKeyStoreConfiguration()).isEqualTo((Object)SslConfiguration.KeyStoreConfiguration.unconfigured());
        Assertions.assertThat((Object)sslConfiguration.getTrustStoreConfiguration()).isEqualTo((Object)SslConfiguration.KeyStoreConfiguration.unconfigured());
    }

    @Test
    public void customSslConfiguration() {
        VaultEnvironmentProperties properties = new VaultEnvironmentProperties();
        properties.getSsl().setKeyStore((Resource)new ClassPathResource("ssl-test.jks"));
        properties.getSsl().setKeyStorePassword("password");
        properties.getSsl().setTrustStore((Resource)new ClassPathResource("ssl-test.jks"));
        properties.getSsl().setTrustStorePassword("password");
        SpringVaultClientConfiguration configuration = this.getConfiguration(properties);
        SslConfiguration sslConfiguration = configuration.sslConfiguration();
        SslConfiguration.KeyStoreConfiguration keyStoreConfiguration = sslConfiguration.getKeyStoreConfiguration();
        SslConfiguration.KeyStoreConfiguration trustStoreConfiguration = sslConfiguration.getTrustStoreConfiguration();
        Assertions.assertThat((boolean)keyStoreConfiguration.isPresent()).isTrue();
        Assertions.assertThat((String)new String(keyStoreConfiguration.getStorePassword())).isEqualTo("password");
        Assertions.assertThat((boolean)trustStoreConfiguration.isPresent()).isTrue();
        Assertions.assertThat((String)new String(trustStoreConfiguration.getStorePassword())).isEqualTo("password");
    }

    @Test
    public void namespaceHeaderNotAddedWhenNamespaceNotConfigured() throws IOException {
        VaultEnvironmentProperties properties = new VaultEnvironmentProperties();
        SpringVaultClientConfiguration configuration = this.getConfiguration(properties);
        HttpRequest request = this.invokeInterceptors(configuration.restOperations());
        Assertions.assertThat((String)request.getHeaders().getFirst("X-Vault-Namespace")).isNull();
    }

    @Test
    public void namespaceInterceptorAddedWhenNamespaceConfigured() throws IOException {
        VaultEnvironmentProperties properties = new VaultEnvironmentProperties();
        properties.setNamespace("test-namespace");
        SpringVaultClientConfiguration configuration = this.getConfiguration(properties);
        HttpRequest request = this.invokeInterceptors(configuration.restOperations());
        Assertions.assertThat((String)request.getHeaders().getFirst("X-Vault-Namespace")).isEqualTo("test-namespace");
    }

    private HttpRequest invokeInterceptors(RestOperations restOperations) throws IOException {
        Assertions.assertThat((Object)restOperations).isInstanceOf(RestTemplate.class);
        RestTemplate restTemplate = (RestTemplate)restOperations;
        MockClientHttpRequest request = new MockClientHttpRequest();
        ClientHttpRequestExecution execution = (ClientHttpRequestExecution)Mockito.mock(ClientHttpRequestExecution.class);
        byte[] body = new byte[]{};
        for (ClientHttpRequestInterceptor interceptor : restTemplate.getInterceptors()) {
            interceptor.intercept((HttpRequest)request, body, execution);
        }
        return request;
    }

    private void assertClientAuthenticationOfType(VaultEnvironmentProperties properties, Class<? extends ClientAuthentication> type) {
        ClientAuthentication clientAuthentication = this.getConfiguration(properties).clientAuthentication();
        Assertions.assertThat((Object)clientAuthentication).isInstanceOf(type);
    }

    private SpringVaultClientConfiguration getConfiguration(VaultEnvironmentProperties properties) {
        SpringVaultClientConfiguration configuration = new SpringVaultClientConfiguration(properties, () -> null, this.authProviders);
        configuration.setApplicationContext((ApplicationContext)this.applicationContext);
        return configuration;
    }

    private String base64(String value) {
        return new String(Base64.getEncoder().encode(value.getBytes()));
    }

    @Test
    public void springVaultClientConfigurationIsAProxy() {
        ((WebApplicationContextRunner)((WebApplicationContextRunner)((WebApplicationContextRunner)new WebApplicationContextRunner().withPropertyValues(new String[]{"spring.profiles.active=vault"})).withConfiguration((Configurations)UserConfigurations.of((Class[])new Class[]{ConfigServerConfiguration.class}))).withConfiguration((Configurations)AutoConfigurations.of((Class[])new Class[]{ConfigServerAutoConfiguration.class}))).run(context -> ((AbstractObjectAssert)((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).getBean(SpringVaultClientConfiguration.class).isNotNull()).matches(svcc -> ClassUtils.isCglibProxyClassName((String)svcc.getClass().getName()), "is a proxy"));
    }
}

