/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment.vault;

import jakarta.servlet.http.HttpServletRequest;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.config.server.environment.EnvironmentWatch;
import org.springframework.cloud.config.server.environment.VaultEnvironmentProperties;
import org.springframework.cloud.config.server.environment.vault.SpringVaultClientConfiguration;
import org.springframework.cloud.config.server.environment.vault.SpringVaultEnvironmentRepository;
import org.springframework.cloud.config.server.environment.vault.SpringVaultEnvironmentRepositoryFactory;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.authentication.TokenAuthentication;
import org.springframework.vault.client.VaultEndpoint;
import org.springframework.vault.core.VaultKeyValueOperations;
import org.springframework.vault.core.VaultKeyValueOperationsSupport;
import org.springframework.vault.core.VaultTemplate;

public class SpringVaultEnvironmentRepositoryFactoryTests {
    @Test
    public void buildForVersion1() {
        VaultEnvironmentProperties properties = new VaultEnvironmentProperties();
        SpringVaultEnvironmentRepository environmentRepository = new SpringVaultEnvironmentRepositoryFactory(this.mockHttpRequest(), (EnvironmentWatch)new EnvironmentWatch.Default(), this.mockClientConfiguration()).build(properties);
        VaultKeyValueOperations keyValueTemplate = environmentRepository.getKeyValueTemplate();
        Assertions.assertThat((Comparable)keyValueTemplate.getApiVersion()).isEqualTo((Object)VaultKeyValueOperationsSupport.KeyValueBackend.KV_1);
    }

    @Test
    public void buildForVersion2() {
        VaultEnvironmentProperties properties = new VaultEnvironmentProperties();
        properties.setKvVersion(2);
        SpringVaultEnvironmentRepository environmentRepository = new SpringVaultEnvironmentRepositoryFactory(this.mockHttpRequest(), (EnvironmentWatch)new EnvironmentWatch.Default(), this.mockClientConfiguration()).build(properties);
        VaultKeyValueOperations keyValueTemplate = environmentRepository.getKeyValueTemplate();
        Assertions.assertThat((Comparable)keyValueTemplate.getApiVersion()).isEqualTo((Object)VaultKeyValueOperationsSupport.KeyValueBackend.KV_2);
    }

    private SpringVaultClientConfiguration mockClientConfiguration() {
        VaultTemplate vaultTemplate = new VaultTemplate(VaultEndpoint.create((String)"localhost", (int)8200), (ClientAuthentication)new TokenAuthentication("token"));
        SpringVaultClientConfiguration clientConfiguration = (SpringVaultClientConfiguration)Mockito.mock(SpringVaultClientConfiguration.class);
        Mockito.when((Object)clientConfiguration.vaultTemplate()).thenReturn((Object)vaultTemplate);
        return clientConfiguration;
    }

    private ObjectProvider<HttpServletRequest> mockHttpRequest() {
        ObjectProvider objectProvider = (ObjectProvider)Mockito.mock(ObjectProvider.class);
        Mockito.when((Object)((HttpServletRequest)objectProvider.getIfAvailable())).thenReturn(null);
        return objectProvider;
    }
}

