/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment.vault;

import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.environment.EnvironmentWatch;
import org.springframework.cloud.config.server.environment.VaultEnvironmentProperties;
import org.springframework.cloud.config.server.environment.vault.SpringVaultEnvironmentRepository;
import org.springframework.util.StringUtils;
import org.springframework.vault.core.VaultKeyValueOperations;
import org.springframework.vault.support.VaultResponse;

public class SpringVaultEnvironmentRepositoryTests {
    @Test
    public void testFindOneNoDefaultKey() {
        this.defaultKeyTest("", 2);
    }

    @Test
    public void testPathKey() {
        this.defaultKeyTest("mypath", 2);
    }

    @Test
    public void testPathKeyNotUsedWithVersionOne() {
        this.defaultKeyTest("mypath", 1);
    }

    private void defaultKeyTest(String myPathKey, int version) {
        Object path = "";
        if (StringUtils.hasText((String)myPathKey) && version == 2) {
            path = myPathKey + "/";
        }
        VaultKeyValueOperations keyValueTemplate = (VaultKeyValueOperations)Mockito.mock(VaultKeyValueOperations.class);
        Mockito.when((Object)keyValueTemplate.get((String)path + "myapp")).thenReturn((Object)this.withVaultResponse("foo", "bar"));
        Mockito.when((Object)keyValueTemplate.get((String)path + "application")).thenReturn((Object)this.withVaultResponse("def-foo", "def-bar"));
        VaultEnvironmentProperties properties = new VaultEnvironmentProperties();
        properties.setPathToKey(myPathKey);
        properties.setKvVersion(version);
        SpringVaultEnvironmentRepository repo = new SpringVaultEnvironmentRepository(this.mockHttpRequest(), (EnvironmentWatch)new EnvironmentWatch.Default(), properties, keyValueTemplate);
        Environment e = repo.findOne("myapp", null, null);
        ((AbstractStringAssert)Assertions.assertThat((String)e.getName()).as("Name should be the same as the application argument", new Object[0])).isEqualTo("myapp");
        ((ListAssert)Assertions.assertThat((List)e.getPropertySources()).as("Properties for specified application and default application with key 'application' should be returned", new Object[0])).hasSize(2);
        ((MapAssert)Assertions.assertThat((Map)((PropertySource)e.getPropertySources().get(0)).getSource()).as("Properties for specified application should be returned in priority position", new Object[0])).containsOnly(new Map.Entry[]{Assertions.entry((Object)"foo", (Object)"bar")});
        ((MapAssert)Assertions.assertThat((Map)((PropertySource)e.getPropertySources().get(1)).getSource()).as("Properties for default application with key 'application' should be returned in second position", new Object[0])).containsOnly(new Map.Entry[]{Assertions.entry((Object)"def-foo", (Object)"def-bar")});
    }

    @Test
    public void testBackendWithSlashes() {
        VaultKeyValueOperations keyValueTemplate = (VaultKeyValueOperations)Mockito.mock(VaultKeyValueOperations.class);
        Mockito.when((Object)keyValueTemplate.get("myapp")).thenReturn((Object)this.withVaultResponse("foo", "bar"));
        Mockito.when((Object)keyValueTemplate.get("application")).thenReturn((Object)this.withVaultResponse("def-foo", "def-bar"));
        VaultEnvironmentProperties properties = new VaultEnvironmentProperties();
        properties.setBackend("foo/bar/secret");
        SpringVaultEnvironmentRepository repo = new SpringVaultEnvironmentRepository(this.mockHttpRequest(), (EnvironmentWatch)new EnvironmentWatch.Default(), properties, keyValueTemplate);
        Environment e = repo.findOne("myapp", null, null);
        ((AbstractStringAssert)Assertions.assertThat((String)e.getName()).as("Name should be the same as the application argument", new Object[0])).isEqualTo("myapp");
        ((ListAssert)Assertions.assertThat((List)e.getPropertySources()).as("Properties for specified application and default application with key 'application' should be returned", new Object[0])).hasSize(2);
        ((MapAssert)Assertions.assertThat((Map)((PropertySource)e.getPropertySources().get(0)).getSource()).as("Properties for specified application should be returned in priority position", new Object[0])).containsOnly(new Map.Entry[]{Assertions.entry((Object)"foo", (Object)"bar")});
        ((MapAssert)Assertions.assertThat((Map)((PropertySource)e.getPropertySources().get(1)).getSource()).as("Properties for default application with key 'application' should be returned in second position", new Object[0])).containsOnly(new Map.Entry[]{Assertions.entry((Object)"def-foo", (Object)"def-bar")});
    }

    @Test
    public void testFindOneDefaultKeySetAndDifferentToApplication() {
        VaultKeyValueOperations keyValueTemplate = (VaultKeyValueOperations)Mockito.mock(VaultKeyValueOperations.class);
        Mockito.when((Object)keyValueTemplate.get("myapp")).thenReturn((Object)this.withVaultResponse("foo", "bar"));
        Mockito.when((Object)keyValueTemplate.get("mydefaultkey")).thenReturn((Object)this.withVaultResponse("def-foo", "def-bar"));
        SpringVaultEnvironmentRepository repo = new SpringVaultEnvironmentRepository(this.mockHttpRequest(), (EnvironmentWatch)new EnvironmentWatch.Default(), new VaultEnvironmentProperties(), keyValueTemplate);
        repo.setDefaultKey("mydefaultkey");
        Environment e = repo.findOne("myapp", null, null);
        ((AbstractStringAssert)Assertions.assertThat((String)e.getName()).as("Name should be the same as the application argument", new Object[0])).isEqualTo("myapp");
        ((ListAssert)Assertions.assertThat((List)e.getPropertySources()).as("Properties for specified application and default application with key 'mydefaultkey' should be returned", new Object[0])).hasSize(2);
        ((MapAssert)Assertions.assertThat((Map)((PropertySource)e.getPropertySources().get(0)).getSource()).as("Properties for specified application should be returned in priority position", new Object[0])).containsOnly(new Map.Entry[]{Assertions.entry((Object)"foo", (Object)"bar")});
        ((MapAssert)Assertions.assertThat((Map)((PropertySource)e.getPropertySources().get(1)).getSource()).as("Properties for default application with key 'mydefaultkey' should be returned in second position", new Object[0])).containsOnly(new Map.Entry[]{Assertions.entry((Object)"def-foo", (Object)"def-bar")});
    }

    @Test
    public void testFindOneDefaultKeySetAndDifferentToMultipleApplications() {
        VaultKeyValueOperations keyValueTemplate = (VaultKeyValueOperations)Mockito.mock(VaultKeyValueOperations.class);
        Mockito.when((Object)keyValueTemplate.get("myapp")).thenReturn((Object)this.withVaultResponse("myapp-foo", "myapp-bar"));
        Mockito.when((Object)keyValueTemplate.get("yourapp")).thenReturn((Object)this.withVaultResponse("yourapp-foo", "yourapp-bar"));
        Mockito.when((Object)keyValueTemplate.get("mydefaultkey")).thenReturn((Object)this.withVaultResponse("def-foo", "def-bar"));
        SpringVaultEnvironmentRepository repo = new SpringVaultEnvironmentRepository(this.mockHttpRequest(), (EnvironmentWatch)new EnvironmentWatch.Default(), new VaultEnvironmentProperties(), keyValueTemplate);
        repo.setDefaultKey("mydefaultkey");
        Environment e = repo.findOne("myapp,yourapp", null, null);
        ((AbstractStringAssert)Assertions.assertThat((String)e.getName()).as("Name should be the same as the application argument", new Object[0])).isEqualTo("myapp,yourapp");
        ((ListAssert)Assertions.assertThat((List)e.getPropertySources()).as("Properties for specified applications and default application with key 'mydefaultkey' should be returned", new Object[0])).hasSize(3);
        ((MapAssert)Assertions.assertThat((Map)((PropertySource)e.getPropertySources().get(0)).getSource()).as("Properties for first specified application should be returned in priority position", new Object[0])).containsOnly(new Map.Entry[]{Assertions.entry((Object)"yourapp-foo", (Object)"yourapp-bar")});
        ((MapAssert)Assertions.assertThat((Map)((PropertySource)e.getPropertySources().get(1)).getSource()).as("Properties for second specified application should be returned in priority position", new Object[0])).containsOnly(new Map.Entry[]{Assertions.entry((Object)"myapp-foo", (Object)"myapp-bar")});
        ((MapAssert)Assertions.assertThat((Map)((PropertySource)e.getPropertySources().get(2)).getSource()).as("Properties for default application with key 'mydefaultkey' should be returned in second position", new Object[0])).containsOnly(new Map.Entry[]{Assertions.entry((Object)"def-foo", (Object)"def-bar")});
    }

    @Test
    public void testFindOneDefaultKeySetAndEqualToApplication() {
        VaultKeyValueOperations keyValueTemplate = (VaultKeyValueOperations)Mockito.mock(VaultKeyValueOperations.class);
        Mockito.when((Object)keyValueTemplate.get("myapp")).thenReturn((Object)this.withVaultResponse("foo", "bar"));
        Mockito.when((Object)keyValueTemplate.get("application")).thenReturn((Object)this.withVaultResponse("def-foo", "def-bar"));
        SpringVaultEnvironmentRepository repo = new SpringVaultEnvironmentRepository(this.mockHttpRequest(), (EnvironmentWatch)new EnvironmentWatch.Default(), new VaultEnvironmentProperties(), keyValueTemplate);
        repo.setDefaultKey("myapp");
        Environment e = repo.findOne("myapp", null, null);
        ((AbstractStringAssert)Assertions.assertThat((String)e.getName()).as("Name should be the same as the application argument", new Object[0])).isEqualTo("myapp");
        ((ListAssert)Assertions.assertThat((List)e.getPropertySources()).as("Only properties for specified application should be returned", new Object[0])).hasSize(1);
        ((MapAssert)Assertions.assertThat((Map)((PropertySource)e.getPropertySources().get(0)).getSource()).as("Properties should be returned for specified application", new Object[0])).containsOnly(new Map.Entry[]{Assertions.entry((Object)"foo", (Object)"bar")});
    }

    @Test
    public void testVaultVersioning() {
        VaultKeyValueOperations keyValueTemplate = (VaultKeyValueOperations)Mockito.mock(VaultKeyValueOperations.class);
        Mockito.when((Object)keyValueTemplate.get("myapp")).thenReturn((Object)this.withVaultResponse("foo", "bar"));
        Mockito.when((Object)keyValueTemplate.get("application")).thenReturn((Object)this.withVaultResponse("def-foo", "def-bar"));
        VaultEnvironmentProperties vaultEnvironmentProperties = new VaultEnvironmentProperties();
        vaultEnvironmentProperties.setKvVersion(2);
        SpringVaultEnvironmentRepository repo = new SpringVaultEnvironmentRepository(this.mockHttpRequest(), (EnvironmentWatch)new EnvironmentWatch.Default(), vaultEnvironmentProperties, keyValueTemplate);
        Environment e = repo.findOne("myapp", null, null);
        ((AbstractStringAssert)Assertions.assertThat((String)e.getName()).as("Name should be the same as the application argument", new Object[0])).isEqualTo("myapp");
        ((ListAssert)Assertions.assertThat((List)e.getPropertySources()).as("Properties for specified application and default application with key 'application' should be returned", new Object[0])).hasSize(2);
        ((MapAssert)Assertions.assertThat((Map)((PropertySource)e.getPropertySources().get(0)).getSource()).as("Properties for specified application should be returned in priority position", new Object[0])).containsOnly(new Map.Entry[]{Assertions.entry((Object)"foo", (Object)"bar")});
    }

    private VaultResponse withVaultResponse(String key, Object value) {
        HashMap<String, Object> responseData = new HashMap<String, Object>();
        responseData.put(key, value);
        VaultResponse response = new VaultResponse();
        response.setData(responseData);
        return response;
    }

    private ObjectProvider<HttpServletRequest> mockHttpRequest() {
        ObjectProvider objectProvider = (ObjectProvider)Mockito.mock(ObjectProvider.class);
        Mockito.when((Object)((HttpServletRequest)objectProvider.getIfAvailable())).thenReturn(null);
        return objectProvider;
    }
}

