/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment.vault.authentication;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.config.server.environment.VaultEnvironmentProperties;
import org.springframework.cloud.config.server.environment.vault.authentication.AppRoleClientAuthenticationProvider;
import org.springframework.vault.authentication.AppRoleAuthenticationOptions;
import org.springframework.vault.support.VaultToken;

class AppRoleClientAuthenticationProviderTests {
    AppRoleClientAuthenticationProviderTests() {
    }

    @Test
    public void appRoleRoleIdProvidedSecretIdProvided() {
        VaultEnvironmentProperties properties = new VaultEnvironmentProperties();
        properties.getAppRole().setRoleId("foo");
        properties.getAppRole().setSecretId("bar");
        AppRoleAuthenticationOptions options = AppRoleClientAuthenticationProvider.getAppRoleAuthenticationOptions((VaultEnvironmentProperties)properties);
        Assertions.assertThat((Object)options.getRoleId()).isInstanceOf(AppRoleAuthenticationOptions.RoleId.provided((String)"foo").getClass());
        Assertions.assertThat((Object)options.getSecretId()).isInstanceOf(AppRoleAuthenticationOptions.SecretId.provided((String)"bar").getClass());
    }

    @Test
    public void appRoleRoleIdProvidedSecretIdAbsent() {
        VaultEnvironmentProperties properties = new VaultEnvironmentProperties();
        properties.getAppRole().setRoleId("foo");
        AppRoleAuthenticationOptions options = AppRoleClientAuthenticationProvider.getAppRoleAuthenticationOptions((VaultEnvironmentProperties)properties);
        Assertions.assertThat((Object)options.getRoleId()).isInstanceOf(AppRoleAuthenticationOptions.RoleId.provided((String)"foo").getClass());
        Assertions.assertThat((Object)options.getSecretId()).isInstanceOf(AppRoleAuthenticationOptions.SecretId.absent().getClass());
    }

    @Test
    public void appRoleRoleIdProvidedSecretIdPull() {
        VaultEnvironmentProperties properties = new VaultEnvironmentProperties();
        properties.setToken("token");
        properties.getAppRole().setRoleId("foo");
        properties.getAppRole().setRole("my-role");
        AppRoleAuthenticationOptions options = AppRoleClientAuthenticationProvider.getAppRoleAuthenticationOptions((VaultEnvironmentProperties)properties);
        Assertions.assertThat((String)options.getAppRole()).isEqualTo("my-role");
        Assertions.assertThat((Object)options.getRoleId()).isInstanceOf(AppRoleAuthenticationOptions.RoleId.provided((String)"foo").getClass());
        Assertions.assertThat((Object)options.getSecretId()).isInstanceOf(AppRoleAuthenticationOptions.SecretId.pull((VaultToken)VaultToken.of((String)"token")).getClass());
    }

    @Test
    public void appRoleWithFullPull() {
        VaultEnvironmentProperties properties = new VaultEnvironmentProperties();
        properties.setToken("token");
        properties.getAppRole().setRole("my-role");
        AppRoleAuthenticationOptions options = AppRoleClientAuthenticationProvider.getAppRoleAuthenticationOptions((VaultEnvironmentProperties)properties);
        Assertions.assertThat((String)options.getAppRole()).isEqualTo("my-role");
        Assertions.assertThat((Object)options.getRoleId()).isInstanceOf(AppRoleAuthenticationOptions.RoleId.pull((VaultToken)VaultToken.of((String)"token")).getClass());
        Assertions.assertThat((Object)options.getSecretId()).isInstanceOf(AppRoleAuthenticationOptions.SecretId.pull((VaultToken)VaultToken.of((String)"token")).getClass());
    }

    @Test
    public void appRoleFullWrapped() {
        VaultEnvironmentProperties properties = new VaultEnvironmentProperties();
        properties.setToken("token");
        AppRoleAuthenticationOptions options = AppRoleClientAuthenticationProvider.getAppRoleAuthenticationOptions((VaultEnvironmentProperties)properties);
        Assertions.assertThat((Object)options.getRoleId()).isInstanceOf(AppRoleAuthenticationOptions.RoleId.wrapped((VaultToken)VaultToken.of((String)"token")).getClass());
        Assertions.assertThat((Object)options.getSecretId()).isInstanceOf(AppRoleAuthenticationOptions.SecretId.wrapped((VaultToken)VaultToken.of((String)"token")).getClass());
    }

    @Test
    public void appRoleRoleIdWrappedSecretIdProvided() {
        VaultEnvironmentProperties properties = new VaultEnvironmentProperties();
        properties.setToken("token");
        properties.getAppRole().setSecretId("bar");
        AppRoleAuthenticationOptions options = AppRoleClientAuthenticationProvider.getAppRoleAuthenticationOptions((VaultEnvironmentProperties)properties);
        Assertions.assertThat((Object)options.getRoleId()).isInstanceOf(AppRoleAuthenticationOptions.RoleId.wrapped((VaultToken)VaultToken.of((String)"token")).getClass());
        Assertions.assertThat((Object)options.getSecretId()).isInstanceOf(AppRoleAuthenticationOptions.SecretId.provided((String)"bar").getClass());
    }

    @Test
    public void appRoleRoleIdProvidedSecretIdWrapped() {
        VaultEnvironmentProperties properties = new VaultEnvironmentProperties();
        properties.setToken("token");
        properties.getAppRole().setRoleId("foo");
        AppRoleAuthenticationOptions options = AppRoleClientAuthenticationProvider.getAppRoleAuthenticationOptions((VaultEnvironmentProperties)properties);
        Assertions.assertThat((Object)options.getRoleId()).isInstanceOf(AppRoleAuthenticationOptions.RoleId.provided((String)"foo").getClass());
        Assertions.assertThat((Object)options.getSecretId()).isInstanceOf(AppRoleAuthenticationOptions.SecretId.wrapped((VaultToken)VaultToken.of((String)"token")).getClass());
    }

    @Test
    public void appRoleWithUnconfiguredRoleId() {
        VaultEnvironmentProperties properties = new VaultEnvironmentProperties();
        Assertions.assertThatThrownBy(() -> AppRoleClientAuthenticationProvider.getAppRoleAuthenticationOptions((VaultEnvironmentProperties)properties)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void appRoleWithUnconfiguredRoleIdIfRoleNameSet() {
        VaultEnvironmentProperties properties = new VaultEnvironmentProperties();
        properties.getAppRole().setRole("my-role");
        Assertions.assertThatThrownBy(() -> AppRoleClientAuthenticationProvider.getAppRoleAuthenticationOptions((VaultEnvironmentProperties)properties)).isInstanceOf(IllegalArgumentException.class);
    }
}

