/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.proxy;

import java.util.Map;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.config.server.proxy.ProxyHostCredentialsProvider;
import org.springframework.cloud.config.server.proxy.ProxyHostProperties;
import org.springframework.test.util.ReflectionTestUtils;

class ProxyHostCredentialsProviderTest {
    ProxyHostCredentialsProviderTest() {
    }

    @Test
    void should_take_only_proxy_with_connection_and_credentials_information_provided() {
        ProxyHostProperties withoutConnection = this.proxyHost(null, 0, "user", "password");
        ProxyHostProperties withoutCredentials = this.proxyHost("bad.proxy", 666, null, null);
        ProxyHostProperties goodProxy = this.proxyHost("good.proxy", 888, "user", "P@s$W0rd!");
        ProxyHostCredentialsProvider provider = new ProxyHostCredentialsProvider(new ProxyHostProperties[]{withoutConnection, withoutCredentials, goodProxy});
        Map credentials = (Map)ReflectionTestUtils.getField((Object)provider, (String)"credMap");
        Assertions.assertThat((Map)credentials).hasSize(1);
        Map.Entry entry = credentials.entrySet().iterator().next();
        Assertions.assertThat((String)((AuthScope)entry.getKey()).getHost()).isEqualTo("good.proxy");
        Assertions.assertThat((int)((AuthScope)entry.getKey()).getPort()).isEqualTo(888);
        Assertions.assertThat((String)((Credentials)entry.getValue()).getUserPrincipal().getName()).isEqualTo("user");
        Assertions.assertThat((String)new String(((Credentials)entry.getValue()).getPassword())).isEqualTo("P@s$W0rd!");
    }

    private ProxyHostProperties proxyHost(String host, int port, String username, String password) {
        ProxyHostProperties result = new ProxyHostProperties();
        result.setHost(host);
        result.setPort(port);
        result.setUsername(username);
        result.setPassword(password);
        return result;
    }
}

