/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.proxy;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.config.server.proxy.ProxyHostProperties;

class ProxyHostPropertiesTest {
    ProxyHostPropertiesTest() {
    }

    @Test
    void connectionInformationProvided_should_return_false_when_host_is_null() {
        ProxyHostProperties properties = this.proxyHost(null, 8080);
        boolean result = properties.connectionInformationProvided();
        Assertions.assertThat((boolean)result).isFalse();
    }

    @Test
    void connectionInformationProvided_should_return_false_when_host_is_empty() {
        ProxyHostProperties properties = this.proxyHost("", 8080);
        boolean result = properties.connectionInformationProvided();
        Assertions.assertThat((boolean)result).isFalse();
    }

    @Test
    void connectionInformationProvided_should_return_false_when_port_is_null() {
        ProxyHostProperties properties = this.proxyHost("host.address", 0);
        boolean result = properties.connectionInformationProvided();
        Assertions.assertThat((boolean)result).isFalse();
    }

    @Test
    void connectionInformationProvided_should_return_true_when_port_is_filled_and_port_positive() {
        ProxyHostProperties properties = this.proxyHost("host.address", 8080);
        boolean result = properties.connectionInformationProvided();
        Assertions.assertThat((boolean)result).isTrue();
    }

    @Test
    void authenticationProvided_should_return_false_if_username_is_null() {
        ProxyHostProperties properties = this.proxyHostWithCredentials(null, "P@s$W0rD!");
        boolean result = properties.authenticationProvided();
        Assertions.assertThat((boolean)result).isFalse();
    }

    @Test
    void authenticationProvided_should_return_false_if_password_is_null() {
        ProxyHostProperties properties = this.proxyHostWithCredentials("username", null);
        boolean result = properties.authenticationProvided();
        Assertions.assertThat((boolean)result).isFalse();
    }

    @Test
    void authenticationProvided_should_return_true_if_username_and_password_are_provided() {
        ProxyHostProperties properties = this.proxyHostWithCredentials("username", "P@s$W0rD!");
        boolean result = properties.authenticationProvided();
        Assertions.assertThat((boolean)result).isTrue();
    }

    private ProxyHostProperties proxyHost(String host, int port) {
        ProxyHostProperties properties = new ProxyHostProperties();
        properties.setHost(host);
        properties.setPort(port);
        return properties;
    }

    private ProxyHostProperties proxyHostWithCredentials(String username, String password) {
        ProxyHostProperties properties = new ProxyHostProperties();
        properties.setUsername(username);
        properties.setPassword(password);
        return properties;
    }
}

