/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.proxy;

import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.cloud.config.server.proxy.ProxyHostProperties;
import org.springframework.cloud.config.server.proxy.SchemeBasedRoutePlanner;

class SchemeBasedRoutePlannerTest {
    private static final ProxyHostProperties SECURED_PROXY_PROPERTIES = SchemeBasedRoutePlannerTest.buildProxyProperties("http.host", 8080);
    private static final ProxyHostProperties UNSECURED_PROXY_PROPERTIES = SchemeBasedRoutePlannerTest.buildProxyProperties("https.host", 8443);

    SchemeBasedRoutePlannerTest() {
    }

    @Test
    void determineProxy_should_return_https_proxy_when_target_scheme_name_is_https_and_https_proxy_provided() {
        SchemeBasedRoutePlanner planner = new SchemeBasedRoutePlanner(SECURED_PROXY_PROPERTIES, UNSECURED_PROXY_PROPERTIES);
        HttpHost result = planner.determineProxy(this.target("https"), this.anyContext());
        Assertions.assertThat((String)result.getSchemeName()).isEqualTo("https");
        Assertions.assertThat((String)result.getHostName()).isEqualTo(SECURED_PROXY_PROPERTIES.getHost());
        Assertions.assertThat((int)result.getPort()).isEqualTo(SECURED_PROXY_PROPERTIES.getPort());
    }

    @Test
    void determineProxy_should_return_https_proxy_when_target_scheme_name_is_http_and_no_http_proxy_specified() {
        SchemeBasedRoutePlanner planner = new SchemeBasedRoutePlanner(SECURED_PROXY_PROPERTIES, null);
        HttpHost result = planner.determineProxy(this.target("http"), this.anyContext());
        Assertions.assertThat((String)result.getSchemeName()).isEqualTo("https");
        Assertions.assertThat((String)result.getHostName()).isEqualTo(SECURED_PROXY_PROPERTIES.getHost());
        Assertions.assertThat((int)result.getPort()).isEqualTo(SECURED_PROXY_PROPERTIES.getPort());
    }

    @Test
    void determineProxy_should_return_http_proxy_when_target_scheme_name_is_http_and_http_proxy_provided() {
        SchemeBasedRoutePlanner planner = new SchemeBasedRoutePlanner(SECURED_PROXY_PROPERTIES, UNSECURED_PROXY_PROPERTIES);
        HttpHost result = planner.determineProxy(this.target("http"), this.anyContext());
        Assertions.assertThat((String)result.getSchemeName()).isEqualTo("http");
        Assertions.assertThat((String)result.getHostName()).isEqualTo(UNSECURED_PROXY_PROPERTIES.getHost());
        Assertions.assertThat((int)result.getPort()).isEqualTo(UNSECURED_PROXY_PROPERTIES.getPort());
    }

    @Test
    void determineProxy_should_return_http_proxy_when_target_scheme_name_is_https_and_https_proxy_provided() {
        SchemeBasedRoutePlanner planner = new SchemeBasedRoutePlanner(null, UNSECURED_PROXY_PROPERTIES);
        HttpHost result = planner.determineProxy(this.target("https"), this.anyContext());
        Assertions.assertThat((String)result.getSchemeName()).isEqualTo("http");
        Assertions.assertThat((String)result.getHostName()).isEqualTo(UNSECURED_PROXY_PROPERTIES.getHost());
        Assertions.assertThat((int)result.getPort()).isEqualTo(UNSECURED_PROXY_PROPERTIES.getPort());
    }

    @Test
    void determineProxy_should_return_null_when_provided_proxies_are_incomplete() {
        SchemeBasedRoutePlanner planner = new SchemeBasedRoutePlanner(SchemeBasedRoutePlannerTest.buildProxyProperties("", 777), SchemeBasedRoutePlannerTest.buildProxyProperties("host", 0));
        HttpHost result = planner.determineProxy(this.target("https"), this.anyContext());
        Assertions.assertThat((Object)result).isNull();
    }

    private HttpHost target(String scheme) {
        HttpHost host = (HttpHost)Mockito.mock(HttpHost.class);
        Mockito.when((Object)host.getSchemeName()).thenReturn((Object)scheme);
        return host;
    }

    private HttpContext anyContext() {
        return (HttpContext)Mockito.mock(HttpContext.class);
    }

    private static ProxyHostProperties buildProxyProperties(String host, int port) {
        ProxyHostProperties properties = new ProxyHostProperties();
        properties.setHost(host);
        properties.setPort(port);
        return properties;
    }
}

