/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.resource;

import io.micrometer.observation.ObservationRegistry;
import java.io.IOException;
import java.net.URL;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.test.system.CapturedOutput;
import org.springframework.boot.test.system.OutputCaptureExtension;
import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.config.server.environment.AwsS3EnvironmentRepository;
import org.springframework.cloud.config.server.environment.NativeEnvironmentProperties;
import org.springframework.cloud.config.server.environment.NativeEnvironmentRepository;
import org.springframework.cloud.config.server.environment.NativeEnvironmentRepositoryTests;
import org.springframework.cloud.config.server.environment.SearchPathLocator;
import org.springframework.cloud.config.server.resource.GenericResourceRepository;
import org.springframework.cloud.config.server.resource.NoSuchResourceException;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import software.amazon.awssdk.services.s3.S3Client;

@ExtendWith(value={OutputCaptureExtension.class})
public class GenericResourceRepositoryTests {
    private GenericResourceRepository repository;
    private ConfigurableApplicationContext context;
    private NativeEnvironmentRepository nativeRepository;

    @AfterEach
    public void close() {
        if (this.context != null) {
            this.context.close();
        }
    }

    @BeforeEach
    public void init() {
        this.context = new SpringApplicationBuilder(new Class[]{NativeEnvironmentRepositoryTests.class}).web(WebApplicationType.NONE).run(new String[0]);
        this.nativeRepository = new NativeEnvironmentRepository(this.context.getEnvironment(), new NativeEnvironmentProperties(), ObservationRegistry.NOOP);
        this.repository = new GenericResourceRepository((SearchPathLocator)this.nativeRepository);
        this.repository.setResourceLoader((ResourceLoader)this.context);
        this.context.close();
    }

    @Test
    public void locateResource() {
        Assertions.assertThat((Object)this.repository.findOne("blah", "default", "master", "foo.properties")).isNotNull();
    }

    @Test
    public void locateProfiledResource() {
        Assertions.assertThat((Object)this.repository.findOne("blah", "local", "master", "foo.txt")).isNotNull();
    }

    @Test
    public void locateProfiledResourceWithPlaceholder() {
        this.nativeRepository.setSearchLocations(new String[]{"classpath:/test/{profile}"});
        Assertions.assertThat((Object)this.repository.findOne("blah", "local", "master", "foo.txt")).isNotNull();
    }

    @Test
    public void locateMissingResource() {
        Assertions.assertThatThrownBy(() -> Assertions.assertThat((Object)this.repository.findOne("blah", "default", "master", "foo.txt")).isNotNull()).isInstanceOf(NoSuchResourceException.class);
    }

    @Test
    public void invalidPath(CapturedOutput capturedOutput) {
        Assertions.assertThatThrownBy(() -> {
            this.nativeRepository.setSearchLocations(new String[]{"file:./src/test/resources/test/{profile}"});
            this.repository.findOne("blah", "local", "master", "..%2F..%2Fdata-jdbc.sql");
        }).isInstanceOf(NoSuchResourceException.class);
        Assertions.assertThat((String)capturedOutput.getAll()).contains(new CharSequence[]{"Path contains \"../\" after call to StringUtils#cleanPath"});
    }

    @Test
    public void invalidPathWithPreviousDirectory(CapturedOutput capturedOutput) {
        this.testInvalidPath("../", capturedOutput);
    }

    @Test
    public void invalidPathWithPreviousDirectoryEncodedSlash(CapturedOutput capturedOutput) {
        this.testInvalidPath("..%2F", capturedOutput);
    }

    @Test
    public void invalidPathWithPreviousDirectoryAllEncoded(CapturedOutput capturedOutput) {
        this.testInvalidPath("%2E%2E%2F", capturedOutput);
    }

    @Test
    public void invalidPathEncodedSlash(CapturedOutput capturedOutput) {
        Assertions.assertThatThrownBy(() -> {
            Object file = System.getProperty("user.dir");
            file = ((String)file).replaceFirst("\\/", "%2f");
            file = (String)file + "/src/test/resources/ssh/key";
            this.nativeRepository.setSearchLocations(new String[]{"file:./"});
            this.repository.findOne("blah", "local", "master", (String)file);
        }).isInstanceOf(NoSuchResourceException.class);
        Assertions.assertThat((String)capturedOutput.getAll()).contains(new CharSequence[]{"is neither under the current location"});
    }

    private void testInvalidPath(String label, CapturedOutput capturedOutput) {
        Assertions.assertThatThrownBy(() -> {
            this.nativeRepository.setSearchLocations(new String[]{"file:./src/test/resources/test/local"});
            this.repository.findOne("blah", "local", label, "foo.properties");
        }).isInstanceOf(NoSuchResourceException.class);
        Assertions.assertThat((String)capturedOutput.getAll()).contains(new CharSequence[]{"Location contains \"..\""});
    }

    @Test
    public void tests3() throws IOException {
        S3Client s3 = (S3Client)Mockito.mock(S3Client.class);
        AwsS3EnvironmentRepository awsS3EnvironmentRepository = new AwsS3EnvironmentRepository(s3, "test", new ConfigServerProperties());
        GenericResourceRepository genericResourceRepository = new GenericResourceRepository((SearchPathLocator)awsS3EnvironmentRepository);
        genericResourceRepository.setResourceLoader(new ResourceLoader(){

            public Resource getResource(String location) {
                Resource relativeResource = (Resource)Mockito.mock(Resource.class);
                Mockito.when((Object)relativeResource.exists()).thenReturn((Object)true);
                Mockito.when((Object)relativeResource.isReadable()).thenReturn((Object)true);
                Resource resource = null;
                try {
                    Mockito.when((Object)relativeResource.getURL()).thenReturn((Object)new URL("https://us-east-1/test/main%2Fdata.json"));
                    resource = (Resource)Mockito.mock(Resource.class);
                    Mockito.when((Object)resource.getURL()).thenReturn((Object)new URL("https://us-east-1/test"));
                    Mockito.when((Object)resource.createRelative((String)ArgumentMatchers.eq((Object)"data.json"))).thenReturn((Object)relativeResource);
                }
                catch (IOException e) {
                    Assertions.fail((String)"Exception thrown", (Throwable)e);
                }
                return resource;
            }

            public ClassLoader getClassLoader() {
                return null;
            }
        });
        Resource resource = genericResourceRepository.findOne("app", "default", "main", "data.json");
        Assertions.assertThat((URL)resource.getURL()).isEqualTo((Object)new URL("https://us-east-1/test/main%2Fdata.json"));
    }
}

