/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.resource;

import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.boot.test.web.server.LocalServerPort;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.server.encryption.ResourceEncryptor;
import org.springframework.cloud.config.server.environment.EnvironmentController;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.NoSuchLabelException;
import org.springframework.cloud.config.server.resource.NoSuchResourceException;
import org.springframework.cloud.config.server.resource.ResourceController;
import org.springframework.cloud.config.server.resource.ResourceControllerAdvice;
import org.springframework.cloud.config.server.resource.ResourceRepository;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

@SpringBootTest(classes={ControllerConfiguration.class}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
public class ResourceControllerIntegrationTests {
    @Autowired
    private WebApplicationContext context;
    private MockMvc mvc;
    @Autowired
    private EnvironmentRepository repository;
    @Autowired
    private ResourceRepository resources;
    @LocalServerPort
    int port;

    @BeforeEach
    public void init() {
        Mockito.reset((Object[])new Object[]{this.repository, this.resources});
        this.mvc = MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.context).build();
    }

    @Test
    public void environmentNoLabel() throws Exception {
        Mockito.when((Object)this.repository.findOne("foo", "default", "master", false)).thenReturn((Object)new Environment("foo", new String[]{"default"}));
        Mockito.when((Object)this.resources.findOne("foo", "default", "master", "foo.txt")).thenReturn((Object)new ClassPathResource("resource-controller/foo.txt"));
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/foo/default/master/foo.txt", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        ((EnvironmentRepository)Mockito.verify((Object)this.repository)).findOne("foo", "default", "master", false);
        ((ResourceRepository)Mockito.verify((Object)this.resources)).findOne("foo", "default", "master", "foo.txt");
    }

    @Test
    public void resource() throws Exception {
        Mockito.when((Object)this.repository.findOne("foo", "default", "master", false)).thenReturn((Object)new Environment("foo", new String[]{"default", "master"}));
        Mockito.when((Object)this.resources.findOne("foo", "default", "master", "foo.txt")).thenReturn((Object)new ClassPathResource("resource-controller/foo.txt"));
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/foo/default/master/foo.txt", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        ((EnvironmentRepository)Mockito.verify((Object)this.repository)).findOne("foo", "default", "master", false);
        ((ResourceRepository)Mockito.verify((Object)this.resources)).findOne("foo", "default", "master", "foo.txt");
    }

    @Test
    public void resourceHttp() throws Exception {
        Mockito.when((Object)this.repository.findOne("foo", "default", "master", false)).thenReturn((Object)new Environment("foo", new String[]{"default", "master"}));
        Mockito.when((Object)this.resources.findOne("foo", "default", "master", "foo.txt")).thenReturn((Object)new ClassPathResource("resource-controller/foo.txt"));
        ResponseEntity response = new TestRestTemplate(new TestRestTemplate.HttpClientOption[0]).getForEntity("http://localhost:" + this.port + "/foo/default/master/foo.txt", String.class, new Object[0]);
        Assertions.assertThat((Object)response.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        ((EnvironmentRepository)Mockito.verify((Object)this.repository)).findOne("foo", "default", "master", false);
        ((ResourceRepository)Mockito.verify((Object)this.resources)).findOne("foo", "default", "master", "foo.txt");
    }

    @Test
    public void resourceHttpDoesNotExist() throws Exception {
        Mockito.when((Object)this.resources.findOne("foo", "default", "master", "doesNotExist.txt")).thenThrow(new Throwable[]{new NoSuchResourceException("Does not exist")});
        ResponseEntity response = new TestRestTemplate(new TestRestTemplate.HttpClientOption[0]).getForEntity("http://localhost:" + this.port + "/foo/default/master/doesNotExist.txt", String.class, new Object[0]);
        Assertions.assertThat((Object)response.getStatusCode()).isEqualTo((Object)HttpStatus.NOT_FOUND);
        ((ResourceRepository)Mockito.verify((Object)this.resources)).findOne("foo", "default", "master", "doesNotExist.txt");
    }

    @Test
    public void resourceNoLabel() throws Exception {
        Mockito.when((Object)this.repository.findOne("foo", "default", null, false)).thenReturn((Object)new Environment("foo", new String[]{"default", "master"}));
        Mockito.when((Object)this.resources.findOne("foo", "default", null, "foo.txt")).thenReturn((Object)new ClassPathResource("resource-controller/foo.txt"));
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/foo/default/foo.txt", (Object[])new Object[0]).param("useDefaultLabel", new String[]{""})).andExpect(MockMvcResultMatchers.status().isOk());
        ((EnvironmentRepository)Mockito.verify((Object)this.repository)).findOne("foo", "default", null, false);
        ((ResourceRepository)Mockito.verify((Object)this.resources)).findOne("foo", "default", null, "foo.txt");
    }

    @Test
    public void resourceNoLabelHttp() throws Exception {
        Mockito.when((Object)this.repository.findOne("foo", "default", null, false)).thenReturn((Object)new Environment("foo", new String[]{"default", "master"}));
        Mockito.when((Object)this.resources.findOne("foo", "default", null, "foo.txt")).thenReturn((Object)new ClassPathResource("resource-controller/foo.txt"));
        ResponseEntity response = new TestRestTemplate(new TestRestTemplate.HttpClientOption[0]).getForEntity("http://localhost:" + this.port + "/foo/default/foo.txt?useDefaultLabel", String.class, new Object[0]);
        Assertions.assertThat((Object)response.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        ((EnvironmentRepository)Mockito.verify((Object)this.repository)).findOne("foo", "default", null, false);
        ((ResourceRepository)Mockito.verify((Object)this.resources)).findOne("foo", "default", null, "foo.txt");
    }

    @Test
    public void binaryResourceNoLabel() throws Exception {
        Mockito.when((Object)this.repository.findOne("foo", "default", null)).thenReturn((Object)new Environment("foo", new String[]{"default", "master"}));
        Mockito.when((Object)this.resources.findOne("foo", "default", null, "foo.txt")).thenReturn((Object)new ClassPathResource("resource-controller/foo.txt"));
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/foo/default/foo.txt", (Object[])new Object[0]).param("useDefaultLabel", new String[]{""}).header("Accept", new Object[]{"application/octet-stream"})).andExpect(MockMvcResultMatchers.status().isOk());
        ((EnvironmentRepository)Mockito.verify((Object)this.repository)).findOne("foo", "default", null);
        ((ResourceRepository)Mockito.verify((Object)this.resources)).findOne("foo", "default", null, "foo.txt");
    }

    @Test
    public void resourceWithMissingLabel() throws Exception {
        Mockito.when((Object)this.resources.findOne("foo", "default", "missing", "foo.txt")).thenThrow(new Throwable[]{new NoSuchLabelException("Planned")});
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/foo/default/missing/foo.txt", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @SpringBootConfiguration
    @EnableAutoConfiguration
    public static class ControllerConfiguration {
        @Autowired(required=false)
        private Map<String, ResourceEncryptor> resourceEncryptorMap = new HashMap<String, ResourceEncryptor>();

        @Bean
        public EnvironmentRepository environmentRepository() {
            EnvironmentRepository repository = (EnvironmentRepository)Mockito.mock(EnvironmentRepository.class);
            return repository;
        }

        @Bean
        public ResourceRepository resourceRepository() {
            ResourceRepository repository = (ResourceRepository)Mockito.mock(ResourceRepository.class);
            return repository;
        }

        @Bean
        public EnvironmentController environmentController() {
            return new EnvironmentController(this.environmentRepository());
        }

        @Bean
        public ResourceController resourceController() {
            return new ResourceController(this.resourceRepository(), this.environmentRepository(), this.resourceEncryptorMap);
        }

        @Bean
        public ResourceControllerAdvice resourceControllerAdvice() {
            return new ResourceControllerAdvice();
        }
    }
}

