/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.resource;

import io.micrometer.observation.ObservationRegistry;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.server.encryption.ResourceEncryptor;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.NativeEnvironmentProperties;
import org.springframework.cloud.config.server.environment.NativeEnvironmentRepository;
import org.springframework.cloud.config.server.environment.NativeEnvironmentRepositoryTests;
import org.springframework.cloud.config.server.environment.SearchPathLocator;
import org.springframework.cloud.config.server.resource.GenericResourceRepository;
import org.springframework.cloud.config.server.resource.ResourceController;
import org.springframework.cloud.config.server.resource.ResourceRepository;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.ResourceLoader;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.web.context.request.ServletWebRequest;

public class ResourceControllerTests {
    private ResourceController controller;
    private GenericResourceRepository repository;
    private ConfigurableApplicationContext context;
    private NativeEnvironmentRepository environmentRepository;
    private Map<String, ResourceEncryptor> resourceEncryptorMap = (Map)Mockito.mock(Map.class);

    @AfterEach
    public void close() {
        if (this.context != null) {
            this.context.close();
        }
    }

    @BeforeEach
    public void init() {
        this.context = new SpringApplicationBuilder(new Class[]{NativeEnvironmentRepositoryTests.class}).web(WebApplicationType.NONE).run(new String[0]);
        this.environmentRepository = new NativeEnvironmentRepository(this.context.getEnvironment(), new NativeEnvironmentProperties(), ObservationRegistry.NOOP);
        this.repository = new GenericResourceRepository((SearchPathLocator)this.environmentRepository);
        this.repository.setResourceLoader((ResourceLoader)this.context);
        this.controller = new ResourceController((ResourceRepository)this.repository, (EnvironmentRepository)this.environmentRepository, this.resourceEncryptorMap);
        this.context.close();
    }

    @Test
    @Disabled
    public void templateReplacement() throws Exception {
        this.environmentRepository.setSearchLocations(new String[]{"classpath:/test"});
        String resource = this.controller.retrieve("foo", "bar", "dev", "template.json", true);
        ((AbstractStringAssert)Assertions.assertThat((String)this.replaceNewLines(resource)).matches((CharSequence)"\\{\\s*\"foo\": \"dev_bar\"\\s*\\}")).as("Wrong content: " + resource, new Object[0]);
    }

    @Test
    public void templateReplacementNotForResolvePlaceholdersFalse() throws Exception {
        this.environmentRepository.setSearchLocations(new String[]{"classpath:/test"});
        String resource = this.controller.retrieve("foo", "bar", "dev", "template.json", false);
        ((AbstractStringAssert)Assertions.assertThat((String)this.replaceNewLines(resource)).matches((CharSequence)"\\{\\s*\"foo\": \"\\$\\{foo\\}\"\\s*\\}")).as("Wrong content: " + resource, new Object[0]);
    }

    @Test
    public void templateReplacementNotForBinary() throws Exception {
        this.environmentRepository.setSearchLocations(new String[]{"classpath:/test"});
        String resource = new String(this.controller.binary("foo", "bar", "dev", "template.json"));
        ((AbstractStringAssert)Assertions.assertThat((String)this.replaceNewLines(resource)).matches((CharSequence)"\\{\\s*\"foo\": \"\\$\\{foo\\}\"\\s*\\}")).as("Wrong content: " + resource, new Object[0]);
    }

    @Test
    public void escapedPlaceholder() throws Exception {
        this.environmentRepository.setSearchLocations(new String[]{"classpath:/test"});
        String resource = this.controller.retrieve("foo", "bar", "dev", "placeholder.txt", true);
        Assertions.assertThat((String)resource).isEqualToIgnoringNewLines((CharSequence)"foo: ${foo}");
    }

    @Test
    public void applicationAndLabelPlaceholdersWithoutSlash() throws Exception {
        this.environmentRepository.setSearchLocations(new String[]{"classpath:/test/{application}/{label}"});
        String resource = this.controller.retrieve("dev", "bar", "spam", "foo.txt", true);
        Assertions.assertThat((String)resource).isEqualToIgnoringNewLines((CharSequence)"foo: dev_bar/spam");
    }

    @Test
    public void applicationPlaceholderWithSlash() throws Exception {
        this.environmentRepository.setSearchLocations(new String[]{"classpath:/test/{application}"});
        String resource = this.controller.retrieve("dev(_)spam", "bar", "", "foo.txt", true);
        Assertions.assertThat((String)resource).isEqualToIgnoringNewLines((CharSequence)"foo: dev_bar/spam");
    }

    @Test
    public void applicationPlaceholderWithSlashNullLabel() throws Exception {
        this.environmentRepository.setSearchLocations(new String[]{"classpath:/test/{application}"});
        String resource = this.controller.retrieve("dev(_)spam", "bar", null, "foo.txt", true);
        Assertions.assertThat((String)resource).isEqualToIgnoringNewLines((CharSequence)"foo: dev_bar/spam");
    }

    @Test
    public void labelPlaceholderWithSlash() throws Exception {
        this.environmentRepository.setSearchLocations(new String[]{"classpath:/test/{label}"});
        String resource = this.controller.retrieve("dev", "bar", "dev(_)spam", "foo.txt", true);
        Assertions.assertThat((String)resource).isEqualToIgnoringNewLines((CharSequence)"foo: dev_bar/spam");
    }

    @Test
    public void profilePlaceholderNullLabel() throws Exception {
        this.environmentRepository.setSearchLocations(new String[]{"classpath:/test/{profile}"});
        String resource = this.controller.retrieve("bar", "dev", null, "spam/foo.txt", true);
        Assertions.assertThat((String)resource).isEqualToIgnoringNewLines((CharSequence)"foo: dev_bar/spam");
    }

    @Test
    public void nullNameAndLabel() throws Exception {
        this.environmentRepository.setSearchLocations(new String[]{"classpath:/test"});
        try {
            this.controller.retrieve(null, "foo", "bar", "spam/foo.txt", true);
        }
        catch (Exception e) {
            Assertions.assertThat((Throwable)e).isNotNull();
        }
    }

    @Test
    public void labelWithSlash() throws Exception {
        this.environmentRepository.setSearchLocations(new String[]{"classpath:/test"});
        String resource = this.controller.retrieve("foo", "bar", "dev(_)spam", "foo.txt", true);
        Assertions.assertThat((String)resource).isEqualToIgnoringNewLines((CharSequence)"foo: dev_bar/spam");
    }

    @Test
    public void resourceWithoutFileExtension() throws Exception {
        this.environmentRepository.setSearchLocations(new String[]{"classpath:/test"});
        String resource = this.controller.retrieve("foo", "bar", "dev", "foo", true);
        Assertions.assertThat((String)resource).isEqualToIgnoringNewLines((CharSequence)"foo: dev_bar");
    }

    @Test
    public void resourceWithSlash() throws Exception {
        this.environmentRepository.setSearchLocations(new String[]{"classpath:/test"});
        String resource = this.controller.retrieve("foo", "bar", "dev", "spam/foo.txt", true);
        Assertions.assertThat((String)resource).isEqualToIgnoringNewLines((CharSequence)"foo: dev_bar/spam");
    }

    @Test
    public void resourceWithSlashRequest() throws Exception {
        this.environmentRepository.setSearchLocations(new String[]{"classpath:/test"});
        MockHttpServletRequest request = new MockHttpServletRequest();
        ServletWebRequest webRequest = new ServletWebRequest((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        request.setRequestURI("/foo/bar/dev/spam/foo.txt");
        String resource = this.controller.retrieve("foo", "bar", "dev", webRequest, true);
        Assertions.assertThat((String)resource).isEqualToIgnoringNewLines((CharSequence)"foo: dev_bar/spam");
    }

    @Test
    public void resourceWithSlashRequestAndServletPath() throws Exception {
        this.environmentRepository.setSearchLocations(new String[]{"classpath:/test"});
        MockHttpServletRequest request = new MockHttpServletRequest();
        ServletWebRequest webRequest = new ServletWebRequest((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        request.setServletPath("/spring");
        request.setRequestURI("/foo/bar/dev/spam/foo.txt");
        String resource = this.controller.retrieve("foo", "bar", "dev", webRequest, true);
        Assertions.assertThat((String)resource).isEqualToIgnoringNewLines((CharSequence)"foo: dev_bar/spam");
    }

    @Test
    public void labelWithSlashForResolvePlaceholdersFalse() throws Exception {
        this.environmentRepository.setSearchLocations(new String[]{"classpath:/test"});
        String resource = this.controller.retrieve("foo", "bar", "dev(_)spam", "foo.txt", false);
        Assertions.assertThat((String)resource).isEqualToIgnoringNewLines((CharSequence)"foo: dev_bar/spam");
    }

    @Test
    public void resourceWithSlashForResolvePlaceholdersFalse() throws Exception {
        this.environmentRepository.setSearchLocations(new String[]{"classpath:/test"});
        String resource = this.controller.retrieve("foo", "bar", "dev", "spam/foo.txt", false);
        Assertions.assertThat((String)resource).isEqualToIgnoringNewLines((CharSequence)"foo: dev_bar/spam");
    }

    @Test
    public void resourceWithSlashForResolvePlaceholdersFalseRequest() throws Exception {
        this.environmentRepository.setSearchLocations(new String[]{"classpath:/test"});
        MockHttpServletRequest request = new MockHttpServletRequest();
        ServletWebRequest webRequest = new ServletWebRequest((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        request.setRequestURI("/foo/bar/dev/spam/foo.txt");
        String resource = this.controller.retrieve("foo", "bar", "dev", webRequest, false);
        Assertions.assertThat((String)resource).isEqualToIgnoringNewLines((CharSequence)"foo: dev_bar/spam");
    }

    @Test
    public void applicationAndLabelPlaceholdersWithoutSlashForBinary() throws Exception {
        this.environmentRepository.setSearchLocations(new String[]{"classpath:/test/{application}/{label}"});
        byte[] resource = this.controller.binary("dev", "bar", "spam", "foo.txt");
        Assertions.assertThat((String)new String(resource)).isEqualToIgnoringNewLines((CharSequence)"foo: dev_bar/spam");
    }

    @Test
    public void applicationPlaceholderWithSlashForBinary() throws Exception {
        this.environmentRepository.setSearchLocations(new String[]{"classpath:/test/{application}"});
        byte[] resource = this.controller.binary("dev(_)spam", "bar", "", "foo.txt");
        Assertions.assertThat((String)new String(resource)).isEqualToIgnoringNewLines((CharSequence)"foo: dev_bar/spam");
    }

    @Test
    public void applicationPlaceholderWithSlashForBinaryNullLabel() throws Exception {
        this.environmentRepository.setSearchLocations(new String[]{"classpath:/test/{application}"});
        byte[] resource = this.controller.binary("dev(_)spam", "bar", null, "foo.txt");
        Assertions.assertThat((String)new String(resource)).isEqualToIgnoringNewLines((CharSequence)"foo: dev_bar/spam");
    }

    @Test
    public void labelPlaceholderWithSlashForBinary() throws Exception {
        this.environmentRepository.setSearchLocations(new String[]{"classpath:/test/{label}"});
        byte[] resource = this.controller.binary("dev", "bar", "dev(_)spam", "foo.txt");
        Assertions.assertThat((String)new String(resource)).isEqualToIgnoringNewLines((CharSequence)"foo: dev_bar/spam");
    }

    @Test
    public void profilePlaceholderForBinaryNullLabel() throws Exception {
        this.environmentRepository.setSearchLocations(new String[]{"classpath:/test/{profile}"});
        byte[] resource = this.controller.binary("bar", "dev", null, "spam/foo.txt");
        Assertions.assertThat((String)new String(resource)).isEqualToIgnoringNewLines((CharSequence)"foo: dev_bar/spam");
    }

    @Test
    public void forBinaryNullName() throws Exception {
        this.environmentRepository.setSearchLocations(new String[]{"classpath:/test"});
        try {
            this.controller.binary(null, "foo", "bar", "spam/foo.txt");
        }
        catch (Exception e) {
            Assertions.assertThat((Throwable)e).isNotNull();
        }
    }

    @Test
    public void labelWithSlashForBinary() throws Exception {
        this.environmentRepository.setSearchLocations(new String[]{"classpath:/test"});
        byte[] resource = this.controller.binary("foo", "bar", "dev(_)spam", "foo.txt");
        Assertions.assertThat((String)new String(resource)).isEqualToIgnoringNewLines((CharSequence)"foo: dev_bar/spam");
    }

    @Test
    public void resourceWithSlashForBinary() throws Exception {
        this.environmentRepository.setSearchLocations(new String[]{"classpath:/test"});
        byte[] resource = this.controller.binary("foo", "bar", "dev", "spam/foo.txt");
        Assertions.assertThat((String)new String(resource)).isEqualToIgnoringNewLines((CharSequence)"foo: dev_bar/spam");
    }

    @Test
    public void resourceWithSlashForBinaryRequest() throws Exception {
        this.environmentRepository.setSearchLocations(new String[]{"classpath:/test"});
        MockHttpServletRequest request = new MockHttpServletRequest();
        ServletWebRequest webRequest = new ServletWebRequest((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        request.setRequestURI("/foo/bar/dev/spam/foo.txt");
        byte[] resource = this.controller.binary("foo", "bar", "dev", webRequest);
        Assertions.assertThat((String)new String(resource)).isEqualToIgnoringNewLines((CharSequence)"foo: dev_bar/spam");
    }

    private String replaceNewLines(String text) {
        return text.replace("\r", "").replace("\n", "").replace("\t", "");
    }

    @Test
    public void nullLabelForBinary() throws Exception {
        this.environmentRepository.setSearchLocations(new String[]{"classpath:/test/{application}"});
        MockHttpServletRequest request = new MockHttpServletRequest();
        ServletWebRequest webRequest = new ServletWebRequest((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        request.setRequestURI("/dev/spam/bar/foo.txt");
        byte[] resource = this.controller.binary("dev/spam", "bar", null, webRequest);
        Assertions.assertThat((String)new String(resource)).isEqualToIgnoringNewLines((CharSequence)"foo: dev_bar/spam");
    }

    @Test
    public void whenSupportedResourceWithDecrpyt_thenSuccess() throws Exception {
        String decryptedStr = "{\"foo\": \"decrypted\"}";
        ResourceEncryptor resourceEncryptor = (ResourceEncryptor)Mockito.mock(ResourceEncryptor.class);
        Mockito.when((Object)resourceEncryptor.decrypt(ArgumentMatchers.anyString(), (Environment)ArgumentMatchers.any())).thenReturn((Object)decryptedStr);
        Mockito.when((Object)this.resourceEncryptorMap.get("json")).thenReturn((Object)resourceEncryptor);
        this.environmentRepository.setSearchLocations(new String[]{"classpath:/test"});
        this.controller.setEncryptEnabled(true);
        this.controller.setPlainTextEncryptEnabled(true);
        String resource = this.controller.retrieve("foo", "bar", "dev", "template.json", false);
        Assertions.assertThat((String)resource).isEqualTo(decryptedStr);
    }

    @Test
    public void whenUnkownResourceWithDecrpyt_thenNothingChanged() throws Exception {
        String decryptedStr = "{\"foo\": \"decrypted\"}";
        ResourceEncryptor resourceEncryptor = (ResourceEncryptor)Mockito.mock(ResourceEncryptor.class);
        Mockito.when((Object)resourceEncryptor.decrypt(ArgumentMatchers.anyString(), (Environment)ArgumentMatchers.any())).thenReturn((Object)decryptedStr);
        Mockito.when((Object)this.resourceEncryptorMap.get("json")).thenReturn((Object)resourceEncryptor);
        this.environmentRepository.setSearchLocations(new String[]{"classpath:/test"});
        this.controller.setEncryptEnabled(true);
        this.controller.setPlainTextEncryptEnabled(true);
        String resource = this.controller.retrieve("foo", "bar", "dev", "spam/foo.txt", false);
        Assertions.assertThat((String)resource).isEqualToIgnoringNewLines((CharSequence)"foo: dev_bar/spam");
    }

    @Test
    public void setSearchLocationsAppendSlashByConstructor() {
        NativeEnvironmentProperties properties = new NativeEnvironmentProperties();
        properties.setSearchLocations(new String[]{"classpath:/test"});
        NativeEnvironmentRepository repo = new NativeEnvironmentRepository(this.context.getEnvironment(), properties, ObservationRegistry.NOOP);
        Assertions.assertThat((String)repo.getSearchLocations()[0]).isEqualTo("classpath:/test/");
    }
}

