/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.ssh;

import java.io.File;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.eclipse.jgit.transport.SshConfigStore;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.cloud.config.server.environment.JGitEnvironmentProperties;
import org.springframework.cloud.config.server.ssh.FileBasedSshSessionFactory;
import org.springframework.cloud.config.server.ssh.SshUriPropertyProcessor;

@ExtendWith(value={MockitoExtension.class})
public class FileBasedSshSessionFactoryTest {
    private FileBasedSshSessionFactory factory;

    @Test
    public void strictHostKeyCheckingIsOptional() {
        JGitEnvironmentProperties sshKey = new JGitEnvironmentProperties();
        sshKey.setUri("ssh://gitlab.example.local:3322/somerepo.git");
        sshKey.setStrictHostKeyChecking(false);
        this.setupSessionFactory(sshKey);
        SshConfigStore.HostConfig sshConfig = this.getSshHostConfig("gitlab.example.local");
        Assertions.assertThat((String)sshConfig.getValue("StrictHostKeyChecking")).isEqualTo("no");
    }

    @Test
    public void strictHostKeyCheckingIsUsed() {
        JGitEnvironmentProperties sshKey = new JGitEnvironmentProperties();
        sshKey.setUri("ssh://gitlab.example.local:3322/somerepo.git");
        this.setupSessionFactory(sshKey);
        SshConfigStore.HostConfig sshConfig = this.getSshHostConfig("gitlab.example.local");
        Assertions.assertThat((String)sshConfig.getValue("StrictHostKeyChecking")).isEqualTo("yes");
    }

    @Test
    public void sshConfigurationIsDoneForRelevantHostOnly() {
        JGitEnvironmentProperties sshKey = new JGitEnvironmentProperties();
        sshKey.setUri("ssh://gitlab.example.local:3322/somerepo.git");
        this.setupSessionFactory(sshKey);
        SshConfigStore.HostConfig sshConfig = this.getSshHostConfig("another.host");
        Assertions.assertThat((String)sshConfig.getValue("StrictHostKeyChecking")).isNull();
    }

    @Test
    public void handlesNullConfigFile() {
        JGitEnvironmentProperties sshKey = new JGitEnvironmentProperties();
        sshKey.setUri("ssh://gitlab.example.local:3322/somerepo.git");
        this.setupSessionFactory(sshKey);
        SshConfigStore configStore = this.factory.createSshConfigStore(new File("dummy"), null, "localUserName");
        Assertions.assertThat((Object)configStore).isNull();
    }

    private SshConfigStore.HostConfig getSshHostConfig(String hostName) {
        return this.factory.createSshConfigStore(new File("dummy"), new File("dummy"), "localUserName").lookup(hostName, 22, "userName");
    }

    private void setupSessionFactory(JGitEnvironmentProperties sshKey) {
        HashMap<String, JGitEnvironmentProperties> sshKeysByHostname = new HashMap<String, JGitEnvironmentProperties>();
        sshKeysByHostname.put(SshUriPropertyProcessor.getHostname((String)sshKey.getUri()), sshKey);
        this.factory = new FileBasedSshSessionFactory(sshKeysByHostname);
    }
}

