/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.ssh;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Spliterator;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.sshd.common.config.keys.impl.ECDSAPublicKeyEntryDecoder;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider;
import org.apache.sshd.common.session.SessionContext;
import org.assertj.core.api.Assertions;
import org.eclipse.jgit.transport.SshConfigStore;
import org.eclipse.jgit.transport.sshd.ProxyData;
import org.eclipse.jgit.transport.sshd.ProxyDataFactory;
import org.eclipse.jgit.transport.sshd.ServerKeyDatabase;
import org.eclipse.jgit.transport.sshd.SshdSessionFactory;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;
import org.springframework.cloud.config.server.environment.JGitEnvironmentProperties;
import org.springframework.cloud.config.server.proxy.ProxyHostProperties;
import org.springframework.cloud.config.server.ssh.KeyPairUtils;
import org.springframework.cloud.config.server.ssh.PropertyBasedSshSessionFactory;
import org.springframework.cloud.config.server.ssh.SshUriPropertyProcessor;
import org.springframework.core.io.ClassPathResource;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.LENIENT)
public class PropertyBasedSshSessionFactoryTest {
    private static final String HOST_KEY = "AAAAE2VjZHNhLXNoYTItbmlzdHAyNTYAAAAIbmlzdHAyNTYAAABBBMzCa0AcNbahUFjFYJHIilhJOhKFHuDOOuY+/HqV9kALftitwNYo6dQ+tC9IK5JVZCZfqKfDWVMxspcPDf9eMoE=";
    private static final String HOST_KEY_ALGORITHM = "ecdsa-sha2-nistp256";
    private static final String PRIVATE_KEY = PropertyBasedSshSessionFactoryTest.getResourceAsString("/ssh/key");
    private PropertyBasedSshSessionFactory factory;

    public static String getResourceAsString(String path) {
        String string;
        ClassPathResource resource = new ClassPathResource(path);
        BufferedReader br = new BufferedReader(new InputStreamReader(resource.getInputStream()));
        try {
            String line;
            StringBuilder builder = new StringBuilder();
            while ((line = br.readLine()) != null) {
                builder.append(line).append('\n');
            }
            string = builder.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        br.close();
        return string;
    }

    @Test
    public void strictHostKeyCheckingIsOptional() {
        JGitEnvironmentProperties sshKey = new JGitEnvironmentProperties();
        sshKey.setUri("ssh://gitlab.example.local:3322/somerepo.git");
        sshKey.setPrivateKey(PRIVATE_KEY);
        this.setupSessionFactory(sshKey);
        SshConfigStore.HostConfig sshConfig = this.getSshHostConfig("gitlab.example.local");
        Assertions.assertThat((String)sshConfig.getValue("StrictHostKeyChecking")).isEqualTo("no");
    }

    @Test
    public void strictHostKeyCheckingIsUsed() {
        JGitEnvironmentProperties sshKey = new JGitEnvironmentProperties();
        sshKey.setUri("ssh://gitlab.example.local:3322/somerepo.git");
        sshKey.setHostKey(HOST_KEY);
        sshKey.setPrivateKey(PRIVATE_KEY);
        this.setupSessionFactory(sshKey);
        SshConfigStore.HostConfig sshConfig = this.getSshHostConfig("gitlab.example.local");
        Assertions.assertThat((String)sshConfig.getValue("StrictHostKeyChecking")).isEqualTo("yes");
    }

    @Test
    public void sshConfigIsUsedForRelevantHostOnly() {
        JGitEnvironmentProperties sshKey = new JGitEnvironmentProperties();
        sshKey.setUri("ssh://gitlab.example.local:3322/somerepo.git");
        sshKey.setPrivateKey(PRIVATE_KEY);
        this.setupSessionFactory(sshKey);
        Assertions.assertThatThrownBy(() -> this.getSshHostConfig("another.host")).isInstanceOf(NullPointerException.class);
    }

    @Test
    public void hostKeyAlgorithmIsSpecified() {
        JGitEnvironmentProperties sshKey = new JGitEnvironmentProperties();
        sshKey.setUri("ssh://gitlab.example.local:3322/somerepo.git");
        sshKey.setHostKeyAlgorithm(HOST_KEY_ALGORITHM);
        sshKey.setHostKey(HOST_KEY);
        sshKey.setPrivateKey(PRIVATE_KEY);
        this.setupSessionFactory(sshKey);
        PublicKey hostKey = this.getSshHostKey("gitlab.example.local");
        Assertions.assertThat((Object)hostKey).isNotNull();
        Assertions.assertThat((String)hostKey.getAlgorithm()).isEqualTo(this.toPublicKey(HOST_KEY, HOST_KEY_ALGORITHM).getAlgorithm());
    }

    @Test
    public void privateKeyIsUsed() {
        JGitEnvironmentProperties sshKey = new JGitEnvironmentProperties();
        sshKey.setUri("git@gitlab.example.local:someorg/somerepo.git");
        sshKey.setPrivateKey(PRIVATE_KEY);
        this.setupSessionFactory(sshKey);
        PrivateKey privateKey = this.getSshPrivateKey("gitlab.example.local");
        Assertions.assertThat((Object)privateKey).isNotNull();
        Assertions.assertThat((Object)privateKey).isEqualTo((Object)this.toPrivateKey(PRIVATE_KEY, null));
    }

    @Test
    public void privateKeyIsUsedWithRepoIp() {
        JGitEnvironmentProperties sshKey = new JGitEnvironmentProperties();
        sshKey.setUri("git@127.0.0.1:someorg/somerepo.git");
        sshKey.setPrivateKey(PRIVATE_KEY);
        this.setupSessionFactory(sshKey);
        PrivateKey privateKey = this.getSshPrivateKey("gitlab.example.local");
        Assertions.assertThat((Object)privateKey).isNotNull();
        Assertions.assertThat((Object)privateKey).isEqualTo((Object)this.toPrivateKey(PRIVATE_KEY, null));
    }

    @Test
    public void privateKeyWithPassphraseIsUsed() {
        String keyWithPassphrase = PropertyBasedSshSessionFactoryTest.getResourceAsString("/ssh/key-with-passphrase");
        JGitEnvironmentProperties sshKey = new JGitEnvironmentProperties();
        sshKey.setUri("git@gitlab.example.local:someorg/somerepo.git");
        sshKey.setPrivateKey(keyWithPassphrase);
        sshKey.setPassphrase("secret");
        this.setupSessionFactory(sshKey);
        PrivateKey privateKey = this.getSshPrivateKey("gitlab.example.local");
        Assertions.assertThat((Object)privateKey).isNotNull();
        Assertions.assertThat((Object)privateKey).isEqualTo((Object)this.toPrivateKey(keyWithPassphrase, "secret"));
    }

    @Test
    public void hostKeyIsUsed() {
        JGitEnvironmentProperties sshKey = new JGitEnvironmentProperties();
        sshKey.setUri("git@gitlab.example.local:someorg/somerepo.git");
        sshKey.setHostKeyAlgorithm(HOST_KEY_ALGORITHM);
        sshKey.setHostKey(HOST_KEY);
        sshKey.setStrictHostKeyChecking(true);
        sshKey.setPrivateKey(PRIVATE_KEY);
        this.setupSessionFactory(sshKey);
        PublicKey configuredKey = this.toPublicKey(HOST_KEY, HOST_KEY_ALGORITHM);
        PublicKey knownHostKey = this.getSshHostKey("gitlab.example.local");
        Assertions.assertThat((Object)knownHostKey).isNotNull();
        Assertions.assertThat((Object)knownHostKey).isEqualTo((Object)configuredKey);
        Assertions.assertThat((boolean)this.isKnownKeyForHost(configuredKey, "gitlab.example.local")).isTrue();
    }

    @Test
    public void hostKeyIsUsedWithRepoIp() {
        JGitEnvironmentProperties sshKey = new JGitEnvironmentProperties();
        sshKey.setUri("git@127.0.0.1:someorg/somerepo.git");
        sshKey.setHostKeyAlgorithm(HOST_KEY_ALGORITHM);
        sshKey.setHostKey(HOST_KEY);
        sshKey.setPrivateKey(PRIVATE_KEY);
        this.setupSessionFactory(sshKey);
        PublicKey configuredKey = this.toPublicKey(HOST_KEY, HOST_KEY_ALGORITHM);
        PublicKey knownHostKey = this.getSshHostKey("gitlab.example.local");
        Assertions.assertThat((Object)knownHostKey).isNotNull();
        Assertions.assertThat((Object)knownHostKey).isEqualTo((Object)configuredKey);
        Assertions.assertThat((boolean)this.isKnownKeyForHost(configuredKey, "gitlab.example.local")).isTrue();
    }

    @Test
    public void preferredAuthenticationsIsSpecified() {
        JGitEnvironmentProperties sshKey = new JGitEnvironmentProperties();
        sshKey.setUri("ssh://gitlab.example.local:3322/somerepo.git");
        sshKey.setPrivateKey(PRIVATE_KEY);
        sshKey.setPreferredAuthentications("password,keyboard-interactive");
        this.setupSessionFactory(sshKey);
        SshConfigStore.HostConfig sshConfig = this.getSshHostConfig("gitlab.example.local");
        Assertions.assertThat((String)sshConfig.getValue("PreferredAuthentications")).isEqualTo("password,keyboard-interactive");
        Assertions.assertThat((String)sshConfig.getValue("StrictHostKeyChecking")).isEqualTo("no");
    }

    @Test
    public void customKnownHostsFileIsUsed() throws IOException {
        JGitEnvironmentProperties sshKey = new JGitEnvironmentProperties();
        sshKey.setUri("git@gitlab.example.local:someorg/somerepo.git");
        sshKey.setPrivateKey(PRIVATE_KEY);
        sshKey.setKnownHostsFile(new ClassPathResource("/ssh/known_hosts").getFile().getPath());
        this.setupSessionFactory(sshKey);
        PublicKey configuredKey = this.toPublicKey(HOST_KEY, HOST_KEY_ALGORITHM);
        PublicKey knownHostKey = this.getSshHostKey("gitlab.example.local");
        Assertions.assertThat((Object)knownHostKey).isNotNull();
        Assertions.assertThat((Object)knownHostKey).isEqualTo((Object)configuredKey);
        Assertions.assertThat((boolean)this.isKnownKeyForHost(configuredKey, "gitlab.example.local")).isTrue();
    }

    @Test
    public void proxySettingsIsUsed() {
        JGitEnvironmentProperties sshProperties = new JGitEnvironmentProperties();
        sshProperties.setUri("ssh://gitlab.example.local:3322/somerepo.git");
        sshProperties.setPrivateKey(PRIVATE_KEY);
        HashMap<ProxyHostProperties.ProxyForScheme, ProxyHostProperties> map = new HashMap<ProxyHostProperties.ProxyForScheme, ProxyHostProperties>();
        ProxyHostProperties proxyHostProperties = new ProxyHostProperties();
        proxyHostProperties.setHost("host.domain");
        proxyHostProperties.setPort(8080);
        proxyHostProperties.setUsername("user");
        proxyHostProperties.setPassword("password");
        map.put(ProxyHostProperties.ProxyForScheme.HTTP, proxyHostProperties);
        sshProperties.setProxy(map);
        this.setupSessionFactory(sshProperties);
        ProxyData proxyData = this.getSshProxyData("gitlab.example.local");
        Assertions.assertThat((Object)proxyData).isNotNull();
        Assertions.assertThat((String)proxyData.getUser()).isEqualTo("user");
        Assertions.assertThat((String)new String(proxyData.getPassword())).isEqualTo("password");
        Assertions.assertThat((String)proxyData.getProxy().type().toString()).isEqualTo("HTTP");
        Assertions.assertThat((String)proxyData.getProxy().address().toString()).containsPattern((CharSequence)"host\\.domain.*:8080");
    }

    @Test
    public void defaultSshConfigIsSet() {
        JGitEnvironmentProperties sshProperties = new JGitEnvironmentProperties();
        sshProperties.setUri("ssh://gitlab.example.local:3322/somerepo.git");
        this.setupSessionFactory(sshProperties);
        SshConfigStore.HostConfig sshConfig = this.getDefaultSshHostConfig("gitlab.example.local", 123, "user.name");
        Assertions.assertThat((String)sshConfig.getValue("HostName")).isEqualTo("gitlab.example.local");
        Assertions.assertThat((String)sshConfig.getValue("Port")).isEqualTo("123");
        Assertions.assertThat((String)sshConfig.getValue("User")).isEqualTo("user.name");
        Assertions.assertThat((String)sshConfig.getValue("ConnectionAttempts")).isEqualTo("1");
    }

    @Test
    public void proxySettingsIsUsedWithRepoIp() {
        JGitEnvironmentProperties sshProperties = new JGitEnvironmentProperties();
        sshProperties.setUri("ssh://127.0.0.1:3322/somerepo.git");
        sshProperties.setPrivateKey(PRIVATE_KEY);
        HashMap<ProxyHostProperties.ProxyForScheme, ProxyHostProperties> map = new HashMap<ProxyHostProperties.ProxyForScheme, ProxyHostProperties>();
        ProxyHostProperties proxyHostProperties = new ProxyHostProperties();
        proxyHostProperties.setHost("host.domain");
        proxyHostProperties.setPort(8080);
        map.put(ProxyHostProperties.ProxyForScheme.HTTP, proxyHostProperties);
        sshProperties.setProxy(map);
        this.setupSessionFactory(sshProperties);
        ProxyData proxyData = this.getSshProxyData("gitlab.example.local");
        Assertions.assertThat((Object)proxyData).isNotNull();
        Assertions.assertThat((String)proxyData.getProxy().type().toString()).isEqualTo("HTTP");
        Assertions.assertThat((String)proxyData.getProxy().address().toString()).containsPattern((CharSequence)"host\\.domain.*:8080");
    }

    @Test
    public void sshConfigFileIsNotUsed() {
        this.setupSessionFactory(new JGitEnvironmentProperties());
        Assertions.assertThat((File)this.factory.getSshConfig(new File("."))).isNull();
    }

    private ProxyData getSshProxyData(String hostname) {
        try {
            Field proxies = SshdSessionFactory.class.getDeclaredField("proxies");
            proxies.setAccessible(true);
            ProxyDataFactory proxyDataFactory = (ProxyDataFactory)proxies.get(this.factory);
            proxies.setAccessible(false);
            return proxyDataFactory.get(this.setupSocketAddress(hostname));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private PublicKey toPublicKey(String key, String algorithm) {
        try {
            return new ECDSAPublicKeyEntryDecoder().decodePublicKey(null, algorithm, Base64.getDecoder().decode(key), Collections.emptyMap());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private PrivateKey toPrivateKey(String key, String passphrase) {
        try {
            Collection keyPairs = KeyPairUtils.load(null, (String)key, (String)passphrase);
            return keyPairs.isEmpty() ? null : ((KeyPair)keyPairs.iterator().next()).getPrivate();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private PrivateKey getSshPrivateKey(String hostname) {
        List kayPairs;
        InetSocketAddress address = this.setupSocketAddress(hostname);
        SessionContext session = (SessionContext)Mockito.mock(SessionContext.class);
        Mockito.when((Object)session.getRemoteAddress()).thenReturn((Object)address);
        try {
            Spliterator spliterator = ((KeyIdentityProvider)this.factory.getDefaultKeys(new File("."))).loadKeys(session).spliterator();
            kayPairs = StreamSupport.stream(spliterator, false).collect(Collectors.toList());
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        return kayPairs.isEmpty() ? null : ((KeyPair)kayPairs.get(0)).getPrivate();
    }

    private PublicKey getSshHostKey(String hostname) {
        InetSocketAddress address = this.setupSocketAddress(hostname);
        List publicKeys = this.factory.getServerKeyDatabase(null, null).lookup("address", address, (ServerKeyDatabase.Configuration)Mockito.mock(ServerKeyDatabase.Configuration.class));
        return publicKeys.isEmpty() ? null : (PublicKey)publicKeys.get(0);
    }

    private boolean isKnownKeyForHost(PublicKey publicKey, String hostname) {
        InetSocketAddress address = this.setupSocketAddress(hostname);
        return this.factory.getServerKeyDatabase(null, null).accept("address", address, publicKey, (ServerKeyDatabase.Configuration)Mockito.mock(ServerKeyDatabase.Configuration.class), null);
    }

    private SshConfigStore.HostConfig getSshHostConfig(String hostname) {
        return this.factory.createSshConfigStore(new File("dummy"), new File("dummy"), "localUserName").lookup(hostname, 22, "userName");
    }

    private SshConfigStore.HostConfig getDefaultSshHostConfig(String hostName, int port, String username) {
        return this.factory.createSshConfigStore(new File("dummy"), new File("dummy"), "localUserName").lookupDefault(hostName, port, username);
    }

    private void setupSessionFactory(JGitEnvironmentProperties sshKey) {
        HashMap<String, JGitEnvironmentProperties> sshKeysByHostname = new HashMap<String, JGitEnvironmentProperties>();
        sshKeysByHostname.put(SshUriPropertyProcessor.getHostname((String)sshKey.getUri()), sshKey);
        this.factory = new PropertyBasedSshSessionFactory(sshKeysByHostname);
    }

    private InetSocketAddress setupSocketAddress(String hostname) {
        InetAddress address = (InetAddress)Mockito.mock(InetAddress.class);
        Mockito.when((Object)address.getHostAddress()).thenReturn((Object)"127.0.0.1");
        InetSocketAddress socketAddress = (InetSocketAddress)Mockito.mock(InetSocketAddress.class);
        Mockito.when((Object)socketAddress.getAddress()).thenReturn((Object)address);
        Mockito.when((Object)socketAddress.getHostString()).thenReturn((Object)hostname);
        Mockito.when((Object)socketAddress.getHostName()).thenReturn((Object)hostname);
        Mockito.when((Object)socketAddress.getPort()).thenReturn((Object)22);
        return socketAddress;
    }
}

