/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.ssh;

import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.util.Collection;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.config.server.environment.MultipleJGitEnvironmentProperties;

public class SshPropertyValidatorTest {
    private static final String SSH_URI = "git@gitserver.com:team/repo1.git";
    private static final String VALID_PRIVATE_KEY = "-----BEGIN RSA PRIVATE KEY-----\nMIIEpAIBAAKCAQEAoqyz6YaYMTr7L8GLPSQpAQXaM04gRx4CCsGK2kfLQdw4BlqI\nyyxp38YcuZG9cUDBAxby+K2TKmwHaC1R61QTwbPuCRdIPrDwRz+FLoegm3iDLCmn\nuP6rjZDneYsqfU1KSdrOwIbCnONfDdvYL/vnZC/o8DDMlk5Orw2SfHkT3pq0o8km\nayBwN4Sf3bpyWTY0oZcmNeSCCoIdE59k8Pa7/t9bwY9caLj05C3DEsjucc7Ei/Eq\nTOyGyobtXwaya5CqKLUHes74Poz1aEP/yVFdUud91uezd8ZK1P1t5/ZKA3R6aHir\n+diDJ2/GQ2tD511FW46yw+EtBUJTO6ADVv4UnQIDAQABAoIBAF+5qwEfX82QfKFk\njfADqFFexUDtl1biFKeJrpC2MKhn01wByH9uejrhFKQqW8UaKroLthyZ34DWIyGt\nlDnHGv0gSVF2LuAdNLdobJGt49e4+c9yD61vxzm97Eh8mRs08SM2q/VlF35E2fmI\nxdWusUImYzd8L9e+6tRd8zZl9UhG5vR5XIstKqxC6S0g79aAt0hasE4Gw1FKOf2V\n4mlL15atjQSKCPdOicuyc4zpjAtU1A9AfF51iG8oOUuJebPW8tCftfOQxaeGFgMG\n7M9aai1KzXR6M5IBAKEv31yBvz/SHTneP7oZXNLeC1GIR420PKybmeZdNK8BbEAu\n3reKgm0CgYEA03Sx8JoF5UBsIvFPpP1fjSlTgKryM5EJR6KQtj5e4YfyxccJepN8\nq4MrqDfNKleG/a1acEtDMhBNovU7Usp2QIP7zpAeioHBOhmE5WSieZGc3icOGWWq\nmRkdulSONruqWKv76ZoluxftekE03bDhZDNlcCgmrslEKB/ufHd2oc8CgYEAxPFa\nlKOdSeiYFV5CtvO8Ro8em6rGpSsVz4qkPxbeBqUDCb9KXHhq6YrhRxOIfQJKfT7M\nZFCn8ArJXKgOGu+KsvwIErFHF9g2jJMG4DOUTpkQgi2yveihFxcmz/AltyVXgrnv\nZWQbAerH77pdKKhNivLGgEv72GYawdYjYNjemdMCgYA2kEMmMahZyrDcp2YEzfit\nBT/t0K6kzcUWPgWXcSqsiZcEn+J7RbmCzFskkhmX1nQX23adyV3yejB+X0dKisHO\nzf/ZAmlPFkJVCqa3RquCMSfIT02dEhXeYZPBM/Zqeyxuqxpa4hLgX0FBLbhFiFHw\nuC5xrXql2XuD2xF//peXEwKBgQC+pa28Cg7vRxxCQzduB9CQtWc55j3aEjVQ7bNF\n54sS/5ZLT0Ra8677WZfuyDfuW9NkHvCZg4Ku2qJG8eCFrrGjxlrCTZ62tHVJ6+JS\nE1xUIdRbUIWhVZrr0VufG6hG/P0T7Y6Tpi6G0pKtvMkF3LcD9TS3adboix8H2ZXx\n4L7MRQKBgQC0OO3qqNXOjIVYWOoqXLybOY/Wqu9lxCAgGyCYaMcstnBI7W0MZTBr\n/syluvGsaFc1sE7MMGOOzKi1tF4YvDmSnzA/R1nmaPguuD9fOA+w7Pwkv5vLvuJq\n2U7EeNwxq1I1L3Ag6E7wH4BHLHd4TKaZR6agFkn8oomz71yZPGjuZQ==\n-----END RSA PRIVATE KEY-----";
    private static final String VALID_HOST_KEY = "AAAAB3NzaC1yc2EAAAADAQABAAABAQDg6/W/5cbk/npvzpae7ZEa54F4rkwh2V3NiuqVZ5hWr+8O4/6SmrS7yBvRHAFeAJNb0LOCjE/7tjd1fqUx+QU1ATCtwkOhuwG8Ubzkx23mMZlrwEvx7XEfBoLN7Lw9fXjWDtTTgFB1AxCQ2pGGiNG0QCwyA4HViDHVU+ibwkRlzuDJG0tnp5Qpo3DXkHwFNdqWNfVrIZ6q2xbyeoJjKjnR215T0ehmuWFmKqG+uMNe/LQ6IOiK0F5+gr7rgPxNLAYYqyhraAnBeHn5gapsSzYJmFpoAHWvN7OUwHcJ88D9qUkKi4VKxYiuK69u3z825Xj2cLTfj9JiHCfV8cTo9GL";
    private static Validator validator;

    @BeforeAll
    public static void setUpValidator() {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        validator = factory.getValidator();
    }

    @Test
    public void supportedParametersSuccessful() {
        MultipleJGitEnvironmentProperties validSettings = new MultipleJGitEnvironmentProperties();
        validSettings.setUri(SSH_URI);
        validSettings.setIgnoreLocalSshSettings(true);
        validSettings.setPrivateKey(VALID_PRIVATE_KEY);
        validSettings.setHostKey(VALID_HOST_KEY);
        validSettings.setHostKeyAlgorithm("ssh-rsa");
        Set constraintViolations = validator.validate((Object)validSettings, new Class[0]);
        Assertions.assertThat((Collection)constraintViolations).hasSize(0);
    }

    @Test
    public void invalidPrivateKeyFails() {
        MultipleJGitEnvironmentProperties invalidKey = new MultipleJGitEnvironmentProperties();
        invalidKey.setUri(SSH_URI);
        invalidKey.setIgnoreLocalSshSettings(true);
        invalidKey.setPrivateKey("-----BEGIN OPENSSH PRIVATE KEY-----\nFOOBAR");
        Set constraintViolations = validator.validate((Object)invalidKey, new Class[0]);
        Assertions.assertThat((Collection)constraintViolations).hasSize(1);
    }

    @Test
    public void dummyPrivateKeyFails() {
        MultipleJGitEnvironmentProperties invalidKey = new MultipleJGitEnvironmentProperties();
        invalidKey.setUri(SSH_URI);
        invalidKey.setIgnoreLocalSshSettings(true);
        invalidKey.setPrivateKey("invalid_key");
        Set constraintViolations = validator.validate((Object)invalidKey, new Class[0]);
        Assertions.assertThat((Collection)constraintViolations).hasSize(1);
    }

    @Test
    public void missingPrivateKeyFails() {
        MultipleJGitEnvironmentProperties missingKey = new MultipleJGitEnvironmentProperties();
        missingKey.setUri(SSH_URI);
        missingKey.setIgnoreLocalSshSettings(true);
        Set constraintViolations = validator.validate((Object)missingKey, new Class[0]);
        Assertions.assertThat((Collection)constraintViolations).hasSize(1);
    }

    @Test
    public void hostKeyWithMissingAlgoFails() {
        MultipleJGitEnvironmentProperties missingAlgo = new MultipleJGitEnvironmentProperties();
        missingAlgo.setUri(SSH_URI);
        missingAlgo.setIgnoreLocalSshSettings(true);
        missingAlgo.setPrivateKey(VALID_PRIVATE_KEY);
        missingAlgo.setHostKey("some_host");
        Set constraintViolations = validator.validate((Object)missingAlgo, new Class[0]);
        Assertions.assertThat((Collection)constraintViolations).hasSize(1);
    }

    @Test
    public void algoWithMissingHostKeyFails() {
        MultipleJGitEnvironmentProperties missingHostKey = new MultipleJGitEnvironmentProperties();
        missingHostKey.setUri(SSH_URI);
        missingHostKey.setIgnoreLocalSshSettings(true);
        missingHostKey.setPrivateKey(VALID_PRIVATE_KEY);
        missingHostKey.setHostKeyAlgorithm("ssh-rsa");
        Set constraintViolations = validator.validate((Object)missingHostKey, new Class[0]);
        Assertions.assertThat((Collection)constraintViolations).hasSize(1);
    }

    @Test
    public void unsupportedAlgoFails() {
        MultipleJGitEnvironmentProperties unsupportedAlgo = new MultipleJGitEnvironmentProperties();
        unsupportedAlgo.setUri(SSH_URI);
        unsupportedAlgo.setIgnoreLocalSshSettings(true);
        unsupportedAlgo.setPrivateKey(VALID_PRIVATE_KEY);
        unsupportedAlgo.setHostKey("some_host_key");
        unsupportedAlgo.setHostKeyAlgorithm("unsupported");
        Set constraintViolations = validator.validate((Object)unsupportedAlgo, new Class[0]);
        Assertions.assertThat((Collection)constraintViolations).hasSize(1);
    }

    @Test
    public void validatorNotRunIfIgnoreLocalSettingsFalse() {
        MultipleJGitEnvironmentProperties useLocal = new MultipleJGitEnvironmentProperties();
        useLocal.setUri(SSH_URI);
        useLocal.setIgnoreLocalSshSettings(false);
        useLocal.setPrivateKey("invalid_key");
        Set constraintViolations = validator.validate((Object)useLocal, new Class[0]);
        Assertions.assertThat((Collection)constraintViolations).hasSize(0);
    }

    @Test
    public void validatorNotRunIfHttpsUri() {
        MultipleJGitEnvironmentProperties httpsUri = new MultipleJGitEnvironmentProperties();
        httpsUri.setUri("https://somerepo.com/team/project.git");
        httpsUri.setIgnoreLocalSshSettings(true);
        httpsUri.setPrivateKey("invalid_key");
        Set constraintViolations = validator.validate((Object)httpsUri, new Class[0]);
        Assertions.assertThat((Collection)constraintViolations).hasSize(0);
    }

    @Test
    public void preferredAuthenticationsIsValidated() {
        MultipleJGitEnvironmentProperties sshUriProperties = new MultipleJGitEnvironmentProperties();
        Assertions.assertThat((Collection)validator.validate((Object)sshUriProperties, new Class[0])).hasSize(0);
        sshUriProperties.setPreferredAuthentications("keyboard-interactive, public-key ,kerberos");
        Assertions.assertThat((Collection)validator.validate((Object)sshUriProperties, new Class[0])).hasSize(0);
        sshUriProperties.setPreferredAuthentications(",,");
        Assertions.assertThat((Collection)validator.validate((Object)sshUriProperties, new Class[0])).hasSize(1);
    }

    @Test
    public void knowHostsFileIsValidated() {
        MultipleJGitEnvironmentProperties sshUriProperties = new MultipleJGitEnvironmentProperties();
        Assertions.assertThat((Collection)validator.validate((Object)sshUriProperties, new Class[0])).hasSize(0);
        sshUriProperties.setKnownHostsFile("non-existing.file");
        Assertions.assertThat((Collection)validator.validate((Object)sshUriProperties, new Class[0])).hasSize(1);
    }
}

