/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.ssh;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.config.server.environment.JGitEnvironmentProperties;
import org.springframework.cloud.config.server.environment.MultipleJGitEnvironmentProperties;
import org.springframework.cloud.config.server.ssh.SshUriPropertyProcessor;

public class SshUriPropertyProcessorTest {
    private static final String PRIVATE_KEY1 = "privateKey";
    private static final String HOST_KEY1 = "hostKey";
    private static final String ALGO1 = "ssh-rsa";
    private static final String URI1 = "ollie@gitlab1.test.local:project/my-repo";
    private static final String HOST1 = "gitlab1.test.local";
    private static final String PRIVATE_KEY2 = "privateKey2";
    private static final String URI2 = "ssh://git@gitlab2.test.local/wtran/my-repo";
    private static final String HOST2 = "gitlab2.test.local";
    private static final String PRIVATE_KEY3 = "privateKey3";
    private static final String URI3 = "git+ssh://git@gitlab3.test.local/wtran/my-repo";
    private static final String HOST3 = "gitlab3.test.local";

    @AfterEach
    public void cleanup() {
        SshSessionFactory.setInstance(null);
    }

    @Test
    public void testSingleSshUriProperties() {
        SshUriPropertyProcessor sshUriPropertyProcessor = new SshUriPropertyProcessor(this.mainRepoPropertiesFixture());
        Map sshKeysByHostname = sshUriPropertyProcessor.getSshKeysByHostname();
        Assertions.assertThat(sshKeysByHostname.values()).hasSize(1);
        JGitEnvironmentProperties sshKey = (JGitEnvironmentProperties)sshKeysByHostname.get(HOST1);
        this.assertMainRepo(sshKey);
    }

    @Test
    public void testMultipleSshUriPropertiess() {
        MultipleJGitEnvironmentProperties sshUriProperties = this.mainRepoPropertiesFixture();
        MultipleJGitEnvironmentProperties.PatternMatchingJGitEnvironmentProperties nestedSshUriProperties1 = new MultipleJGitEnvironmentProperties.PatternMatchingJGitEnvironmentProperties();
        nestedSshUriProperties1.setUri(URI2);
        nestedSshUriProperties1.setPrivateKey(PRIVATE_KEY2);
        MultipleJGitEnvironmentProperties.PatternMatchingJGitEnvironmentProperties nestedSshUriProperties2 = new MultipleJGitEnvironmentProperties.PatternMatchingJGitEnvironmentProperties();
        nestedSshUriProperties2.setUri(URI3);
        nestedSshUriProperties2.setPrivateKey(PRIVATE_KEY3);
        this.addRepoProperties(sshUriProperties, nestedSshUriProperties1, "repo2");
        this.addRepoProperties(sshUriProperties, nestedSshUriProperties2, "repo3");
        SshUriPropertyProcessor sshUriPropertyProcessor = new SshUriPropertyProcessor(sshUriProperties);
        Map sshKeysByHostname = sshUriPropertyProcessor.getSshKeysByHostname();
        Assertions.assertThat(sshKeysByHostname.values()).hasSize(3);
        JGitEnvironmentProperties sshKey1 = (JGitEnvironmentProperties)sshKeysByHostname.get(HOST1);
        this.assertMainRepo(sshKey1);
        JGitEnvironmentProperties sshKey2 = (JGitEnvironmentProperties)sshKeysByHostname.get(HOST2);
        Assertions.assertThat((String)SshUriPropertyProcessor.getHostname((String)sshKey2.getUri())).isEqualTo(HOST2);
        Assertions.assertThat((String)sshKey2.getHostKeyAlgorithm()).isNull();
        Assertions.assertThat((String)sshKey2.getHostKey()).isNull();
        Assertions.assertThat((String)sshKey2.getPrivateKey()).isEqualTo(PRIVATE_KEY2);
        JGitEnvironmentProperties sshKey3 = (JGitEnvironmentProperties)sshKeysByHostname.get(HOST3);
        Assertions.assertThat((String)SshUriPropertyProcessor.getHostname((String)sshKey3.getUri())).isEqualTo(HOST3);
        Assertions.assertThat((String)sshKey3.getHostKeyAlgorithm()).isNull();
        Assertions.assertThat((String)sshKey3.getHostKey()).isNull();
        Assertions.assertThat((String)sshKey3.getPrivateKey()).isEqualTo(PRIVATE_KEY3);
    }

    @Test
    public void testSameHostnameDifferentKeysFirstOneWins() {
        MultipleJGitEnvironmentProperties sshUriProperties = this.mainRepoPropertiesFixture();
        MultipleJGitEnvironmentProperties.PatternMatchingJGitEnvironmentProperties nestedSshUriProperties = new MultipleJGitEnvironmentProperties.PatternMatchingJGitEnvironmentProperties();
        nestedSshUriProperties.setUri(URI1);
        nestedSshUriProperties.setPrivateKey(PRIVATE_KEY1);
        nestedSshUriProperties.setHostKey(HOST_KEY1);
        nestedSshUriProperties.setHostKeyAlgorithm(ALGO1);
        this.addRepoProperties(sshUriProperties, nestedSshUriProperties, "repo2");
        SshUriPropertyProcessor sshUriPropertyProcessor = new SshUriPropertyProcessor(sshUriProperties);
        Map sshKeysByHostname = sshUriPropertyProcessor.getSshKeysByHostname();
        Assertions.assertThat(sshKeysByHostname.values()).hasSize(1);
        JGitEnvironmentProperties sshKey = (JGitEnvironmentProperties)sshKeysByHostname.get(HOST1);
        this.assertMainRepo(sshKey);
    }

    @Test
    public void testNoSshUriProperties() {
        SshUriPropertyProcessor sshUriPropertyProcessor = new SshUriPropertyProcessor(new MultipleJGitEnvironmentProperties());
        Map sshKeysByHostname = sshUriPropertyProcessor.getSshKeysByHostname();
        Assertions.assertThat(sshKeysByHostname.values()).hasSize(0);
    }

    @Test
    public void testInvalidUriDoesNotAddEntry() {
        MultipleJGitEnvironmentProperties sshUriProperties = new MultipleJGitEnvironmentProperties();
        sshUriProperties.setUri("invalid_uri");
        SshUriPropertyProcessor sshUriPropertyProcessor = new SshUriPropertyProcessor(sshUriProperties);
        Map sshKeysByHostname = sshUriPropertyProcessor.getSshKeysByHostname();
        Assertions.assertThat(sshKeysByHostname.values()).hasSize(0);
    }

    @Test
    public void testHttpsUriDoesNotAddEntry() {
        MultipleJGitEnvironmentProperties sshUriProperties = new MultipleJGitEnvironmentProperties();
        sshUriProperties.setUri("https://user@github.com/proj/repo.git");
        SshUriPropertyProcessor sshUriPropertyProcessor = new SshUriPropertyProcessor(sshUriProperties);
        Map sshKeysByHostname = sshUriPropertyProcessor.getSshKeysByHostname();
        Assertions.assertThat(sshKeysByHostname.values()).hasSize(0);
    }

    private MultipleJGitEnvironmentProperties mainRepoPropertiesFixture() {
        MultipleJGitEnvironmentProperties result = new MultipleJGitEnvironmentProperties();
        result.setUri(URI1);
        result.setHostKeyAlgorithm(ALGO1);
        result.setHostKey(HOST_KEY1);
        result.setPrivateKey(PRIVATE_KEY1);
        return result;
    }

    private void addRepoProperties(MultipleJGitEnvironmentProperties mainRepoProperties, MultipleJGitEnvironmentProperties.PatternMatchingJGitEnvironmentProperties repoProperties, String repoName) {
        mainRepoProperties.getRepos().put(repoName, repoProperties);
    }

    private void assertMainRepo(JGitEnvironmentProperties sshKey) {
        Assertions.assertThat((Object)sshKey).isNotNull();
        Assertions.assertThat((String)SshUriPropertyProcessor.getHostname((String)sshKey.getUri())).isEqualTo(HOST1);
        Assertions.assertThat((String)sshKey.getHostKeyAlgorithm()).isEqualTo(ALGO1);
        Assertions.assertThat((String)sshKey.getHostKey()).isEqualTo(HOST_KEY1);
        Assertions.assertThat((String)sshKey.getPrivateKey()).isEqualTo(PRIVATE_KEY1);
    }
}

