/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.support;

import java.net.URISyntaxException;
import java.text.MessageFormat;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.cloud.config.server.support.GitSkipSslValidationCredentialsProvider;

@ExtendWith(value={MockitoExtension.class})
public class GitSkipSslValidationCredentialsProviderTest {
    @Mock
    private CredentialsProvider mockDelegateCredentialsProvider;
    private GitSkipSslValidationCredentialsProvider skipSslValidationCredentialsProvider;

    @BeforeEach
    public void setup() {
        this.skipSslValidationCredentialsProvider = new GitSkipSslValidationCredentialsProvider(null);
    }

    @Test
    public void testCanHandle() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)GitSkipSslValidationCredentialsProvider.canHandle((String)"https://github.com/org/repo")).as("GitSkipSslValidationCredentialsProvider only handles HTTPS uris", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)GitSkipSslValidationCredentialsProvider.canHandle((String)"git@github.com:org/repo")).as("GitSkipSslValidationCredentialsProvider only handles HTTPS uris", new Object[0])).isFalse();
    }

    @Test
    public void testIsInteractive() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.skipSslValidationCredentialsProvider.isInteractive()).as("GitSkipSslValidationCredentialsProvider with no delegate requires no user interaction", new Object[0])).isFalse();
    }

    @Test
    public void testIsInteractiveWithDelegate() {
        this.skipSslValidationCredentialsProvider = new GitSkipSslValidationCredentialsProvider(this.mockDelegateCredentialsProvider);
        Mockito.when((Object)this.mockDelegateCredentialsProvider.isInteractive()).thenReturn((Object)true);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.skipSslValidationCredentialsProvider.isInteractive()).as("With a delegate provider, isInteractive value depends on the delegate", new Object[0])).isTrue();
    }

    @Test
    public void testSupportsSslFailureInformationalMessage() {
        CredentialItem.InformationalMessage informationalMessage = new CredentialItem.InformationalMessage("text " + JGitText.get().sslFailureTrustExplanation + " more text");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.skipSslValidationCredentialsProvider.supports(new CredentialItem[]{informationalMessage})).as("GitSkipSslValidationCredentialsProvider should always support SSL failure InformationalMessage", new Object[0])).isTrue();
        informationalMessage = new CredentialItem.InformationalMessage("unrelated");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.skipSslValidationCredentialsProvider.supports(new CredentialItem[]{informationalMessage})).as("GitSkipSslValidationCredentialsProvider should not support unrelated InformationalMessage items", new Object[0])).isFalse();
    }

    @Test
    public void testSupportsSslFailureInformationalMessageWithDelegate() {
        this.skipSslValidationCredentialsProvider = new GitSkipSslValidationCredentialsProvider(this.mockDelegateCredentialsProvider);
        this.testSupportsSslFailureInformationalMessage();
    }

    @Test
    public void testSupportsSslValidationYesNoTypes() {
        CredentialItem.YesNoType yesNoType = new CredentialItem.YesNoType(JGitText.get().sslTrustNow);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.skipSslValidationCredentialsProvider.supports(new CredentialItem[]{yesNoType})).as("GitSkipSslValidationCredentialsProvider should always support the trust now YesNoType item", new Object[0])).isTrue();
        yesNoType = new CredentialItem.YesNoType(MessageFormat.format(JGitText.get().sslTrustForRepo, "/a/path.git"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.skipSslValidationCredentialsProvider.supports(new CredentialItem[]{yesNoType})).as("GitSkipSslValidationCredentialsProvider should always support the trust repo YesNoType item", new Object[0])).isTrue();
        yesNoType = new CredentialItem.YesNoType(JGitText.get().sslTrustAlways);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.skipSslValidationCredentialsProvider.supports(new CredentialItem[]{yesNoType})).as("GitSkipSslValidationCredentialsProvider should always support the trust always YesNoType item", new Object[0])).isTrue();
        yesNoType = new CredentialItem.YesNoType("unrelated");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.skipSslValidationCredentialsProvider.supports(new CredentialItem[]{yesNoType})).as("GitSkipSslValidationCredentialsProvider should not support unrelated YesNoType items", new Object[0])).isFalse();
    }

    @Test
    public void testSupportsYesNoTypeWithDelegate() {
        this.skipSslValidationCredentialsProvider = new GitSkipSslValidationCredentialsProvider(this.mockDelegateCredentialsProvider);
        this.testSupportsSslValidationYesNoTypes();
    }

    @Test
    public void testSupportsUnrelatedCredentialItemTypes() {
        CredentialItem.Username usernameCredentialItem = new CredentialItem.Username();
        boolean supportsItems = this.skipSslValidationCredentialsProvider.supports(new CredentialItem[]{usernameCredentialItem});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)supportsItems).as("Credential item types not related to SSL validation skipping should not be supported", new Object[0])).isFalse();
    }

    @Test
    public void testSupportsUnrelatedCredentialItemTypesWithDelegate() {
        this.skipSslValidationCredentialsProvider = new GitSkipSslValidationCredentialsProvider(this.mockDelegateCredentialsProvider);
        CredentialItem.Username usernameCredentialItem = new CredentialItem.Username();
        Mockito.when((Object)this.mockDelegateCredentialsProvider.supports(new CredentialItem[]{usernameCredentialItem})).thenReturn((Object)true);
        boolean supportsItems = this.skipSslValidationCredentialsProvider.supports(new CredentialItem[]{usernameCredentialItem});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)supportsItems).as("GitSkipSslValidationCredentialsProvider must support the types supported by its delegate CredentialsProvider", new Object[0])).isTrue();
    }

    @Test
    public void testGetUnrelatedCredentialItemTypes() throws URISyntaxException {
        AssertionsForClassTypes.assertThatExceptionOfType(UnsupportedCredentialItem.class).isThrownBy(() -> {
            URIish uri = new URIish("https://example.com/repo.git");
            CredentialItem.Username usernameCredentialItem = new CredentialItem.Username();
            CredentialItem.Password passwordCredentialItem = new CredentialItem.Password();
            this.skipSslValidationCredentialsProvider.get(uri, new CredentialItem[]{usernameCredentialItem, passwordCredentialItem});
        });
    }

    @Test
    public void testGetUnrelatedCredentialItemTypesWithDelegate() throws URISyntaxException {
        this.skipSslValidationCredentialsProvider = new GitSkipSslValidationCredentialsProvider(this.mockDelegateCredentialsProvider);
        URIish uri = new URIish("https://example.com/repo.git");
        CredentialItem.Username usernameCredentialItem = new CredentialItem.Username();
        CredentialItem.Password passwordCredentialItem = new CredentialItem.Password();
        Mockito.when((Object)this.mockDelegateCredentialsProvider.get(uri, new CredentialItem[]{usernameCredentialItem, passwordCredentialItem})).thenReturn((Object)true);
        boolean getSuccessful = this.skipSslValidationCredentialsProvider.get(uri, new CredentialItem[]{usernameCredentialItem, passwordCredentialItem});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)getSuccessful).as("GitSkipSslValidationCredentialsProvider must successfully get the types supported by its delegate CredentialsProvider", new Object[0])).isTrue();
    }

    @Test
    public void testGetSslTrustItems() throws URISyntaxException {
        URIish uri = new URIish("https://example.com/repo.git");
        CredentialItem.InformationalMessage message = new CredentialItem.InformationalMessage(JGitText.get().sslFailureTrustExplanation);
        CredentialItem.YesNoType trustNow = new CredentialItem.YesNoType(JGitText.get().sslTrustNow);
        CredentialItem.YesNoType trustAlways = new CredentialItem.YesNoType(JGitText.get().sslTrustAlways);
        boolean getSuccessful = this.skipSslValidationCredentialsProvider.get(uri, new CredentialItem[]{message, trustNow, trustAlways});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)getSuccessful).as("SkipSSlValidationCredentialsProvider must successfully get the types required for SSL validation skipping", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)trustNow.getValue()).as("SkipSSlValidationCredentialsProvider should trust the current repo operation", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)trustAlways.getValue()).as("We should not globally skip all SSL validation", new Object[0])).isFalse();
    }

    @Test
    public void testGetSslTrustItemsWithDelegate() throws URISyntaxException {
        this.skipSslValidationCredentialsProvider = new GitSkipSslValidationCredentialsProvider(this.mockDelegateCredentialsProvider);
        this.testGetSslTrustItems();
    }

    @Test
    public void testGetSslTrustItemsWithLocalRepo() throws URISyntaxException {
        URIish uri = new URIish("https://example.com/repo.git");
        CredentialItem.InformationalMessage message = new CredentialItem.InformationalMessage(JGitText.get().sslFailureTrustExplanation);
        CredentialItem.YesNoType trustNow = new CredentialItem.YesNoType(JGitText.get().sslTrustNow);
        CredentialItem.YesNoType trustForRepo = new CredentialItem.YesNoType(JGitText.get().sslTrustForRepo);
        CredentialItem.YesNoType trustAlways = new CredentialItem.YesNoType(JGitText.get().sslTrustAlways);
        boolean getSuccessful = this.skipSslValidationCredentialsProvider.get(uri, new CredentialItem[]{message, trustNow, trustForRepo, trustAlways});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)getSuccessful).as("SkipSSlValidationCredentialsProvider must successfully get the types required for SSL validation skipping", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)trustNow.getValue()).as("SkipSSlValidationCredentialsProvider should trust the current repo operation", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)trustForRepo.getValue()).as("Future operations on this repository should also be trusted", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)trustAlways.getValue()).as("We should not globally skip all SSL validation", new Object[0])).isFalse();
    }

    @Test
    public void testGetSslTrustItemsWithLocalRepoAndDelegate() throws URISyntaxException {
        this.skipSslValidationCredentialsProvider = new GitSkipSslValidationCredentialsProvider(this.mockDelegateCredentialsProvider);
        this.testGetSslTrustItemsWithLocalRepo();
    }

    @Test
    public void testReset() throws URISyntaxException {
        URIish uri = new URIish("https://example.com/repo.git");
        this.skipSslValidationCredentialsProvider.reset(uri);
    }

    @Test
    public void testResetWithDelegate() throws URISyntaxException {
        this.skipSslValidationCredentialsProvider = new GitSkipSslValidationCredentialsProvider(this.mockDelegateCredentialsProvider);
        URIish uri = new URIish("https://example.com/repo.git");
        this.skipSslValidationCredentialsProvider.reset(uri);
        ((CredentialsProvider)Mockito.verify((Object)this.mockDelegateCredentialsProvider)).reset(uri);
    }
}

