/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.support;

import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.TransportHttp;
import org.eclipse.jgit.transport.URIish;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.cloud.config.server.support.GoogleCloudSourceSupport;

public class GoogleCloudSourceSupportTests {
    private static final String HTTPS_GOOGLE_CLOUD_SOURCE_REPO = "https://source.developers.google.com/r/somerepo";
    private static final String HTTP_GOOGLE_CLOUD_SOURCE_REPO = "http://source.developers.google.com/r/somerepo";
    private static final String SSH_GOOGLE_CLOUD_SOURCE_REPO = "ssh://source.developers.google.com/r/somerepo";
    private static final String HTTPS_OTHER_REPO = "https://somehub.com/r/somerepo";

    @Test
    public void verifySetsAuthHeadersForHttpsGCSRepo() throws URISyntaxException {
        Map<String, String> authHeaders = this.createAuthHeaders();
        TransportConfigCallback callback = this.transportConfigCallbackWith(authHeaders);
        TransportHttp transport = this.mockTransportHttp(HTTPS_GOOGLE_CLOUD_SOURCE_REPO);
        Map<String, String> actualHeaders = this.recordSetHeaders(transport);
        callback.configure((Transport)transport);
        Assertions.assertThat(actualHeaders).containsAllEntriesOf(authHeaders);
    }

    @Test
    public void verifySetsAuthHeadersForHttpGCSRepo() throws URISyntaxException {
        Map<String, String> authHeaders = this.createAuthHeaders();
        TransportConfigCallback callback = this.transportConfigCallbackWith(authHeaders);
        TransportHttp transport = this.mockTransportHttp(HTTP_GOOGLE_CLOUD_SOURCE_REPO);
        Map<String, String> actualHeaders = this.recordSetHeaders(transport);
        callback.configure((Transport)transport);
        Assertions.assertThat(actualHeaders).containsAllEntriesOf(authHeaders);
    }

    @Test
    public void verifyDoesNothingForSshGCSRepo() throws URISyntaxException {
        TransportConfigCallback callback = this.transportConfigCallbackWith(this.createAuthHeaders());
        TransportHttp transport = this.mockTransportHttp(SSH_GOOGLE_CLOUD_SOURCE_REPO);
        callback.configure((Transport)transport);
        this.verifyOnlyValidInteraction((Transport)transport);
    }

    @Test
    public void verifyDoesNothingForHttpsOtherRepo() throws URISyntaxException {
        TransportConfigCallback callback = this.transportConfigCallbackWith(this.createAuthHeaders());
        TransportHttp transport = this.mockTransportHttp(HTTPS_OTHER_REPO);
        callback.configure((Transport)transport);
        this.verifyOnlyValidInteraction((Transport)transport);
    }

    @Test
    public void verifyDoesNothingForNonHttpTransports() throws URISyntaxException {
        TransportConfigCallback callback = this.transportConfigCallbackWith(this.createAuthHeaders());
        Transport transport = this.mockSshTransport(SSH_GOOGLE_CLOUD_SOURCE_REPO);
        callback.configure(transport);
        this.verifyOnlyValidInteraction(transport);
    }

    private void verifyOnlyValidInteraction(Transport transport) {
        ((Transport)Mockito.verify((Object)transport, (VerificationMode)Mockito.atMost((int)10000))).getURI();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{transport});
    }

    private Map<String, String> createAuthHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("WWW-Authorization", "user:password");
        return headers;
    }

    private Map<String, String> recordSetHeaders(TransportHttp transport) {
        HashMap<String, String> headers = new HashMap<String, String>();
        ((TransportHttp)Mockito.doAnswer(invocation -> {
            headers.putAll((Map)invocation.getArgument(0));
            return null;
        }).when((Object)transport)).setAdditionalHeaders(ArgumentMatchers.anyMap());
        return headers;
    }

    private TransportHttp mockTransportHttp(String uri) throws URISyntaxException {
        TransportHttp transport = (TransportHttp)Mockito.mock(TransportHttp.class);
        Mockito.when((Object)transport.getURI()).thenReturn((Object)new URIish(uri));
        return transport;
    }

    private Transport mockSshTransport(String uri) throws URISyntaxException {
        Transport transport = (Transport)Mockito.mock(SshTransport.class);
        Mockito.when((Object)transport.getURI()).thenReturn((Object)new URIish(uri));
        return transport;
    }

    private TransportConfigCallback transportConfigCallbackWith(Map<String, String> authHeaders) {
        GoogleCloudSourceSupport.CredentialsProvider credentialsProvider = () -> authHeaders;
        return new GoogleCloudSourceSupport().createTransportConfigCallback(credentialsProvider);
    }
}

