/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.support;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledOnJre;
import org.junit.jupiter.api.condition.JRE;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.server.LocalServerPort;
import org.springframework.cloud.config.server.environment.JGitEnvironmentProperties;
import org.springframework.cloud.config.server.proxy.ProxyHostProperties;
import org.springframework.cloud.config.server.support.HttpClient4Support;
import org.springframework.cloud.config.server.support.HttpEnvironmentRepositoryProperties;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;

@SpringBootTest(classes={TestConfiguration.class}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
public class HttpClient4SupportTest {
    @LocalServerPort
    private String localServerPort;

    @Test
    public void setsTimeout() throws GeneralSecurityException, IOException {
        JGitEnvironmentProperties properties = new JGitEnvironmentProperties();
        properties.setTimeout(1);
        CloseableHttpClient httpClient = HttpClient4Support.builder((HttpEnvironmentRepositoryProperties)properties).build();
        Assertions.assertThatThrownBy(() -> httpClient.execute((HttpUriRequest)new HttpGet(String.format("http://127.0.0.1:%s/test/endpoint", this.localServerPort)))).isInstanceOf(SocketTimeoutException.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @EnabledOnJre(value={JRE.JAVA_8})
    public void httpsProxy() throws GeneralSecurityException, IOException {
        WireMockServer wireMockProxyServer = new WireMockServer((Options)WireMockConfiguration.options().httpDisabled(true).dynamicHttpsPort().enableBrowserProxying(true).trustAllProxyTargets(true));
        WireMockServer wireMockServer = new WireMockServer((Options)WireMockConfiguration.options().httpDisabled(true).dynamicHttpsPort());
        wireMockProxyServer.start();
        wireMockServer.start();
        WireMock.configureFor((String)"https", (String)"localhost", (int)wireMockServer.httpsPort());
        wireMockServer.stubFor(WireMock.get((String)"/test/proxy").willReturn(WireMock.aResponse().withStatus(200)));
        JGitEnvironmentProperties properties = new JGitEnvironmentProperties();
        HashMap<ProxyHostProperties.ProxyForScheme, ProxyHostProperties> proxy = new HashMap<ProxyHostProperties.ProxyForScheme, ProxyHostProperties>();
        ProxyHostProperties hostProperties = new ProxyHostProperties();
        hostProperties.setHost("localhost");
        hostProperties.setPort(wireMockProxyServer.httpsPort());
        proxy.put(ProxyHostProperties.ProxyForScheme.HTTPS, hostProperties);
        properties.setProxy(proxy);
        properties.setSkipSslValidation(true);
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        try {
            httpClient = HttpClient4Support.builder((HttpEnvironmentRepositoryProperties)properties).build();
            response = httpClient.execute((HttpUriRequest)new HttpGet("https://localhost:" + wireMockServer.httpsPort() + "/test/proxy"));
        }
        finally {
            if (response != null) {
                response.close();
            }
            if (httpClient != null) {
                httpClient.close();
            }
            WireMock.verify((int)1, (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/test/proxy")));
        }
    }

    @SpringBootConfiguration
    @EnableWebMvc
    @EnableAutoConfiguration
    @RestController
    static class TestConfiguration {
        TestConfiguration() {
        }

        @GetMapping(value={"/test/endpoint"})
        public void testEndpoint() throws InterruptedException {
            Thread.sleep(2000L);
        }
    }
}

