/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.test;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.util.FileSystemUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public final class ConfigServerTestUtils {
    public static final String REPO_PREFIX = "target/repos/";

    private ConfigServerTestUtils() {
        throw new IllegalStateException("Can't instantiate utility class");
    }

    public static Repository prepareBareRemote() throws IOException {
        File remoteDir = File.createTempFile("remote", "");
        remoteDir.delete();
        remoteDir.mkdirs();
        RepositoryCache.FileKey fileKey = RepositoryCache.FileKey.exact((File)remoteDir, (FS)FS.DETECTED);
        Repository remoteRepo = fileKey.open(false);
        remoteRepo.create(true);
        return remoteRepo;
    }

    public static String prepareLocalRepo() throws IOException {
        return ConfigServerTestUtils.prepareLocalRepo("./", "target/repos", "config-repo", "target/config");
    }

    public static String prepareLocalRepo(String repoPath) throws IOException {
        return ConfigServerTestUtils.prepareLocalRepo("./", "target/repos", repoPath, "target/config");
    }

    public static String prepareLocalRepo(String baseDir, String buildDir, String repoPath, String checkoutDir) throws IOException {
        buildDir = baseDir + (String)buildDir;
        new File((String)buildDir).mkdirs();
        if (!((String)repoPath).startsWith("/")) {
            repoPath = "/" + (String)repoPath;
        }
        if (!((String)repoPath).endsWith("/")) {
            repoPath = (String)repoPath + "/";
        }
        File source = new File(baseDir + "src/test/resources" + (String)repoPath);
        File dest = new File((String)buildDir + (String)repoPath);
        if (dest.exists()) {
            FileUtils.delete((File)dest, (int)3);
        }
        FileSystemUtils.copyRecursively((File)source, (File)dest);
        File dotGit = new File((String)buildDir + (String)repoPath + ".git");
        File git = new File((String)buildDir + (String)repoPath + "git");
        if (git.exists() && dotGit.exists()) {
            FileUtils.delete((File)dotGit, (int)1);
        }
        git.renameTo(dotGit);
        File local = new File(checkoutDir);
        if (local.exists()) {
            FileUtils.delete((File)local, (int)1);
        }
        if (!((String)buildDir).startsWith("/")) {
            buildDir = "./" + (String)buildDir;
        }
        return "file:" + (String)buildDir + (String)repoPath;
    }

    public static String prepareLocalSvnRepo(String sourceDir, String checkoutDir) throws Exception {
        File sourceDirFile = new File(sourceDir);
        sourceDirFile.mkdirs();
        File local = new File(checkoutDir);
        if (local.exists()) {
            FileUtils.delete((File)local, (int)1);
        }
        local.mkdirs();
        FileSystemUtils.copyRecursively((File)sourceDirFile, (File)local);
        return StringUtils.cleanPath((String)("file:///" + local.getAbsolutePath()));
    }

    public static String getBaseDirectory(String potentialRoot) {
        return new File(potentialRoot).exists() ? potentialRoot + "/" : "./";
    }

    public static String copyLocalRepo(String path) throws IOException {
        File dest = new File(REPO_PREFIX + path);
        FileSystemUtils.deleteRecursively((File)dest);
        FileSystemUtils.copyRecursively((File)new File("target/repos/config-repo"), (File)dest);
        return "file:./target/repos/" + path;
    }

    public static boolean deleteLocalRepo(String path) throws IOException {
        File dest = new File(REPO_PREFIX + path);
        return FileSystemUtils.deleteRecursively((File)dest);
    }

    public static Object getProperty(Environment env, String sourceNameEndsWith, String property) {
        for (PropertySource source : env.getPropertySources()) {
            if (!source.getName().endsWith(sourceNameEndsWith)) continue;
            return source.getSource().get(property);
        }
        return null;
    }

    public static void assertConfigEnabled(Environment environment) {
        Map source = ((PropertySource)environment.getPropertySources().get(0)).getSource();
        ((ObjectAssert)Assertions.assertThat((Object)source).isNotNull()).isInstanceOf(Map.class);
        Map map = (Map)Map.class.cast(source);
        Assertions.assertThat((Map)map).containsKeys(new Object[]{"spring.cloud.config.enabled"});
        Object value = map.get("spring.cloud.config.enabled");
        Assertions.assertThat(value).isInstanceOf(Map.class);
        map = (Map)Map.class.cast(value);
        Assertions.assertThat((Map)map).containsEntry((Object)"value", (Object)"true");
    }

    public static void assertOriginTrackedValue(Environment environment, int index, String key, String expectedValue) {
        Object value = ((PropertySource)environment.getPropertySources().get(index)).getSource().get(key);
        ((ObjectAssert)Assertions.assertThat(value).isNotNull()).isInstanceOf(Map.class);
        Map map = (Map)value;
        Assertions.assertThat((Map)map).containsEntry((Object)"value", (Object)expectedValue);
    }

    public static HttpEntity getV2AcceptEntity() {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Accept", "application/vnd.spring-cloud.config-server.v2+json");
        return new HttpEntity((MultiValueMap)headers);
    }
}

