/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.autoconfigure;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.EndpointAutoConfiguration;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.actuate.endpoint.InfoEndpoint;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationBeanFactoryMetaData;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConfigurationPropertiesBindingPostProcessor;
import org.springframework.boot.context.properties.ConfigurationPropertiesBindingPostProcessorRegistrar;
import org.springframework.cloud.bootstrap.config.PropertySourceBootstrapConfiguration;
import org.springframework.cloud.bootstrap.config.RefreshEndpoint;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.cloud.context.environment.EnvironmentManager;
import org.springframework.cloud.context.properties.ConfigurationPropertiesRebinder;
import org.springframework.cloud.context.restart.RestartEndpoint;
import org.springframework.cloud.context.scope.refresh.RefreshScope;
import org.springframework.cloud.logging.LoggingRebinder;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.integration.monitor.IntegrationMBeanExporter;

@Configuration
@ConditionalOnClass(value={RefreshScope.class})
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
public class RefreshAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public static RefreshScope refreshScope() {
        return new RefreshScope();
    }

    @Bean
    @ConditionalOnMissingBean
    public static LoggingRebinder loggingRebinder() {
        return new LoggingRebinder();
    }

    @Bean
    @ConditionalOnMissingBean
    public EnvironmentManager environmentManager(ConfigurableEnvironment environment) {
        return new EnvironmentManager(environment);
    }

    @ConditionalOnClass(value={Endpoint.class})
    protected static class RefreshEndpointsConfiguration {
        protected RefreshEndpointsConfiguration() {
        }

        @Bean
        @ConfigurationProperties(value="endpoints.pause")
        public Endpoint<Boolean> pauseEndpoint(RestartEndpoint restartEndpoint) {
            return restartEndpoint.getPauseEndpoint();
        }

        @Bean
        @ConfigurationProperties(value="endpoints.resume")
        public Endpoint<Boolean> resumeEndpoint(RestartEndpoint restartEndpoint) {
            return restartEndpoint.getResumeEndpoint();
        }

        @Configuration
        @ConditionalOnProperty(value={"endpoints.refresh.enabled"}, matchIfMissing=true)
        @ConditionalOnBean(value={PropertySourceBootstrapConfiguration.class})
        protected static class RefreshEndpointConfiguration {
            protected RefreshEndpointConfiguration() {
            }

            @Bean
            @ConditionalOnMissingBean
            public RefreshEndpoint refreshEndpoint(ConfigurableApplicationContext context, RefreshScope scope) {
                RefreshEndpoint endpoint = new RefreshEndpoint(context, scope);
                return endpoint;
            }
        }

        @ConditionalOnMissingClass(name={"org.springframework.integration.monitor.IntegrationMBeanExporter"})
        protected static class RestartEndpointWithoutIntegration {
            protected RestartEndpointWithoutIntegration() {
            }

            @Bean
            @ConditionalOnMissingBean
            public RestartEndpoint restartEndpoint() {
                return new RestartEndpoint();
            }
        }

        @ConditionalOnClass(value={IntegrationMBeanExporter.class})
        protected static class RestartEndpointWithIntegration {
            @Autowired(required=false)
            private IntegrationMBeanExporter exporter;

            protected RestartEndpointWithIntegration() {
            }

            @Bean
            @ConditionalOnMissingBean
            public RestartEndpoint restartEndpoint() {
                RestartEndpoint endpoint = new RestartEndpoint();
                if (this.exporter != null) {
                    endpoint.setIntegrationMBeanExporter(this.exporter);
                }
                return endpoint;
            }
        }
    }

    @Configuration
    @ConditionalOnBean(value={ConfigurationPropertiesBindingPostProcessor.class})
    protected static class ConfigurationPropertiesRebinderConfiguration
    implements BeanFactoryAware {
        private BeanFactory context;

        protected ConfigurationPropertiesRebinderConfiguration() {
        }

        public void setBeanFactory(BeanFactory applicationContext) throws BeansException {
            this.context = applicationContext;
        }

        @Bean
        @ConditionalOnMissingBean(search=SearchStrategy.CURRENT)
        public ConfigurationPropertiesRebinder configurationPropertiesRebinder() {
            ConfigurationPropertiesBindingPostProcessor binder = (ConfigurationPropertiesBindingPostProcessor)this.context.getBean(ConfigurationPropertiesBindingPostProcessorRegistrar.BINDER_BEAN_NAME, ConfigurationPropertiesBindingPostProcessor.class);
            ConfigurationBeanFactoryMetaData metaData = (ConfigurationBeanFactoryMetaData)this.context.getBean(ConfigurationPropertiesBindingPostProcessorRegistrar.BINDER_BEAN_NAME + ".store", ConfigurationBeanFactoryMetaData.class);
            ConfigurationPropertiesRebinder rebinder = new ConfigurationPropertiesRebinder(binder);
            rebinder.setBeanMetaDataStore(metaData);
            return rebinder;
        }
    }

    @Configuration
    @ConditionalOnClass(value={InfoEndpoint.class})
    @ConditionalOnBean(value={EndpointAutoConfiguration.class})
    protected static class InfoEndpointRebinderConfiguration
    implements ApplicationListener<EnvironmentChangeEvent> {
        @Autowired
        private EndpointAutoConfiguration endpoints;
        @Autowired
        private ConfigurableEnvironment environment;
        private Map<String, Object> map = new LinkedHashMap<String, Object>();

        protected InfoEndpointRebinderConfiguration() {
        }

        public void onApplicationEvent(EnvironmentChangeEvent event) {
            for (String key : event.getKeys()) {
                if (!key.startsWith("info.")) continue;
                this.map.put(key.substring("info.".length()), this.environment.getProperty(key));
            }
        }

        @Bean
        public InfoEndpoint infoEndpoint() throws Exception {
            return new InfoEndpoint(this.endpoints.infoEndpoint().invoke()){

                public Map<String, Object> invoke() {
                    LinkedHashMap<String, Object> info = new LinkedHashMap<String, Object>(super.invoke());
                    info.putAll(InfoEndpointRebinderConfiguration.this.map);
                    return info;
                }
            };
        }
    }
}

