/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.completion;

import java.util.ArrayList;
import java.util.List;
import org.springframework.cloud.dataflow.completion.CompletionProposal;
import org.springframework.cloud.dataflow.completion.ExpansionStrategy;
import org.springframework.cloud.dataflow.completion.RecoveryStrategy;
import org.springframework.cloud.dataflow.core.StreamDefinition;
import org.springframework.cloud.dataflow.core.StreamDefinitionService;

public class StreamCompletionProvider {
    private final List<RecoveryStrategy<?>> completionRecoveryStrategies;
    private final List<ExpansionStrategy> completionExpansionStrategies;
    private final StreamDefinitionService streamDefinitionService;

    public StreamCompletionProvider(List<RecoveryStrategy<?>> completionRecoveryStrategies, List<ExpansionStrategy> completionExpansionStrategies, StreamDefinitionService streamDefinitionService) {
        this.completionRecoveryStrategies = new ArrayList(completionRecoveryStrategies);
        this.completionExpansionStrategies = new ArrayList<ExpansionStrategy>(completionExpansionStrategies);
        this.streamDefinitionService = streamDefinitionService;
    }

    public List<CompletionProposal> complete(String dslStart, int detailLevel) {
        ArrayList<CompletionProposal> collector = new ArrayList<CompletionProposal>();
        StreamDefinition streamDefinition = null;
        try {
            streamDefinition = new StreamDefinition("__dummy", dslStart);
            this.streamDefinitionService.parse(streamDefinition);
        }
        catch (Exception recoverable) {
            for (RecoveryStrategy<?> strategy : this.completionRecoveryStrategies) {
                if (!strategy.shouldTrigger(dslStart, recoverable)) continue;
                strategy.addProposals(dslStart, recoverable, detailLevel, collector);
            }
            return collector;
        }
        for (ExpansionStrategy strategy : this.completionExpansionStrategies) {
            strategy.addProposals(dslStart, streamDefinition, detailLevel, collector);
        }
        return collector;
    }

    public void addCompletionRecoveryStrategy(RecoveryStrategy recoveryStrategy) {
        this.completionRecoveryStrategies.add(recoveryStrategy);
    }
}

