/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.registry.service;

import java.net.URI;
import java.util.List;
import org.springframework.cloud.dataflow.core.AppRegistration;
import org.springframework.cloud.dataflow.core.ApplicationType;
import org.springframework.cloud.dataflow.schema.AppBootSchemaVersion;
import org.springframework.core.io.Resource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.lang.Nullable;

public interface AppRegistryService {
    public AppRegistration getDefaultApp(String var1, ApplicationType var2);

    public void validate(AppRegistration var1, String var2, String var3);

    public void setDefaultApp(String var1, ApplicationType var2, String var3);

    public AppRegistration save(String var1, ApplicationType var2, String var3, URI var4, URI var5, AppBootSchemaVersion var6);

    public void delete(String var1, ApplicationType var2, String var3);

    public void deleteAll(Iterable<AppRegistration> var1);

    public boolean appExist(String var1, ApplicationType var2, String var3);

    public Page<AppRegistration> findAll(Pageable var1);

    public Page<AppRegistration> findAllByTypeAndNameIsLike(ApplicationType var1, String var2, Pageable var3);

    public Page<AppRegistration> findAllByTypeAndNameIsLikeAndDefaultVersionIsTrue(ApplicationType var1, String var2, Pageable var3);

    public boolean appExist(String var1, ApplicationType var2);

    public List<AppRegistration> findAll();

    public AppRegistration find(String var1, ApplicationType var2);

    default public AppRegistration find(String name, ApplicationType type, String version) {
        throw new UnsupportedOperationException("version is not supported in Classic mode");
    }

    public List<AppRegistration> importAll(boolean var1, Resource ... var2);

    public Resource getAppResource(AppRegistration var1);

    public Resource getAppMetadataResource(AppRegistration var1);

    public AppRegistration save(AppRegistration var1);

    public String getResourceVersion(Resource var1);

    public String getResourceWithoutVersion(Resource var1);

    public String getResourceVersion(String var1);

    public Page<AppRegistration> findAllByTypeAndNameIsLikeAndVersionAndDefaultVersion(@Nullable ApplicationType var1, @Nullable String var2, @Nullable String var3, boolean var4, Pageable var5);
}

