/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.resource;

import java.text.DateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.TimeZone;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.converter.DefaultJobParametersConverter;
import org.springframework.batch.core.converter.JobParametersConverter;
import org.springframework.batch.support.PropertiesConverter;
import org.springframework.cloud.dataflow.rest.job.TaskJobExecution;
import org.springframework.cloud.dataflow.rest.job.support.JobUtils;
import org.springframework.cloud.dataflow.rest.job.support.TimeUtils;
import org.springframework.cloud.dataflow.rest.util.ArgumentSanitizer;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.util.Assert;

public class JobExecutionThinResource
extends RepresentationModel<JobExecutionThinResource> {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private DateFormat dateFormat = TimeUtils.getDefaultDateFormat();
    private DateFormat timeFormat = TimeUtils.getDefaultTimeFormat();
    private DateFormat durationFormat = TimeUtils.getDefaultDurationFormat();
    private Long executionId;
    private int stepExecutionCount;
    private Long jobId;
    private Long taskExecutionId;
    private Long instanceId;
    private String name;
    private String startDate = "";
    private String startTime = "";
    private Date startDateTime = null;
    private String duration = "";
    private Properties jobParameters;
    private String jobParametersString;
    private boolean restartable = false;
    private boolean abandonable = false;
    private boolean stoppable = false;
    private boolean defined;
    private JobParametersConverter converter = new DefaultJobParametersConverter();
    private TimeZone timeZone;
    private final ArgumentSanitizer argumentSanitizer = new ArgumentSanitizer();
    private BatchStatus status;

    private JobExecutionThinResource() {
    }

    public JobExecutionThinResource(TaskJobExecution taskJobExecution, TimeZone timeZone) {
        Assert.notNull((Object)taskJobExecution, (String)"taskJobExecution must not be null");
        this.taskExecutionId = taskJobExecution.getTaskId();
        JobExecution jobExecution = taskJobExecution.getJobExecution();
        this.timeZone = timeZone;
        this.executionId = jobExecution.getId();
        this.jobId = jobExecution.getJobId();
        this.stepExecutionCount = taskJobExecution.getStepExecutionCount();
        this.jobParameters = this.converter.getProperties(jobExecution.getJobParameters());
        this.jobParametersString = this.fromJobParameters(this.argumentSanitizer.sanitizeJobParameters(jobExecution.getJobParameters()));
        this.defined = taskJobExecution.isTaskDefined();
        JobInstance jobInstance = jobExecution.getJobInstance();
        this.status = taskJobExecution.getJobExecution().getStatus();
        if (jobInstance != null) {
            this.name = jobInstance.getJobName();
            this.restartable = JobUtils.isJobExecutionRestartable(jobExecution);
            this.abandonable = JobUtils.isJobExecutionAbandonable(jobExecution);
            this.stoppable = JobUtils.isJobExecutionStoppable(jobExecution);
            this.instanceId = jobExecution.getJobInstance().getInstanceId();
        } else {
            this.name = "?";
        }
        this.durationFormat.setTimeZone(TimeUtils.getDefaultTimeZone());
        this.timeFormat.setTimeZone(timeZone);
        this.dateFormat.setTimeZone(timeZone);
        if (jobExecution.getStartTime() != null) {
            this.startDate = this.dateFormat.format(jobExecution.getStartTime());
            this.startTime = this.timeFormat.format(jobExecution.getStartTime());
            Date endTime = jobExecution.getEndTime() != null ? jobExecution.getEndTime() : new Date();
            this.duration = this.durationFormat.format(new Date(endTime.getTime() - jobExecution.getStartTime().getTime()));
            this.startDateTime = jobExecution.getStartTime();
        }
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public String getName() {
        return this.name;
    }

    public Long getExecutionId() {
        return this.executionId;
    }

    public int getStepExecutionCount() {
        return this.stepExecutionCount;
    }

    public Long getJobId() {
        return this.jobId;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getDuration() {
        return this.duration;
    }

    public Long getInstanceId() {
        return this.instanceId;
    }

    public boolean isRestartable() {
        return this.restartable;
    }

    public boolean isAbandonable() {
        return this.abandonable;
    }

    public boolean isStoppable() {
        return this.stoppable;
    }

    public String getJobParametersString() {
        return this.jobParametersString;
    }

    public Properties getJobParameters() {
        return this.jobParameters;
    }

    public BatchStatus getStatus() {
        return this.status;
    }

    public Date getStartDateTime() {
        return this.startDateTime;
    }

    public long getTaskExecutionId() {
        return this.taskExecutionId;
    }

    public boolean isDefined() {
        return this.defined;
    }

    private String fromJobParameters(JobParameters oldParameters) {
        String properties = PropertiesConverter.propertiesToString((Properties)this.converter.getProperties(oldParameters));
        if (properties.startsWith("#")) {
            properties = properties.substring(properties.indexOf(LINE_SEPARATOR) + LINE_SEPARATOR.length());
        }
        properties = properties.replace("\\:", ":");
        return properties;
    }

    public static class Page
    extends PagedModel<JobExecutionThinResource> {
    }
}

