/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.integration.test;

import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="test")
public class IntegrationTestProperties {
    private DatabaseProperties database = new DatabaseProperties();
    private PlatformProperties platform = new PlatformProperties();

    public DatabaseProperties getDatabase() {
        return this.database;
    }

    public void setDatabase(DatabaseProperties database) {
        this.database = database;
    }

    public PlatformProperties getPlatform() {
        return this.platform;
    }

    public void setPlatform(PlatformProperties platform) {
        this.platform = platform;
    }

    public static class PlatformConnectionProperties {
        private String platformName = "default";
        private String prometheusUrl = "http://localhost:9090";
        private String influxUrl = "http://localhost:8086";
        private boolean applicationOverHttps;

        public String getPlatformName() {
            return this.platformName;
        }

        public void setPlatformName(String platformName) {
            this.platformName = platformName;
        }

        public String getPrometheusUrl() {
            return this.prometheusUrl;
        }

        public void setPrometheusUrl(String prometheusUrl) {
            this.prometheusUrl = prometheusUrl;
        }

        public String getInfluxUrl() {
            return this.influxUrl;
        }

        public void setInfluxUrl(String influxUrl) {
            this.influxUrl = influxUrl;
        }

        public boolean isApplicationOverHttps() {
            return this.applicationOverHttps;
        }

        public void setApplicationOverHttps(boolean applicationOverHttps) {
            this.applicationOverHttps = applicationOverHttps;
        }
    }

    public static class PlatformProperties {
        private PlatformConnectionProperties connection = new PlatformConnectionProperties();

        public PlatformConnectionProperties getConnection() {
            return this.connection;
        }

        public void setConnection(PlatformConnectionProperties connection) {
            this.connection = connection;
        }
    }

    public static class ImageProperties {
        private String image;
        private String tag;

        public String getImage() {
            return this.image;
        }

        public void setImage(String image) {
            this.image = image;
        }

        public String getTag() {
            return this.tag;
        }

        public void setTag(String tag) {
            this.tag = tag;
        }
    }

    public static class AdditionalImageProperties {
        private Map<String, ImageProperties> datatabase = new HashMap<String, ImageProperties>();

        public Map<String, ImageProperties> getDatatabase() {
            return this.datatabase;
        }

        public void setDatatabase(Map<String, ImageProperties> datatabase) {
            this.datatabase = datatabase;
        }
    }

    public static class DatabaseProperties {
        private String dataflowVersion;
        private String skipperVersion;
        private boolean sharedDatabase;
        private AdditionalImageProperties additionalImages = new AdditionalImageProperties();

        public String getDataflowVersion() {
            return this.dataflowVersion;
        }

        public void setDataflowVersion(String dataflowVersion) {
            this.dataflowVersion = dataflowVersion;
        }

        public String getSkipperVersion() {
            return this.skipperVersion;
        }

        public void setSkipperVersion(String skipperVersion) {
            this.skipperVersion = skipperVersion;
        }

        public boolean isSharedDatabase() {
            return this.sharedDatabase;
        }

        public void setSharedDatabase(boolean sharedDatabase) {
            this.sharedDatabase = sharedDatabase;
        }

        public AdditionalImageProperties getAdditionalImages() {
            return this.additionalImages;
        }

        public void setAdditionalImages(AdditionalImageProperties additionalImages) {
            this.additionalImages = additionalImages;
        }
    }
}

