/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.integration.test.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.dataflow.integration.test.IntegrationTestProperties;
import org.springframework.cloud.dataflow.integration.test.db.container.DataflowCluster;
import org.springframework.cloud.dataflow.integration.test.util.AssertUtils;
import org.springframework.context.annotation.Configuration;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers
@SpringBootTest(classes={EmptyConfig.class})
@EnableConfigurationProperties(value={IntegrationTestProperties.class})
public abstract class AbstractDataflowTests {
    public static final String DATAFLOW_IMAGE_PREFIX = "springcloud/spring-cloud-dataflow-server:";
    public static final String SKIPPER_IMAGE_PREFIX = "springcloud/spring-cloud-skipper-server:";
    public static final List<DataflowCluster.ClusterContainer> DATAFLOW_CONTAINERS = Arrays.asList(DataflowCluster.ClusterContainer.from("dataflow_2_7", "springcloud/spring-cloud-dataflow-server:2.7.2"), DataflowCluster.ClusterContainer.from("dataflow_2_8", "springcloud/spring-cloud-dataflow-server:2.8.4"), DataflowCluster.ClusterContainer.from("dataflow_2_9", "springcloud/spring-cloud-dataflow-server:2.9.6"), DataflowCluster.ClusterContainer.from("dataflow_2_10", "springcloud/spring-cloud-dataflow-server:2.10.0"));
    public static final List<DataflowCluster.ClusterContainer> SKIPPER_CONTAINERS = Arrays.asList(DataflowCluster.ClusterContainer.from("skipper_2_6", "springcloud/spring-cloud-skipper-server:2.6.2"), DataflowCluster.ClusterContainer.from("skipper_2_7", "springcloud/spring-cloud-skipper-server:2.7.4"), DataflowCluster.ClusterContainer.from("skipper_2_8", "springcloud/spring-cloud-skipper-server:2.8.6"), DataflowCluster.ClusterContainer.from("skipper_2_9", "springcloud/spring-cloud-skipper-server:2.9.0"));
    public static final List<DataflowCluster.ClusterContainer> DATABASE_CONTAINERS = Arrays.asList(DataflowCluster.ClusterContainer.from("postgres_10", "postgres:10", "postgres"), DataflowCluster.ClusterContainer.from("mariadb_10_2", "mariadb:10.2", "mariadb"), DataflowCluster.ClusterContainer.from("mariadb_10_3", "mariadb:10.3", "mariadb"), DataflowCluster.ClusterContainer.from("mariadb_10_4", "mariadb:10.4", "mariadb"), DataflowCluster.ClusterContainer.from("mariadb_10_5", "mariadb:10.5", "mariadb"), DataflowCluster.ClusterContainer.from("mssql_2019_CU10_ubuntu_20_04", "mcr.microsoft.com/mssql/server:2019-CU10-ubuntu-20.04", "mssql"), DataflowCluster.ClusterContainer.from("mssql_2019_CU16_ubuntu_20_04", "mcr.microsoft.com/mssql/server:2019-CU16-ubuntu-20.04", "mssql"), DataflowCluster.ClusterContainer.from("mssql_2022_CTP2_0_ubuntu_20_04", "mcr.microsoft.com/mssql/server:2022-CTP2.0-ubuntu-20.04", "mssql"), DataflowCluster.ClusterContainer.from("oracle_12_2_0_1_se2", "dev.registry.pivotal.io/p-scdf-for-kubernetes/oracle/database-prebuilt:12.2.0.1-se2", "oracle"), DataflowCluster.ClusterContainer.from("db2_11_5_0_0a", "ibmcom/db2:11.5.0.0a", "db2"), DataflowCluster.ClusterContainer.from("db2_10_5_0_5_3_10_0", "dev.registry.pivotal.io/p-scdf-for-kubernetes/ibmcom/database-prebuilt:10.5.0.5-3.10.0", "db2"));
    public static final List<DataflowCluster.ClusterContainer> OAUTH_CONTAINERS = Arrays.asList(DataflowCluster.ClusterContainer.from("uaa_4_32", "projects.registry.vmware.com/scdf/uaa-test:4.32", "uaa"));
    @Autowired
    private IntegrationTestProperties testProperties;
    private GenericContainer<?> toolsContainer = null;
    protected DataflowCluster dataflowCluster;

    @AfterEach
    public void cleanCluster() {
        if (this.dataflowCluster != null) {
            this.dataflowCluster.stop();
        }
        this.dataflowCluster = null;
        if (this.toolsContainer != null) {
            this.toolsContainer.stop();
            this.toolsContainer = null;
        }
    }

    @BeforeEach
    public void setupCluster() {
        this.dataflowCluster = new DataflowCluster(this.getDatabaseContainers(), this.getOauthContainers(), this.getSkipperContainers(), this.getDataflowContainers(), this.testProperties.getDatabase().isSharedDatabase());
    }

    protected Container.ExecResult execInToolsContainer(String ... command) throws UnsupportedOperationException, IOException, InterruptedException {
        if (this.toolsContainer == null) {
            this.toolsContainer = new GenericContainer("praqma/network-multitool:latest");
            this.toolsContainer.withNetwork(this.dataflowCluster.getNetwork());
            this.toolsContainer.start();
        }
        return this.toolsContainer.execInContainer(command);
    }

    protected IntegrationTestProperties getTestProperties() {
        return this.testProperties;
    }

    protected String getDataflowLatestVersion() {
        return this.testProperties.getDatabase().getDataflowVersion();
    }

    protected String getSkipperLatestVersion() {
        return this.testProperties.getDatabase().getSkipperVersion();
    }

    protected List<DataflowCluster.ClusterContainer> getOauthContainers() {
        ArrayList<DataflowCluster.ClusterContainer> containers = new ArrayList<DataflowCluster.ClusterContainer>(OAUTH_CONTAINERS);
        return containers;
    }

    protected List<DataflowCluster.ClusterContainer> getDatabaseContainers() {
        ArrayList<DataflowCluster.ClusterContainer> containers = new ArrayList<DataflowCluster.ClusterContainer>(DATABASE_CONTAINERS);
        List additional = this.testProperties.getDatabase().getAdditionalImages().getDatatabase().entrySet().stream().map(e -> DataflowCluster.ClusterContainer.from((String)e.getKey(), ((IntegrationTestProperties.ImageProperties)e.getValue()).getImage(), ((IntegrationTestProperties.ImageProperties)e.getValue()).getTag())).collect(Collectors.toList());
        containers.addAll(additional);
        return containers;
    }

    protected List<DataflowCluster.ClusterContainer> getSkipperContainers() {
        ArrayList<DataflowCluster.ClusterContainer> containers = new ArrayList<DataflowCluster.ClusterContainer>(SKIPPER_CONTAINERS);
        containers.add(DataflowCluster.ClusterContainer.from("skipper_main", SKIPPER_IMAGE_PREFIX + this.getSkipperLatestVersion()));
        return containers;
    }

    protected List<DataflowCluster.ClusterContainer> getDataflowContainers() {
        ArrayList<DataflowCluster.ClusterContainer> containers = new ArrayList<DataflowCluster.ClusterContainer>(DATAFLOW_CONTAINERS);
        containers.add(DataflowCluster.ClusterContainer.from("dataflow_main", DATAFLOW_IMAGE_PREFIX + this.getDataflowLatestVersion()));
        return containers;
    }

    protected static void assertSkipperServerRunning(DataflowCluster dataflowCluster) {
        AssertUtils.assertSkipperServerRunning(dataflowCluster.getSkipperUrl());
    }

    protected static void assertSkipperServerNotRunning(DataflowCluster dataflowCluster) {
        AssertUtils.assertSkipperServerNotRunning(dataflowCluster.getSkipperUrl());
    }

    protected static void assertDataflowServerRunning(DataflowCluster dataflowCluster) {
        AssertUtils.assertDataflowServerRunning(dataflowCluster.getDataflowUrl());
    }

    protected static void assertDataflowServerNotRunning(DataflowCluster dataflowCluster) {
        AssertUtils.assertDataflowServerNotRunning(dataflowCluster.getDataflowUrl());
    }

    @Configuration
    protected static class EmptyConfig {
        protected EmptyConfig() {
        }
    }
}

