/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.integration.test.db;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.dataflow.integration.test.db.AbstractDatabaseTests;
import org.springframework.cloud.dataflow.integration.test.tags.Database;
import org.springframework.cloud.dataflow.integration.test.tags.DatabaseFailure;
import org.springframework.cloud.dataflow.integration.test.tags.DatabaseSlow;
import org.springframework.cloud.dataflow.integration.test.tags.DataflowAll;
import org.springframework.cloud.dataflow.integration.test.tags.DataflowMain;

@Database
public abstract class AbstractPostgresDatabaseTests
extends AbstractDatabaseTests {
    private final Logger log = LoggerFactory.getLogger(AbstractPostgresDatabaseTests.class);

    @Test
    @DataflowMain
    @DatabaseFailure
    public void testMigrationError() {
        this.log.info("Running testMigrationError()");
        this.dataflowCluster.startSkipperDatabase(this.getDatabaseTag());
        this.dataflowCluster.startDataflowDatabase(this.getDatabaseTag());
        this.runExecute(this.getTestMigrationErrorBreakClause());
        this.dataflowCluster.startSkipper("skipper_main");
        AbstractPostgresDatabaseTests.assertSkipperServerRunning(this.dataflowCluster);
        this.dataflowCluster.startDataflow("dataflow_main");
        AbstractPostgresDatabaseTests.assertDataflowServerNotRunning(this.dataflowCluster);
        try {
            this.dataflowCluster.stopDataflow();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Integer count = this.runCountQuery("select count(*) from flyway_schema_history_dataflow");
        Assertions.assertThat((Integer)count).isEqualTo(-1);
        this.runExecute(this.getTestMigrationErrorFixClause());
        this.dataflowCluster.startDataflow("dataflow_main");
        AbstractPostgresDatabaseTests.assertDataflowServerRunning(this.dataflowCluster);
        count = this.runCountQuery("select count(*) from flyway_schema_history_dataflow");
        Assertions.assertThat((Integer)count).isGreaterThan(1);
    }

    protected abstract String getTestMigrationErrorBreakClause();

    protected abstract String getTestMigrationErrorFixClause();

    @Override
    @Test
    @DataflowAll
    @DatabaseSlow
    public void testFullMigrationFlow() {
        super.testFullMigrationFlow();
    }
}

