/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.integration.test.util;

import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.dataflow.rest.client.dsl.Stream;
import org.springframework.cloud.dataflow.rest.client.dsl.StreamApplication;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class AwaitUtils {
    private static final Logger logger = LoggerFactory.getLogger(AwaitUtils.class);

    public static StreamLog logOffset(Stream stream) {
        return new StreamLog(stream);
    }

    public static StreamLog logOffset(Stream stream, boolean atCurrentEnd) {
        return new StreamLog(stream, atCurrentEnd);
    }

    public static StreamLog logOffset(Stream stream, String app) {
        return new StreamLog(stream, app);
    }

    public static StreamLog logOffset(Stream stream, String app, boolean atCurrentEnd) {
        return new StreamLog(stream, app, atCurrentEnd);
    }

    public static boolean hasErrorInLog(StreamLog offset) {
        return AwaitUtils.hasInLog(offset, " ERROR ");
    }

    public static boolean hasInLog(StreamLog offset, String value) {
        String log = offset.logs();
        String status = offset.getStatus();
        if (log.contains(value)) {
            String msg = "hasInLog:" + value + ":" + offset.getName() + ":" + status + ":" + AwaitUtils.expand(AwaitUtils.linesBeforeAfter(log, value));
            if (value.contains("ERROR")) {
                logger.error(msg);
            } else {
                logger.info(msg);
            }
            return true;
        }
        if (StringUtils.hasText((String)log)) {
            logger.debug("hasInLog:{}:{}:{}:{}", new Object[]{value, offset.getName(), status, AwaitUtils.expand(log)});
        }
        return false;
    }

    public static boolean hasRegexInLog(StreamLog offset, String regex) {
        String log = offset.logs();
        String status = offset.getStatus();
        if (Pattern.matches(regex, log)) {
            logger.info("hasRegexInLog:" + offset.getName() + ":" + status + ":" + AwaitUtils.expand(AwaitUtils.linesBeforeAfterRegex(log, regex)));
            return true;
        }
        if (StringUtils.hasText((String)log)) {
            logger.debug("hasRegexInLog:{}:{}:{}", new Object[]{offset.getName(), status, AwaitUtils.expand(log)});
        }
        return false;
    }

    public static String expand(String log) {
        return log.replace("\\t", "\t").replace("\\n", "\n").replace("\\r", "\r");
    }

    public static String linesBeforeAfter(String log, String match) {
        int matchIndex = log.indexOf(match);
        if (matchIndex > 0) {
            String target = log.substring(matchIndex > 320 ? matchIndex - 320 : matchIndex);
            int start = target.indexOf(10);
            if (start < 0) {
                start = 0;
            }
            return target.substring(start);
        }
        return log;
    }

    public static String linesBeforeAfterRegex(String log, String regex) {
        Pattern pattern = Pattern.compile(regex);
        String[] sections = pattern.split(log);
        int matchIndex = log.indexOf(sections.length > 1 ? sections[1] : sections[0]);
        if (matchIndex > 0) {
            String target = log.substring(matchIndex > 320 ? matchIndex - 320 : matchIndex);
            int start = target.indexOf(10);
            if (start < 0) {
                start = 0;
            }
            return target.substring(start);
        }
        return log;
    }

    public static class StreamLog {
        Stream stream;
        int offset = 0;
        String appName;

        public StreamLog(Stream stream) {
            this.stream = stream;
            this.setupOffset(false);
        }

        public StreamLog(Stream stream, String appName) {
            this.stream = stream;
            this.appName = appName;
            this.setupOffset(false);
        }

        public StreamLog(Stream stream, boolean atCurrentEnd) {
            this.stream = stream;
            this.setupOffset(atCurrentEnd);
        }

        public StreamLog(Stream stream, String appName, boolean atCurrentEnd) {
            this.stream = stream;
            this.appName = appName;
            this.setupOffset(atCurrentEnd);
        }

        private void setupOffset(boolean atCurrentEnd) {
            this.offset = 0;
            if (atCurrentEnd) {
                String log = this.extractLog();
                this.offset = log.length();
                Assert.isTrue((this.offset >= 0 ? 1 : 0) != 0, (String)("Expected offset >= 0 not " + this.offset));
            }
        }

        public String logs() {
            String log = this.extractLog();
            Assert.isTrue((this.offset >= 0 ? 1 : 0) != 0, (String)("Expected offset >= 0 not " + this.offset));
            String result = log.length() > this.offset ? log.substring(this.offset) : log;
            this.offset = log.length();
            Assert.isTrue((this.offset >= 0 ? 1 : 0) != 0, (String)("Expected offset >= 0 not " + this.offset));
            return result;
        }

        private String extractLog() {
            String log;
            if (StringUtils.hasText((String)this.appName)) {
                StreamApplication application = new StreamApplication(this.appName);
                log = this.stream.logs(application);
            } else {
                log = this.stream.logs();
            }
            return log == null ? "" : log;
        }

        public String getStatus() {
            return this.stream.getStatus();
        }

        public String getName() {
            return this.stream.getName();
        }
    }
}

