/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.integration.test.util;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.FileCopyUtils;

public class ResourceExtractor {
    private final Logger logger = LoggerFactory.getLogger(ResourceExtractor.class);
    private final Path rootPath;
    private final ResourceLoader resourceLoader;

    public ResourceExtractor(Path rootPath) {
        this.rootPath = rootPath;
        this.resourceLoader = new DefaultResourceLoader();
    }

    public String[] extract(String ... resourceUris) {
        return Arrays.stream(resourceUris).map(this::extract).filter(Objects::nonNull).collect(Collectors.toList()).toArray(new String[resourceUris.length]);
    }

    public String extract(String resourceUri) {
        if (!resourceUri.contains(":")) {
            return resourceUri;
        }
        try {
            Resource resource = this.resourceLoader.getResource(resourceUri);
            Path localResourcePath = Paths.get(this.rootPath.toString(), resource.getFilename());
            FileCopyUtils.copy((InputStream)resource.getInputStream(), (OutputStream)new FileOutputStream(localResourcePath.toFile()));
            return localResourcePath.toString();
        }
        catch (IOException e) {
            this.logger.error("Failed to extract:" + resourceUri, (Throwable)e);
            return null;
        }
    }
}

