/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.integration.test.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.zafarkhaja.semver.Version;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.dataflow.core.ApplicationType;
import org.springframework.cloud.dataflow.core.ArgumentSanitizer;
import org.springframework.cloud.dataflow.rest.client.DataFlowTemplate;
import org.springframework.cloud.dataflow.rest.resource.AppInstanceStatusResource;
import org.springframework.cloud.dataflow.rest.resource.AppStatusResource;
import org.springframework.cloud.dataflow.rest.resource.DetailedAppRegistrationResource;
import org.springframework.cloud.dataflow.rest.resource.StreamStatusResource;
import org.springframework.cloud.skipper.domain.Deployer;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class RuntimeApplicationHelper {
    public static final String LOCAL_PLATFORM_TYPE = "local";
    public static final String KUBERNETES_PLATFORM_TYPE = "kubernetes";
    public static final String CLOUDFOUNDRY_PLATFORM_TYPE = "cloudfoundry";
    private final Logger logger = LoggerFactory.getLogger(RuntimeApplicationHelper.class);
    private final String platformType;
    private final DataFlowTemplate dataFlowTemplate;
    private final String platformName;
    private final Version dataflowServerVersion;
    private boolean httpsStreamApplications;

    public RuntimeApplicationHelper(DataFlowTemplate dataFlowTemplate, String platformName, boolean httpsStreamApplications) {
        this.httpsStreamApplications = httpsStreamApplications;
        Assert.notNull((Object)dataFlowTemplate, (String)("Valid dataFlowOperations is expected but was: " + dataFlowTemplate));
        Assert.hasText((String)platformName, (String)("Empty platform name: " + platformName));
        this.logger.debug("platform Name: [" + platformName + "]");
        this.dataFlowTemplate = dataFlowTemplate;
        this.platformName = platformName;
        this.platformType = dataFlowTemplate.streamOperations().listPlatforms().stream().filter(p -> p.getName().equalsIgnoreCase(platformName)).map(Deployer::getType).findFirst().get();
        this.dataflowServerVersion = Version.valueOf((String)dataFlowTemplate.aboutOperation().get().getVersionInfo().getCore().getVersion());
        Assert.hasText((String)this.platformType, (String)("Could not find platform type for: " + platformName));
    }

    public Version getDataflowServerVersion() {
        return this.dataflowServerVersion;
    }

    public boolean dataflowServerVersionEqualOrGreaterThan(String version) {
        return this.dataflowServerVersion.compareTo(Version.valueOf((String)version)) >= 0;
    }

    public boolean dataflowServerVersionLowerThan(String version) {
        return this.dataflowServerVersion.compareTo(Version.valueOf((String)version)) < 0;
    }

    public String getPlatformName() {
        return this.platformName;
    }

    public String getPlatformType() {
        return this.platformType;
    }

    public Map<String, Map<String, String>> appInstanceAttributes() {
        HashMap<String, Map<String, String>> appInstanceAttributes = new HashMap<String, Map<String, String>>();
        PagedModel apps = this.dataFlowTemplate.runtimeOperations().status();
        for (AppStatusResource app : apps) {
            CollectionModel instances = app.getInstances();
            for (AppInstanceStatusResource instance : instances) {
                Map attrs = instance.getAttributes();
                appInstanceAttributes.put(instance.getInstanceId(), attrs);
            }
        }
        return appInstanceAttributes;
    }

    public Map<String, Map<String, String>> getApplicationInstances(String streamName, String appName) {
        return this.appInstanceAttributes().values().stream().filter(v -> ((String)v.get("skipper.release.name")).equals(streamName)).filter(v -> ((String)v.get("skipper.application.name")).equals(appName)).collect(Collectors.toMap(v -> (String)v.get("guid"), v -> v));
    }

    public Map<String, String> applicationInstanceLogs(String streamName, String appName) {
        Awaitility.await().until(() -> this.getApplicationInstances(streamName, appName).values().stream().allMatch(instanceAttributes -> this.isUrlAccessible(this.getApplicationInstanceUrl((Map<String, String>)instanceAttributes) + "/actuator/info")));
        return this.appInstanceAttributes().values().stream().filter(v -> ((String)v.get("skipper.release.name")).equals(streamName)).filter(v -> ((String)v.get("skipper.application.name")).equals(appName)).collect(Collectors.toMap(v -> (String)v.get("guid"), v -> this.getAppInstanceLogContent(this.getApplicationInstanceUrl((Map<String, String>)v))));
    }

    public String getApplicationInstanceUrl(String streamName, String appName) {
        return this.getApplicationInstanceUrl(this.getApplicationInstances(streamName, appName).values().iterator().next());
    }

    public String getApplicationInstanceUrl(Map<String, String> instanceAttributes) {
        switch (this.platformType) {
            case "local": {
                return this.localApplicationInstanceUrl(instanceAttributes);
            }
            case "kubernetes": {
                return this.kubernetesApplicationInstanceUrl(instanceAttributes);
            }
            case "cloudfoundry": {
                return this.cloudFoundryApplicationInstanceUrl(instanceAttributes);
            }
        }
        throw new IllegalStateException("Unknown platform type:" + this.platformType);
    }

    private String localApplicationInstanceUrl(Map<String, String> instanceAttributes) {
        return String.format("%s://localhost:%s", this.httpsStreamApplications ? "https" : "http", instanceAttributes.get("port"));
    }

    private String cloudFoundryApplicationInstanceUrl(Map<String, String> instanceAttributes) {
        return instanceAttributes.get("url").replace("http:", "https:").toLowerCase();
    }

    private String kubernetesApplicationInstanceUrl(Map<String, String> instanceAttributes) {
        String appInstanceUrl = instanceAttributes.get("url");
        if (this.httpsStreamApplications) {
            appInstanceUrl = appInstanceUrl.replace("http:", "https:").toLowerCase();
        }
        return appInstanceUrl;
    }

    private String getAppInstanceLogContent(String instanceUrl) {
        String logContent = "";
        String logFileUrl = String.format("%s/actuator/logfile", instanceUrl);
        try {
            logContent = (String)this.dataFlowTemplate.getRestTemplate().getForObject(logFileUrl, String.class, new Object[0]);
            if (logContent == null) {
                this.logger.warn("Unable to retrieve logfile from '" + logFileUrl);
                logContent = "empty";
            }
        }
        catch (Exception e) {
            this.logger.warn("Error while trying to access logfile from '" + logFileUrl + "' due to : ", (Throwable)e);
        }
        return logContent;
    }

    public boolean isServicePresent(String serviceUrl) {
        if (null != serviceUrl) {
            try {
                this.dataFlowTemplate.getRestTemplate().getForObject(serviceUrl, String.class, new Object[0]);
                return true;
            }
            catch (Exception e) {
                this.logger.trace("isServicePresent:" + serviceUrl + ":exception:" + e);
            }
        }
        return false;
    }

    private boolean isUrlAccessible(String serviceUrl) {
        if (null != serviceUrl) {
            try {
                Set optionsForAllow = this.dataFlowTemplate.getRestTemplate().optionsForAllow(serviceUrl, new Object[0]);
                return !CollectionUtils.isEmpty((Collection)optionsForAllow);
            }
            catch (Exception e) {
                this.logger.trace("isUrlAccessible:" + serviceUrl + ":exception:" + e);
            }
        }
        return false;
    }

    public void httpPost(String streamName, String appName, String message) {
        Assert.notNull((Object)message, (String)"message required");
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "text/plain");
        this.httpPost(streamName, appName, message.getBytes(StandardCharsets.UTF_8), headers);
    }

    public void httpPostJson(String streamName, String appName, Object obj) throws JsonProcessingException {
        Assert.notNull((Object)obj, (String)"obj required");
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("Accept", "application/json");
        String message = obj instanceof String ? (String)obj : new ObjectMapper().writeValueAsString(obj);
        this.httpPost(streamName, appName, message.getBytes(StandardCharsets.UTF_8), headers);
    }

    public void httpPost(String url, String message) {
        ResponseEntity response = this.dataFlowTemplate.getRestTemplate().postForEntity(url, (Object)message, String.class, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new RuntimeException("Exception posting:" + response.getStatusCode() + ":" + (String)response.getBody());
        }
    }

    public void httpPost(String streamName, String appName, byte[] message, HttpHeaders headers) {
        AppInstanceStatusResource instance = null;
        AppStatusResource app = null;
        StreamStatusResource streamStatusResource = this.dataFlowTemplate.runtimeOperations().streamStatus(new String[]{streamName}).getContent().stream().filter(stream -> stream.getName().equals(streamName)).findFirst().orElse(null);
        if (streamStatusResource != null && (app = (AppStatusResource)streamStatusResource.getApplications().getContent().stream().filter(appStatusResource -> appStatusResource.getName().equals(appName)).findFirst().orElse(null)) != null) {
            instance = app.getInstances().getContent().stream().filter(appInstanceStatusResource -> "deployed".equals(appInstanceStatusResource.getState())).findFirst().orElse(null);
        }
        if (instance == null) {
            this.logger.error("Cannot find instance of " + streamName + ":" + appName);
            throw new RuntimeException("Cannot find instance of " + streamName + ":" + appName);
        }
        try {
            this.logger.debug("postToUrl:{}:{}:{}", new Object[]{app.getDeploymentId(), instance.getInstanceId(), headers});
            this.dataFlowTemplate.runtimeOperations().postToUrl(app.getDeploymentId(), instance.getInstanceId(), message, headers);
        }
        catch (Throwable x) {
            if (x.toString().contains("post endpoint not found")) {
                this.logger.warn("Try with url only:" + x);
                String url = (String)instance.getAttributes().get("url");
                if (StringUtils.hasText((String)url)) {
                    Awaitility.await((String)(url + " available")).atMost(1L, TimeUnit.MINUTES).until(() -> this.isUrlAccessible(url));
                    HttpEntity httpEntity = new HttpEntity((Object)message, (MultiValueMap)headers);
                    this.dataFlowTemplate.getRestTemplate().exchange(url, HttpMethod.POST, httpEntity, String.class, new Object[0]);
                }
                String error = "Cannot find url for " + streamStatusResource.getName() + ":" + app.getName();
                ArgumentSanitizer sanitizer = new ArgumentSanitizer();
                this.logger.error(error + ":" + sanitizer.sanitizeProperties(instance.getAttributes()));
                throw new RuntimeException(error);
            }
            this.logger.error("postToUrl:" + streamName + ":" + appName + ":" + x, x);
            throw x;
        }
    }

    public String httpGet(String url) {
        return (String)this.dataFlowTemplate.getRestTemplate().getForObject(url, String.class, new Object[0]);
    }

    public boolean isAppRegistered(String name, ApplicationType type, String version) {
        try {
            DetailedAppRegistrationResource registration = this.dataFlowTemplate.appRegistryOperations().info(name, type, version, false);
            return registration != null;
        }
        catch (Exception e) {
            this.logger.trace("isAppRegistered:" + name + ":" + type + ":" + version + ":exception:" + e);
            return false;
        }
    }

    public boolean isAppRegistered(String name, ApplicationType type) {
        try {
            DetailedAppRegistrationResource registration = this.dataFlowTemplate.appRegistryOperations().info(name, type, false);
            return registration != null;
        }
        catch (Exception e) {
            this.logger.trace("isAppRegistered:" + name + ":" + type + ":exception:" + e);
            return false;
        }
    }
}

