/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.integration.test.db;

import javax.sql.DataSource;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.dataflow.integration.test.db.AbstractDataflowTests;
import org.springframework.cloud.dataflow.integration.test.tags.Database;
import org.springframework.cloud.dataflow.integration.test.tags.DatabaseSlow;
import org.springframework.cloud.dataflow.integration.test.tags.DataflowAll;
import org.springframework.cloud.dataflow.integration.test.tags.DataflowMain;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;

@Database
public abstract class AbstractDatabaseTests
extends AbstractDataflowTests {
    private final Logger log = LoggerFactory.getLogger(AbstractDatabaseTests.class);

    protected abstract String getDatabaseTag();

    @Test
    @DataflowMain
    public void testLatestSharedDb() {
        this.log.info("Running testLatestSharedDb()");
        this.dataflowCluster.startSkipperDatabase(this.getDatabaseTag());
        this.dataflowCluster.startDataflowDatabase(this.getDatabaseTag());
        this.dataflowCluster.startSkipper("skipper_main");
        AbstractDatabaseTests.assertSkipperServerRunning(this.dataflowCluster);
        this.dataflowCluster.startDataflow("dataflow_main");
        AbstractDatabaseTests.assertDataflowServerRunning(this.dataflowCluster);
    }

    protected Integer runCountQuery(String sql) {
        try {
            return this.runQuery(sql, Integer.class);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    protected <T> T runQuery(String sql, Class<T> requiredType) {
        JdbcTemplate jdbcTemplate = this.getJdbcTemplate();
        return (T)jdbcTemplate.queryForObject(sql, requiredType);
    }

    protected void runExecute(String sql) {
        JdbcTemplate jdbcTemplate = this.getJdbcTemplate();
        jdbcTemplate.execute(sql);
    }

    protected JdbcTemplate getJdbcTemplate() {
        String jdbcUrl = this.dataflowCluster.getDataflowDatabaseHostJdbcUrl();
        SingleConnectionDataSource dataSource = new SingleConnectionDataSource(jdbcUrl, "spring", "spring", false);
        return new JdbcTemplate((DataSource)dataSource);
    }

    @Test
    @DataflowAll
    @DatabaseSlow
    public void testFullMigrationFlow() {
        this.log.info("Running testFullMigrationFlow()");
        this.dataflowCluster.startSkipperDatabase(this.getDatabaseTag());
        this.dataflowCluster.startDataflowDatabase(this.getDatabaseTag());
        this.dataflowCluster.startSkipper("skipper_2_0");
        AbstractDatabaseTests.assertSkipperServerRunning(this.dataflowCluster);
        this.dataflowCluster.startDataflow("dataflow_2_0");
        AbstractDatabaseTests.assertDataflowServerRunning(this.dataflowCluster);
        this.dataflowCluster.replaceDataflow("dataflow_2_1");
        AbstractDatabaseTests.assertDataflowServerRunning(this.dataflowCluster);
        this.dataflowCluster.replaceSkipperAndDataflow("skipper_2_1", "dataflow_2_2");
        AbstractDatabaseTests.assertSkipperServerRunning(this.dataflowCluster);
        AbstractDatabaseTests.assertDataflowServerRunning(this.dataflowCluster);
        this.dataflowCluster.replaceSkipperAndDataflow("skipper_2_2", "dataflow_2_3");
        AbstractDatabaseTests.assertSkipperServerRunning(this.dataflowCluster);
        AbstractDatabaseTests.assertDataflowServerRunning(this.dataflowCluster);
        this.dataflowCluster.replaceSkipperAndDataflow("skipper_2_3", "dataflow_2_4");
        AbstractDatabaseTests.assertSkipperServerRunning(this.dataflowCluster);
        AbstractDatabaseTests.assertDataflowServerRunning(this.dataflowCluster);
        this.dataflowCluster.replaceSkipperAndDataflow("skipper_2_4", "dataflow_2_5");
        AbstractDatabaseTests.assertSkipperServerRunning(this.dataflowCluster);
        AbstractDatabaseTests.assertDataflowServerRunning(this.dataflowCluster);
        this.dataflowCluster.replaceSkipperAndDataflow("skipper_2_5", "dataflow_2_6");
        AbstractDatabaseTests.assertSkipperServerRunning(this.dataflowCluster);
        AbstractDatabaseTests.assertDataflowServerRunning(this.dataflowCluster);
        this.dataflowCluster.replaceSkipperAndDataflow("skipper_2_6", "dataflow_2_7");
        AbstractDatabaseTests.assertSkipperServerRunning(this.dataflowCluster);
        AbstractDatabaseTests.assertDataflowServerRunning(this.dataflowCluster);
    }
}

