/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.integration.test.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.dataflow.integration.test.IntegrationTestProperties;
import org.springframework.cloud.dataflow.integration.test.db.container.DataflowCluster;
import org.springframework.cloud.dataflow.integration.test.util.AssertUtils;
import org.springframework.context.annotation.Configuration;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers
@SpringBootTest(classes={EmptyConfig.class})
@EnableConfigurationProperties(value={IntegrationTestProperties.class})
public abstract class AbstractDataflowTests {
    public static final String DATAFLOW_IMAGE_PREFIX = "springcloud/spring-cloud-dataflow-server:";
    public static final String SKIPPER_IMAGE_PREFIX = "springcloud/spring-cloud-skipper-server:";
    public static final List<DataflowCluster.ClusterContainer> DATAFLOW_CONTAINERS = Arrays.asList(DataflowCluster.ClusterContainer.from("dataflow_2_0", "springcloud/spring-cloud-dataflow-server:2.0.3.RELEASE"), DataflowCluster.ClusterContainer.from("dataflow_2_1", "springcloud/spring-cloud-dataflow-server:2.1.2.RELEASE"), DataflowCluster.ClusterContainer.from("dataflow_2_2", "springcloud/spring-cloud-dataflow-server:2.2.3.RELEASE"), DataflowCluster.ClusterContainer.from("dataflow_2_3", "springcloud/spring-cloud-dataflow-server:2.3.1.RELEASE"), DataflowCluster.ClusterContainer.from("dataflow_2_4", "springcloud/spring-cloud-dataflow-server:2.4.2.RELEASE"), DataflowCluster.ClusterContainer.from("dataflow_2_5", "springcloud/spring-cloud-dataflow-server:2.5.4.RELEASE"), DataflowCluster.ClusterContainer.from("dataflow_2_6", "springcloud/spring-cloud-dataflow-server:2.6.5"), DataflowCluster.ClusterContainer.from("dataflow_2_7", "springcloud/spring-cloud-dataflow-server:2.7.1"));
    public static final List<DataflowCluster.ClusterContainer> SKIPPER_CONTAINERS = Arrays.asList(DataflowCluster.ClusterContainer.from("skipper_2_0", "springcloud/spring-cloud-skipper-server:2.0.3.RELEASE"), DataflowCluster.ClusterContainer.from("skipper_2_1", "springcloud/spring-cloud-skipper-server:2.1.4.RELEASE"), DataflowCluster.ClusterContainer.from("skipper_2_2", "springcloud/spring-cloud-skipper-server:2.2.2.RELEASE"), DataflowCluster.ClusterContainer.from("skipper_2_3", "springcloud/spring-cloud-skipper-server:2.3.2.RELEASE"), DataflowCluster.ClusterContainer.from("skipper_2_4", "springcloud/spring-cloud-skipper-server:2.4.3.RELEASE"), DataflowCluster.ClusterContainer.from("skipper_2_5", "springcloud/spring-cloud-skipper-server:2.5.4"), DataflowCluster.ClusterContainer.from("skipper_2_6", "springcloud/spring-cloud-skipper-server:2.6.1"));
    public static final List<DataflowCluster.ClusterContainer> DATABASE_CONTAINERS = Arrays.asList(DataflowCluster.ClusterContainer.from("postgres_10", "postgres:10", "postgres"), DataflowCluster.ClusterContainer.from("mysql_5_7", "mysql:5.7", "mysql"), DataflowCluster.ClusterContainer.from("mysql_8_0", "mysql:8.0", "mysql"), DataflowCluster.ClusterContainer.from("mariadb_10_2", "mariadb:10.5", "mariadb"), DataflowCluster.ClusterContainer.from("mariadb_10_3", "mariadb:10.5", "mariadb"), DataflowCluster.ClusterContainer.from("mariadb_10_4", "mariadb:10.5", "mariadb"), DataflowCluster.ClusterContainer.from("mariadb_10_5", "mariadb:10.5", "mariadb"), DataflowCluster.ClusterContainer.from("mssql_2019_CU10_ubuntu_20_04", "mcr.microsoft.com/mssql/server:2019-CU10-ubuntu-20.04", "mssql"));
    public static final List<DataflowCluster.ClusterContainer> OAUTH_CONTAINERS = Arrays.asList(DataflowCluster.ClusterContainer.from("uaa_4_32", "projects.registry.vmware.com/scdf/uaa-test:4.32", "uaa"));
    @Autowired
    private IntegrationTestProperties testProperties;
    private GenericContainer<?> toolsContainer = null;
    protected DataflowCluster dataflowCluster;

    @AfterEach
    public void cleanCluster() {
        if (this.dataflowCluster != null) {
            this.dataflowCluster.stop();
        }
        this.dataflowCluster = null;
        if (this.toolsContainer != null) {
            this.toolsContainer.stop();
            this.toolsContainer = null;
        }
    }

    @BeforeEach
    public void setupCluster() {
        this.dataflowCluster = new DataflowCluster(this.getDatabaseContainers(), this.getOauthContainers(), this.getSkipperContainers(), this.getDataflowContainers(), this.testProperties.getDatabase().isSharedDatabase());
    }

    protected Container.ExecResult execInToolsContainer(String ... command) throws UnsupportedOperationException, IOException, InterruptedException {
        if (this.toolsContainer == null) {
            this.toolsContainer = new GenericContainer("praqma/network-multitool:latest");
            this.toolsContainer.withNetwork(this.dataflowCluster.getNetwork());
            this.toolsContainer.start();
        }
        return this.toolsContainer.execInContainer(command);
    }

    protected IntegrationTestProperties getTestProperties() {
        return this.testProperties;
    }

    protected String getDataflowLatestVersion() {
        return this.testProperties.getDatabase().getDataflowVersion();
    }

    protected String getSkipperLatestVersion() {
        return this.testProperties.getDatabase().getSkipperVersion();
    }

    protected List<DataflowCluster.ClusterContainer> getOauthContainers() {
        ArrayList<DataflowCluster.ClusterContainer> containers = new ArrayList<DataflowCluster.ClusterContainer>(OAUTH_CONTAINERS);
        return containers;
    }

    protected List<DataflowCluster.ClusterContainer> getDatabaseContainers() {
        ArrayList<DataflowCluster.ClusterContainer> containers = new ArrayList<DataflowCluster.ClusterContainer>(DATABASE_CONTAINERS);
        List additional = this.testProperties.getDatabase().getAdditionalImages().getDatatabase().entrySet().stream().map(e -> DataflowCluster.ClusterContainer.from((String)e.getKey(), ((IntegrationTestProperties.ImageProperties)e.getValue()).getImage(), ((IntegrationTestProperties.ImageProperties)e.getValue()).getTag())).collect(Collectors.toList());
        containers.addAll(additional);
        return containers;
    }

    protected List<DataflowCluster.ClusterContainer> getSkipperContainers() {
        ArrayList<DataflowCluster.ClusterContainer> containers = new ArrayList<DataflowCluster.ClusterContainer>(SKIPPER_CONTAINERS);
        containers.add(DataflowCluster.ClusterContainer.from("skipper_main", SKIPPER_IMAGE_PREFIX + this.getSkipperLatestVersion()));
        return containers;
    }

    protected List<DataflowCluster.ClusterContainer> getDataflowContainers() {
        ArrayList<DataflowCluster.ClusterContainer> containers = new ArrayList<DataflowCluster.ClusterContainer>(DATAFLOW_CONTAINERS);
        containers.add(DataflowCluster.ClusterContainer.from("dataflow_main", DATAFLOW_IMAGE_PREFIX + this.getDataflowLatestVersion()));
        return containers;
    }

    protected static void assertSkipperServerRunning(DataflowCluster dataflowCluster) {
        AssertUtils.assertSkipperServerRunning(dataflowCluster.getSkipperUrl());
    }

    protected static void assertSkipperServerNotRunning(DataflowCluster dataflowCluster) {
        AssertUtils.assertSkipperServerNotRunning(dataflowCluster.getSkipperUrl());
    }

    protected static void assertDataflowServerRunning(DataflowCluster dataflowCluster) {
        AssertUtils.assertDataflowServerRunning(dataflowCluster.getDataflowUrl());
    }

    protected static void assertDataflowServerNotRunning(DataflowCluster dataflowCluster) {
        AssertUtils.assertDataflowServerNotRunning(dataflowCluster.getDataflowUrl());
    }

    @Configuration
    protected static class EmptyConfig {
        protected EmptyConfig() {
        }
    }
}

