/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.integration.test.db.container;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.dataflow.integration.test.db.container.DataflowContainer;
import org.springframework.cloud.dataflow.integration.test.db.container.MySQLMariaDriverContainer;
import org.springframework.cloud.dataflow.integration.test.db.container.SkipperContainer;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.MSSQLServerContainer;
import org.testcontainers.containers.MariaDBContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.lifecycle.Startable;

public class DataflowCluster
implements Startable {
    private static final Logger logger = LoggerFactory.getLogger(DataflowCluster.class);
    private final int DATAFLOW_PORT = 9393;
    private final int SKIPPER_PORT = 7577;
    private final int POSTGRES_PORT = 5432;
    private final int MYSQL_PORT = 3306;
    private final int MSSQL_PORT = 1433;
    private final int MARIADB_PORT = 3306;
    private final int UAA_PORT = 8099;
    private final Map<String, ClusterContainer> dataflowImages;
    private final Map<String, ClusterContainer> skipperImages;
    private final Map<String, ClusterContainer> databaseImages;
    private final Map<String, ClusterContainer> oauthImages;
    private final boolean sharedDatabase;
    private JdbcDatabaseContainer<?> runningDatabase;
    private GenericContainer<?> runningOauth;
    private JdbcDatabaseContainer<?> runningSkipperDatabase;
    private JdbcDatabaseContainer<?> runningDataflowDatabase;
    private SkipperContainer<?> runningSkipper;
    private DataflowContainer<?> runningDataflow;
    private ClusterContainer skipperDatabaseClusterContainer;
    private ClusterContainer dataflowDatabaseClusterContainer;
    private final Network network;

    public DataflowCluster(List<ClusterContainer> databaseContainers, List<ClusterContainer> oauthContainers, List<ClusterContainer> skipperContainers, List<ClusterContainer> dataflowContainers, boolean sharedDatabase) {
        Assert.notNull(databaseContainers, (String)"databaseContainers must be set");
        Assert.notNull(oauthContainers, (String)"oauthContainers must be set");
        Assert.notNull(skipperContainers, (String)"skipperContainers must be set");
        Assert.notNull(dataflowContainers, (String)"dataflowContainers must be set");
        this.databaseImages = databaseContainers.stream().collect(Collectors.toMap(cc -> cc.id, cc -> cc));
        this.oauthImages = oauthContainers.stream().collect(Collectors.toMap(cc -> cc.id, cc -> cc));
        this.skipperImages = skipperContainers.stream().collect(Collectors.toMap(cc -> cc.id, cc -> cc));
        this.dataflowImages = dataflowContainers.stream().collect(Collectors.toMap(cc -> cc.id, cc -> cc));
        this.sharedDatabase = sharedDatabase;
        this.network = Network.newNetwork();
    }

    public void start() {
    }

    public void stop() {
        this.stopSkipper();
        this.stopDataflow();
        this.stopIdentityProvider();
        this.stopDatabase();
        this.network.close();
    }

    public Network getNetwork() {
        return this.network;
    }

    public void startSkipperDatabase(String id) {
        String skipperDatabaseAlias;
        String string = skipperDatabaseAlias = this.sharedDatabase ? "database" : "skipperdatabase";
        if (this.sharedDatabase) {
            ClusterContainer clusterContainer = this.databaseImages.get(id);
            if (this.runningDatabase == null) {
                Assert.notNull((Object)clusterContainer, (String)String.format("Unknown database %s", id));
                JdbcDatabaseContainer<?> databaseContainer = this.buildDatabaseContainer(clusterContainer, skipperDatabaseAlias);
                databaseContainer.start();
                this.runningDatabase = databaseContainer;
            }
            this.skipperDatabaseClusterContainer = clusterContainer;
        } else {
            Assert.state((this.runningSkipperDatabase == null ? 1 : 0) != 0, (String)"There's a running skipper database");
            ClusterContainer clusterContainer = this.databaseImages.get(id);
            Assert.notNull((Object)clusterContainer, (String)String.format("Unknown database %s", id));
            JdbcDatabaseContainer<?> databaseContainer = this.buildDatabaseContainer(clusterContainer, skipperDatabaseAlias);
            databaseContainer.start();
            this.runningSkipperDatabase = databaseContainer;
            this.skipperDatabaseClusterContainer = clusterContainer;
        }
    }

    public void startDataflowDatabase(String id) {
        String dataflowDatabaseAlias;
        String string = dataflowDatabaseAlias = this.sharedDatabase ? "database" : "dataflowdatabase";
        if (this.sharedDatabase) {
            ClusterContainer clusterContainer = this.databaseImages.get(id);
            if (this.runningDatabase == null) {
                Assert.notNull((Object)clusterContainer, (String)String.format("Unknown database %s", id));
                JdbcDatabaseContainer<?> databaseContainer = this.buildDatabaseContainer(clusterContainer, dataflowDatabaseAlias);
                databaseContainer.start();
                this.runningDatabase = databaseContainer;
            }
            this.dataflowDatabaseClusterContainer = clusterContainer;
        } else {
            Assert.state((this.runningDataflowDatabase == null ? 1 : 0) != 0, (String)"There's a running dataflow database");
            ClusterContainer clusterContainer = this.databaseImages.get(id);
            Assert.notNull((Object)clusterContainer, (String)String.format("Unknown database %s", id));
            JdbcDatabaseContainer<?> databaseContainer = this.buildDatabaseContainer(clusterContainer, dataflowDatabaseAlias);
            databaseContainer.start();
            this.runningDataflowDatabase = databaseContainer;
            this.dataflowDatabaseClusterContainer = clusterContainer;
        }
    }

    public void stopDatabase() {
        if (this.runningDatabase != null) {
            this.runningDatabase.stop();
        }
        if (this.runningSkipperDatabase != null) {
            this.runningSkipperDatabase.stop();
        }
        if (this.runningDataflowDatabase != null) {
            this.runningDataflowDatabase.stop();
        }
    }

    private JdbcDatabaseContainer<?> getSkipperDatabaseContainer() {
        return this.sharedDatabase ? this.runningDatabase : this.runningSkipperDatabase;
    }

    private JdbcDatabaseContainer<?> getDataflowDatabaseContainer() {
        return this.sharedDatabase ? this.runningDatabase : this.runningDataflowDatabase;
    }

    public void startIdentityProvider(String id) {
        ClusterContainer clusterContainer = this.oauthImages.get(id);
        Assert.notNull((Object)clusterContainer, (String)String.format("Unknown oauth %s", id));
        GenericContainer oauthContainer = new GenericContainer(clusterContainer.image);
        oauthContainer.withNetworkAliases(new String[]{"oauth"});
        oauthContainer.withNetwork(this.network);
        oauthContainer.withExposedPorts(new Integer[]{8099});
        oauthContainer.start();
        this.runningOauth = oauthContainer;
    }

    public void stopIdentityProvider() {
        if (this.runningOauth != null) {
            this.runningOauth.stop();
        }
    }

    private GenericContainer<?> getIdentityProviderContainer() {
        return this.runningOauth;
    }

    public void startSkipper(String id) {
        Assert.state((this.runningSkipper == null ? 1 : 0) != 0, (String)"There's a running skipper");
        ClusterContainer clusterContainer = this.skipperImages.get(id);
        Assert.notNull((Object)clusterContainer, (String)String.format("Unknown skipper %s", id));
        String skipperDatabaseAlias = this.sharedDatabase ? "database" : "skipperdatabase";
        SkipperContainer<?> skipperContainer = this.buildSkipperContainer(clusterContainer, this.getSkipperDatabaseContainer(), this.getIdentityProviderContainer(), skipperDatabaseAlias);
        skipperContainer.start();
        this.runningSkipper = skipperContainer;
    }

    public void stopSkipper() {
        if (this.runningSkipper != null) {
            this.runningSkipper.stop();
            this.runningSkipper = null;
        }
    }

    public void replaceSkipper(String id) {
        Assert.state((this.runningSkipper != null ? 1 : 0) != 0, (String)"There's no running skipper");
        ClusterContainer clusterContainer = this.skipperImages.get(id);
        Assert.notNull((Object)clusterContainer, (String)String.format("Unknown skipper %s", id));
        this.stopSkipper();
        this.startSkipper(id);
    }

    public void replaceSkipperAndDataflow(String skipperId, String dataflowId) {
        Assert.state((this.runningSkipper != null ? 1 : 0) != 0, (String)"There's no running skipper");
        Assert.state((this.runningDataflow != null ? 1 : 0) != 0, (String)"There's no running dataflow");
        ClusterContainer skipperClusterContainer = this.skipperImages.get(skipperId);
        Assert.notNull((Object)skipperClusterContainer, (String)String.format("Unknown skipper %s", skipperId));
        ClusterContainer dataflowClusterContainer = this.dataflowImages.get(dataflowId);
        Assert.notNull((Object)dataflowClusterContainer, (String)String.format("Unknown dataflow %s", dataflowId));
        this.stopSkipper();
        this.stopDataflow();
        this.startSkipper(skipperId);
        this.startDataflow(dataflowId);
    }

    public String getSkipperUrl() {
        Assert.state((this.runningSkipper != null ? 1 : 0) != 0, (String)"There's no running skipper");
        return String.format("http://%s:%s/api/about", this.runningSkipper.getHost(), this.runningSkipper.getMappedPort(7577));
    }

    public void startDataflow(String id) {
        Assert.state((this.runningDataflow == null ? 1 : 0) != 0, (String)"There's a running dataflow");
        Assert.state((this.runningSkipper != null ? 1 : 0) != 0, (String)"There's no running skipper");
        ClusterContainer clusterContainer = this.dataflowImages.get(id);
        Assert.notNull((Object)clusterContainer, (String)String.format("Unknown dataflow %s", id));
        String dataflowDatabaseAlias = this.sharedDatabase ? "database" : "dataflowdatabase";
        String skipperDatabaseAlias = this.sharedDatabase ? "database" : "skipperdatabase";
        DataflowContainer<?> dataflowContainer = this.buildDataflowContainer(clusterContainer, this.getDataflowDatabaseContainer(), this.getIdentityProviderContainer(), this.runningSkipper, dataflowDatabaseAlias, skipperDatabaseAlias);
        dataflowContainer.start();
        this.runningDataflow = dataflowContainer;
    }

    public void stopDataflow() {
        if (this.runningDataflow != null) {
            this.runningDataflow.stop();
            this.runningDataflow = null;
        }
    }

    public void replaceDataflow(String id) {
        Assert.state((this.runningDataflow != null ? 1 : 0) != 0, (String)"There's no running dataflow");
        ClusterContainer clusterContainer = this.dataflowImages.get(id);
        Assert.notNull((Object)clusterContainer, (String)String.format("Unknown dataflow %s", id));
        this.stopDataflow();
        this.startDataflow(id);
    }

    public String getDataflowUrl() {
        Assert.state((this.runningDataflow != null ? 1 : 0) != 0, (String)"There's no running dataflow");
        return String.format("http://%s:%s/about", this.runningDataflow.getHost(), this.runningDataflow.getMappedPort(9393));
    }

    private JdbcDatabaseContainer<?> buildDatabaseContainer(ClusterContainer clusterContainer, String databaseAlias) {
        if (StringUtils.hasText((String)clusterContainer.tag)) {
            if (clusterContainer.tag.startsWith("postgres")) {
                PostgreSQLContainer databaseContainer = new PostgreSQLContainer(clusterContainer.image);
                databaseContainer.withExposedPorts(new Integer[]{5432});
                databaseContainer.withDatabaseName("dataflow");
                databaseContainer.withUsername("spring");
                databaseContainer.withPassword("spring");
                databaseContainer.withNetworkAliases(new String[]{databaseAlias});
                databaseContainer.withNetwork(this.network);
                return databaseContainer;
            }
            if (clusterContainer.tag.startsWith("mysql")) {
                MySQLMariaDriverContainer databaseContainer = new MySQLMariaDriverContainer(clusterContainer.image);
                databaseContainer.withExposedPorts(new Integer[]{3306});
                databaseContainer.withDatabaseName("dataflow");
                databaseContainer.withUsername("spring");
                databaseContainer.withPassword("spring");
                databaseContainer.withNetworkAliases(new String[]{databaseAlias});
                databaseContainer.withNetwork(this.network);
                return databaseContainer;
            }
            if (clusterContainer.tag.startsWith("mariadb")) {
                MariaDBContainer databaseContainer = new MariaDBContainer(clusterContainer.image);
                databaseContainer.withExposedPorts(new Integer[]{3306});
                databaseContainer.withDatabaseName("dataflow");
                databaseContainer.withUsername("spring");
                databaseContainer.withPassword("spring");
                databaseContainer.withNetworkAliases(new String[]{databaseAlias});
                databaseContainer.withNetwork(this.network);
                return databaseContainer;
            }
            if (clusterContainer.tag.startsWith("mssql")) {
                MSSQLServerContainer databaseContainer = new MSSQLServerContainer(clusterContainer.image);
                databaseContainer.acceptLicense();
                databaseContainer.withExposedPorts(new Integer[]{1433});
                databaseContainer.withNetworkAliases(new String[]{databaseAlias});
                databaseContainer.withNetwork(this.network);
                return databaseContainer;
            }
        }
        throw new IllegalArgumentException(String.format("Can't handle database %s", clusterContainer.tag));
    }

    public String getSkipperDatabaseHostJdbcUrl() {
        JdbcDatabaseContainer<?> container = this.getSkipperDatabaseContainer();
        Assert.notNull(container, (String)"Skipper database not running");
        return container.getJdbcUrl();
    }

    public String getDataflowDatabaseHostJdbcUrl() {
        JdbcDatabaseContainer<?> container = this.getDataflowDatabaseContainer();
        Assert.notNull(container, (String)"Dataflow database not running");
        return container.getJdbcUrl();
    }

    private SkipperContainer<?> buildSkipperContainer(ClusterContainer clusterContainer, JdbcDatabaseContainer<?> databaseContainer, GenericContainer<?> oauthContainer, String skipperDatabaseAlias) {
        logger.info("Building skipper container for {}", (Object)clusterContainer);
        SkipperContainer skipperContainer = new SkipperContainer(clusterContainer.image);
        skipperContainer.withExposedPorts(new Integer[]{7577});
        if (databaseContainer != null) {
            skipperContainer.withEnv("SPRING_DATASOURCE_USERNAME", "spring");
            skipperContainer.withEnv("SPRING_DATASOURCE_PASSWORD", "spring");
            if (ObjectUtils.nullSafeEquals((Object)this.skipperDatabaseClusterContainer.tag, (Object)"postgres")) {
                skipperContainer.withEnv("SPRING_DATASOURCE_URL", String.format("jdbc:postgresql://%s:%s/dataflow", skipperDatabaseAlias, 5432));
                skipperContainer.withEnv("SPRING_DATASOURCE_DRIVER_CLASS_NAME", "org.postgresql.Driver");
            } else if (ObjectUtils.nullSafeEquals((Object)this.skipperDatabaseClusterContainer.tag, (Object)"mysql")) {
                skipperContainer.withEnv("SPRING_DATASOURCE_URL", String.format("jdbc:mariadb://%s:%s/dataflow", skipperDatabaseAlias, 3306));
                skipperContainer.withEnv("SPRING_DATASOURCE_DRIVER_CLASS_NAME", "org.mariadb.jdbc.Driver");
            } else if (ObjectUtils.nullSafeEquals((Object)this.skipperDatabaseClusterContainer.tag, (Object)"mariadb")) {
                skipperContainer.withEnv("SPRING_DATASOURCE_URL", String.format("jdbc:mariadb://%s:%s/dataflow", skipperDatabaseAlias, 3306));
                skipperContainer.withEnv("SPRING_DATASOURCE_DRIVER_CLASS_NAME", "org.mariadb.jdbc.Driver");
            } else if (ObjectUtils.nullSafeEquals((Object)this.skipperDatabaseClusterContainer.tag, (Object)"mssql")) {
                skipperContainer.withEnv("SPRING_DATASOURCE_URL", String.format("jdbc:sqlserver://%s:%s", skipperDatabaseAlias, 1433));
                skipperContainer.withEnv("SPRING_DATASOURCE_DRIVER_CLASS_NAME", "com.microsoft.sqlserver.jdbc.SQLServerDriver");
                skipperContainer.withEnv("SPRING_DATASOURCE_USERNAME", databaseContainer.getUsername());
                skipperContainer.withEnv("SPRING_DATASOURCE_PASSWORD", databaseContainer.getPassword());
            }
        }
        if (oauthContainer != null) {
            skipperContainer.withEnv("spring.cloud.skipper.security.authorization.provider-role-mappings.uaa.map-oauth-scopes", "true");
            skipperContainer.withEnv("spring.cloud.skipper.security.authorization.provider-role-mappings.uaa.role-mappings.ROLE_CREATE", "dataflow.create");
            skipperContainer.withEnv("spring.cloud.skipper.security.authorization.provider-role-mappings.uaa.role-mappings.ROLE_DEPLOY", "dataflow.deploy");
            skipperContainer.withEnv("spring.cloud.skipper.security.authorization.provider-role-mappings.uaa.role-mappings.ROLE_DESTROY", "dataflow.destroy");
            skipperContainer.withEnv("spring.cloud.skipper.security.authorization.provider-role-mappings.uaa.role-mappings.ROLE_MANAGE", "dataflow.manage");
            skipperContainer.withEnv("spring.cloud.skipper.security.authorization.provider-role-mappings.uaa.role-mappings.ROLE_MODIFY", "dataflow.modify");
            skipperContainer.withEnv("spring.cloud.skipper.security.authorization.provider-role-mappings.uaa.role-mappings.ROLE_SCHEDULE", "dataflow.schedule");
            skipperContainer.withEnv("spring.cloud.skipper.security.authorization.provider-role-mappings.uaa.role-mappings.ROLE_VIEW", "dataflow.view");
            skipperContainer.withEnv("SPRING_SECURITY_OAUTH2_CLIENT_REGISTRATION_UAA_REDIRECT_URI", "{baseUrl}/login/oauth2/code/{registrationId}");
            skipperContainer.withEnv("SPRING_SECURITY_OAUTH2_CLIENT_REGISTRATION_UAA_AUTHORIZATION_GRANT_TYPE", "authorization_code");
            skipperContainer.withEnv("SPRING_SECURITY_OAUTH2_CLIENT_REGISTRATION_UAA_CLIENT_ID", "dataflow");
            skipperContainer.withEnv("SPRING_SECURITY_OAUTH2_CLIENT_REGISTRATION_UAA_CLIENT_SECRET", "secret");
            skipperContainer.withEnv("SPRING_SECURITY_OAUTH2_CLIENT_REGISTRATION_UAA_SCOPE", "openid,dataflow.create,dataflow.deploy,dataflow.destroy,dataflow.manage,dataflow.modify,dataflow.schedule,dataflow.view");
            skipperContainer.withEnv("SPRING_SECURITY_OAUTH2_CLIENT_PROVIDER_UAA_JWK_SET_URI", "http://oauth:8099/uaa/token_keys");
            skipperContainer.withEnv("SPRING_SECURITY_OAUTH2_CLIENT_PROVIDER_UAA_TOKEN_URI", "http://oauth:8099/uaa/oauth/token");
            skipperContainer.withEnv("SPRING_SECURITY_OAUTH2_CLIENT_PROVIDER_UAA_USER_INFO_URI", "http://oauth:8099/uaa/userinfo");
            skipperContainer.withEnv("SPRING_SECURITY_OAUTH2_CLIENT_PROVIDER_UAA_USER_NAME_ATTRIBUTE", "user_name");
            skipperContainer.withEnv("SPRING_SECURITY_OAUTH2_CLIENT_PROVIDER_UAA_AUTHORIZATION_URI", "http://oauth:8099/uaa/oauth/authorize");
            skipperContainer.withEnv("SPRING_SECURITY_OAUTH2_RESOURCESERVER_OPAQUETOKEN_INTROSPECTION_URI", "http://oauth:8099/uaa/introspect");
            skipperContainer.withEnv("SPRING_SECURITY_OAUTH2_RESOURCESERVER_OPAQUETOKEN_CLIENT_ID", "dataflow");
            skipperContainer.withEnv("SPRING_SECURITY_OAUTH2_RESOURCESERVER_OPAQUETOKEN_CLIENT_SECRET", "secret");
            skipperContainer.withEnv("SPRING_SECURITY_OAUTH2_AUTHORIZATION_CHECK_TOKEN_ACCESS", "isAuthenticated()");
        }
        skipperContainer.withLogConsumer((Consumer)new Slf4jLogConsumer(logger));
        skipperContainer.withNetworkAliases(new String[]{"skipper"});
        skipperContainer.withNetwork(this.network);
        return skipperContainer;
    }

    private DataflowContainer<?> buildDataflowContainer(ClusterContainer clusterContainer, JdbcDatabaseContainer<?> databaseContainer, GenericContainer<?> oauthContainer, SkipperContainer<?> skipperContainer, String dataflowDatabaseAlias, String skipperDatabaseAlias) {
        logger.info("Building dataflow container for {}", (Object)clusterContainer);
        DataflowContainer dataflowContainer = new DataflowContainer(clusterContainer.image);
        dataflowContainer.withExposedPorts(new Integer[]{9393});
        if (databaseContainer != null) {
            dataflowContainer.withEnv("SPRING_DATASOURCE_USERNAME", "spring");
            dataflowContainer.withEnv("SPRING_DATASOURCE_PASSWORD", "spring");
            if (ObjectUtils.nullSafeEquals((Object)this.dataflowDatabaseClusterContainer.tag, (Object)"postgres")) {
                dataflowContainer.withEnv("SPRING_DATASOURCE_URL", String.format("jdbc:postgresql://%s:%s/dataflow", dataflowDatabaseAlias, 5432));
                dataflowContainer.withEnv("SPRING_DATASOURCE_DRIVER_CLASS_NAME", "org.postgresql.Driver");
            } else if (ObjectUtils.nullSafeEquals((Object)this.dataflowDatabaseClusterContainer.tag, (Object)"mysql")) {
                dataflowContainer.withEnv("SPRING_DATASOURCE_URL", String.format("jdbc:mariadb://%s:%s/dataflow", dataflowDatabaseAlias, 3306));
                dataflowContainer.withEnv("SPRING_DATASOURCE_DRIVER_CLASS_NAME", "org.mariadb.jdbc.Driver");
            } else if (ObjectUtils.nullSafeEquals((Object)this.dataflowDatabaseClusterContainer.tag, (Object)"mariadb")) {
                dataflowContainer.withEnv("SPRING_DATASOURCE_URL", String.format("jdbc:mariadb://%s:%s/dataflow", dataflowDatabaseAlias, 3306));
                dataflowContainer.withEnv("SPRING_DATASOURCE_DRIVER_CLASS_NAME", "org.mariadb.jdbc.Driver");
            } else if (ObjectUtils.nullSafeEquals((Object)this.dataflowDatabaseClusterContainer.tag, (Object)"mssql")) {
                dataflowContainer.withEnv("SPRING_DATASOURCE_URL", String.format("jdbc:sqlserver://%s:%s", dataflowDatabaseAlias, 1433));
                dataflowContainer.withEnv("SPRING_DATASOURCE_DRIVER_CLASS_NAME", "com.microsoft.sqlserver.jdbc.SQLServerDriver");
                dataflowContainer.withEnv("SPRING_DATASOURCE_USERNAME", databaseContainer.getUsername());
                dataflowContainer.withEnv("SPRING_DATASOURCE_PASSWORD", databaseContainer.getPassword());
            }
        }
        dataflowContainer.withEnv("SPRING_CLOUD_SKIPPER_CLIENT_SERVER_URI", String.format("http://%s:%s/api", "skipper", 7577));
        if (oauthContainer != null) {
            dataflowContainer.withEnv("spring.cloud.dataflow.security.authorization.provider-role-mappings.uaa.map-oauth-scopes", "true");
            dataflowContainer.withEnv("spring.cloud.dataflow.security.authorization.provider-role-mappings.uaa.role-mappings.ROLE_CREATE", "dataflow.create");
            dataflowContainer.withEnv("spring.cloud.dataflow.security.authorization.provider-role-mappings.uaa.role-mappings.ROLE_DEPLOY", "dataflow.deploy");
            dataflowContainer.withEnv("spring.cloud.dataflow.security.authorization.provider-role-mappings.uaa.role-mappings.ROLE_DESTROY", "dataflow.destroy");
            dataflowContainer.withEnv("spring.cloud.dataflow.security.authorization.provider-role-mappings.uaa.role-mappings.ROLE_MANAGE", "dataflow.manage");
            dataflowContainer.withEnv("spring.cloud.dataflow.security.authorization.provider-role-mappings.uaa.role-mappings.ROLE_MODIFY", "dataflow.modify");
            dataflowContainer.withEnv("spring.cloud.dataflow.security.authorization.provider-role-mappings.uaa.role-mappings.ROLE_SCHEDULE", "dataflow.schedule");
            dataflowContainer.withEnv("spring.cloud.dataflow.security.authorization.provider-role-mappings.uaa.role-mappings.ROLE_VIEW", "dataflow.view");
            dataflowContainer.withEnv("SPRING_SECURITY_OAUTH2_CLIENT_REGISTRATION_UAA_REDIRECT_URI", "{baseUrl}/login/oauth2/code/{registrationId}");
            dataflowContainer.withEnv("SPRING_SECURITY_OAUTH2_CLIENT_REGISTRATION_UAA_AUTHORIZATION_GRANT_TYPE", "authorization_code");
            dataflowContainer.withEnv("SPRING_SECURITY_OAUTH2_CLIENT_REGISTRATION_UAA_CLIENT_ID", "dataflow");
            dataflowContainer.withEnv("SPRING_SECURITY_OAUTH2_CLIENT_REGISTRATION_UAA_CLIENT_SECRET", "secret");
            dataflowContainer.withEnv("SPRING_SECURITY_OAUTH2_CLIENT_REGISTRATION_UAA_SCOPE", "openid,dataflow.create,dataflow.deploy,dataflow.destroy,dataflow.manage,dataflow.modify,dataflow.schedule,dataflow.view");
            dataflowContainer.withEnv("SPRING_SECURITY_OAUTH2_CLIENT_PROVIDER_UAA_JWK_SET_URI", "http://oauth:8099/uaa/token_keys");
            dataflowContainer.withEnv("SPRING_SECURITY_OAUTH2_CLIENT_PROVIDER_UAA_TOKEN_URI", "http://oauth:8099/uaa/oauth/token");
            dataflowContainer.withEnv("SPRING_SECURITY_OAUTH2_CLIENT_PROVIDER_UAA_USER_INFO_URI", "http://oauth:8099/uaa/userinfo");
            dataflowContainer.withEnv("SPRING_SECURITY_OAUTH2_CLIENT_PROVIDER_UAA_USER_NAME_ATTRIBUTE", "user_name");
            dataflowContainer.withEnv("SPRING_SECURITY_OAUTH2_CLIENT_PROVIDER_UAA_AUTHORIZATION_URI", "http://oauth:8099/uaa/oauth/authorize");
            dataflowContainer.withEnv("SPRING_SECURITY_OAUTH2_RESOURCESERVER_OPAQUETOKEN_INTROSPECTION_URI", "http://oauth:8099/uaa/introspect");
            dataflowContainer.withEnv("SPRING_SECURITY_OAUTH2_RESOURCESERVER_OPAQUETOKEN_CLIENT_ID", "dataflow");
            dataflowContainer.withEnv("SPRING_SECURITY_OAUTH2_RESOURCESERVER_OPAQUETOKEN_CLIENT_SECRET", "secret");
            dataflowContainer.withEnv("SPRING_SECURITY_OAUTH2_AUTHORIZATION_CHECK_TOKEN_ACCESS", "isAuthenticated()");
        }
        dataflowContainer.withLogConsumer((Consumer)new Slf4jLogConsumer(logger));
        dataflowContainer.withNetworkAliases(new String[]{"dataflow"});
        dataflowContainer.withNetwork(this.network);
        return dataflowContainer;
    }

    public static class ClusterContainer {
        String id;
        String image;
        String tag;

        ClusterContainer(String id, String image, String tag) {
            this.id = id;
            this.image = image;
            this.tag = tag;
        }

        public static ClusterContainer from(String id, String image) {
            return ClusterContainer.from(id, image, null);
        }

        public static ClusterContainer from(String id, String image, String tag) {
            return new ClusterContainer(id, image, tag);
        }

        public String toString() {
            return "ClusterContainer [id=" + this.id + ", image=" + this.image + ", tag=" + this.tag + "]";
        }
    }
}

