/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.integration.test.util;

import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.RestTemplate;

public abstract class AssertUtils {
    private static final Logger log = LoggerFactory.getLogger(AssertUtils.class);

    public static void assertDataflowServerNotRunning(String url) {
        Assertions.assertThatThrownBy(() -> AssertUtils.assertServerResponse("Spring Cloud Data Flow", url, 1L, TimeUnit.SECONDS, 60L, TimeUnit.SECONDS));
    }

    public static void assertDataflowServerRunning(String url) {
        AssertUtils.assertServerResponse("Spring Cloud Data Flow", url, 1L, TimeUnit.SECONDS, 60L, TimeUnit.SECONDS);
    }

    public static void assertSkipperServerNotRunning(String url) {
        Assertions.assertThatThrownBy(() -> AssertUtils.assertServerResponse("Spring Cloud Skipper Server", url, 1L, TimeUnit.SECONDS, 60L, TimeUnit.SECONDS));
    }

    public static void assertSkipperServerRunning(String url) {
        AssertUtils.assertServerResponse("Spring Cloud Skipper Server", url, 1L, TimeUnit.SECONDS, 60L, TimeUnit.SECONDS);
    }

    public static void assertServerResponse(String responseContains, String url, long pollInterval, TimeUnit pollTimeUnit, long awaitInterval, TimeUnit awaitTimeUnit) {
        RestTemplate template = new RestTemplate();
        Awaitility.with().pollInterval(pollInterval, pollTimeUnit).and().await().ignoreExceptions().atMost(awaitInterval, awaitTimeUnit).until(() -> {
            log.debug("Checking url {}", (Object)url);
            String response = (String)template.getForObject(url, String.class, new Object[0]);
            log.debug("Response is {}", (Object)response);
            boolean ok = response.contains(responseContains);
            log.info("Check {} for url {}", (Object)ok, (Object)url);
            return ok;
        });
    }
}

