/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.server.single;

import io.pivotal.scheduler.SchedulerClient;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.client.v2.Metadata;
import org.cloudfoundry.client.v2.info.GetInfoResponse;
import org.cloudfoundry.client.v2.organizations.ListOrganizationsRequest;
import org.cloudfoundry.client.v2.organizations.ListOrganizationsResponse;
import org.cloudfoundry.client.v2.organizations.OrganizationResource;
import org.cloudfoundry.client.v2.organizations.Organizations;
import org.cloudfoundry.client.v2.spaces.ListSpacesRequest;
import org.cloudfoundry.client.v2.spaces.ListSpacesResponse;
import org.cloudfoundry.client.v2.spaces.SpaceResource;
import org.cloudfoundry.client.v2.spaces.Spaces;
import org.cloudfoundry.reactor.TokenProvider;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.dataflow.core.TaskPlatform;
import org.springframework.cloud.dataflow.server.config.cloudfoundry.CloudFoundryPlatformClientProvider;
import org.springframework.cloud.dataflow.server.config.cloudfoundry.CloudFoundryPlatformTokenProvider;
import org.springframework.cloud.dataflow.server.config.cloudfoundry.CloudFoundrySchedulerClientProvider;
import org.springframework.cloud.dataflow.server.service.SchedulerService;
import org.springframework.cloud.dataflow.server.single.DataFlowServerApplication;
import org.springframework.cloud.deployer.spi.scheduler.cloudfoundry.CloudFoundrySchedulerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringRunner;
import reactor.core.publisher.Mono;

@ActiveProfiles(value={"cloud"})
@SpringBootTest(classes={DataFlowServerApplication.class, TestConfig.class}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT, properties={"spring.cloud.dataflow.features.schedules-enabled=true", "VCAP_SERVICES=foo", "spring.cloud.dataflow.task.platform.cloudfoundry.accounts[cf].connection.url=https://localhost", "spring.cloud.dataflow.task.platform.cloudfoundry.accounts[cf].connection.org=org", "spring.cloud.dataflow.task.platform.cloudfoundry.accounts[cf].connection.space=space", "spring.cloud.scheduler.cloudfoundry.scheduler-url=https://localhost"})
@RunWith(value=SpringRunner.class)
public class CloudFoundrySchedulerTests {
    @Autowired
    List<TaskPlatform> taskPlatforms;
    @Autowired
    SchedulerService schedulerService;

    @Test
    public void schedulerServiceCreated() {
        for (TaskPlatform taskPlatform : this.taskPlatforms) {
            if (!taskPlatform.isPrimary()) continue;
            Assertions.assertThat((String)taskPlatform.getName()).isEqualTo("Cloud Foundry");
        }
        Assertions.assertThat((Object)this.schedulerService).isNotNull();
    }

    @Configuration
    static class TestConfig {
        private CloudFoundryClient cloudFoundryClient = (CloudFoundryClient)Mockito.mock(CloudFoundryClient.class);
        private TokenProvider tokenProvider = (TokenProvider)Mockito.mock(TokenProvider.class);

        TestConfig() {
        }

        @Bean
        @Primary
        public CloudFoundryPlatformClientProvider mockCloudFoundryClientProvider() {
            Mockito.when((Object)this.cloudFoundryClient.info()).thenReturn(getInfoRequest -> Mono.just((Object)GetInfoResponse.builder().apiVersion("0.0.0").build()));
            Mockito.when((Object)this.cloudFoundryClient.organizations()).thenReturn(Mockito.mock(Organizations.class));
            Mockito.when((Object)this.cloudFoundryClient.spaces()).thenReturn(Mockito.mock(Spaces.class));
            Mockito.when((Object)this.cloudFoundryClient.organizations().list((ListOrganizationsRequest)ArgumentMatchers.any())).thenReturn(this.listOrganizationsResponse());
            Mockito.when((Object)this.cloudFoundryClient.spaces().list((ListSpacesRequest)ArgumentMatchers.any())).thenReturn(this.listSpacesResponse());
            CloudFoundryPlatformClientProvider cloudFoundryClientProvider = (CloudFoundryPlatformClientProvider)Mockito.mock(CloudFoundryPlatformClientProvider.class);
            Mockito.when((Object)cloudFoundryClientProvider.cloudFoundryClient(ArgumentMatchers.anyString())).thenAnswer(invocation -> {
                System.out.println("Returning " + this.cloudFoundryClient);
                return this.cloudFoundryClient;
            });
            return cloudFoundryClientProvider;
        }

        private Mono<ListOrganizationsResponse> listOrganizationsResponse() {
            ListOrganizationsResponse response = ListOrganizationsResponse.builder().addAllResources(Collections.singletonList(OrganizationResource.builder().metadata(Metadata.builder().id("123").build()).build())).build();
            return Mono.just((Object)response);
        }

        private Mono<ListSpacesResponse> listSpacesResponse() {
            ListSpacesResponse response = ListSpacesResponse.builder().addAllResources(Collections.singletonList(SpaceResource.builder().metadata(Metadata.builder().id("123").build()).build())).build();
            return Mono.just((Object)response);
        }

        @Bean
        @Primary
        public CloudFoundrySchedulerClientProvider mockCloudFoundryShedulerClientProvider() {
            CloudFoundrySchedulerClientProvider cloudFoundrySchedulerClientProvider = (CloudFoundrySchedulerClientProvider)Mockito.mock(CloudFoundrySchedulerClientProvider.class);
            Mockito.when((Object)cloudFoundrySchedulerClientProvider.cloudFoundrySchedulerClient(ArgumentMatchers.anyString())).thenReturn(Mockito.mock(SchedulerClient.class));
            Mockito.when((Object)cloudFoundrySchedulerClientProvider.schedulerProperties()).thenReturn((Object)new CloudFoundrySchedulerProperties());
            return cloudFoundrySchedulerClientProvider;
        }

        @Bean
        @Primary
        public CloudFoundryPlatformTokenProvider mockPlatformTokenProvider() {
            CloudFoundryPlatformTokenProvider platformTokenProvider = (CloudFoundryPlatformTokenProvider)Mockito.mock(CloudFoundryPlatformTokenProvider.class);
            Mockito.when((Object)platformTokenProvider.tokenProvider(ArgumentMatchers.anyString())).thenReturn((Object)this.tokenProvider);
            return platformTokenProvider;
        }
    }
}

