/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.server.single;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.dataflow.core.TaskPlatform;
import org.springframework.cloud.dataflow.server.service.SchedulerService;
import org.springframework.cloud.dataflow.server.single.DataFlowServerApplication;
import org.springframework.test.context.junit4.SpringRunner;

@SpringBootTest(classes={DataFlowServerApplication.class}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT, properties={"spring.cloud.dataflow.features.schedules-enabled=true"})
@RunWith(value=SpringRunner.class)
public class DefaultSchedulerTests {
    @Autowired
    List<TaskPlatform> taskPlatforms;
    @Autowired
    SchedulerService schedulerService;

    @Test
    public void shouldBeLocalPrimaryPlatformIfSchedulesEnabled() {
        for (TaskPlatform taskPlatform : this.taskPlatforms) {
            if (!taskPlatform.isPrimary()) continue;
            Assertions.assertThat((String)taskPlatform.getName()).isEqualTo("Local");
        }
        Assertions.assertThat((Object)this.schedulerService).isNotNull();
    }
}

