/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.integration.test;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.dataflow.integration.test.IntegrationTestProperties;
import org.springframework.cloud.dataflow.integration.test.util.RuntimeApplicationHelper;
import org.springframework.cloud.dataflow.rest.client.DataFlowTemplate;
import org.springframework.cloud.dataflow.rest.client.config.DataFlowClientAutoConfiguration;
import org.springframework.cloud.dataflow.rest.client.config.DataFlowClientProperties;
import org.springframework.cloud.dataflow.rest.util.HttpClientConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.StreamUtils;
import org.springframework.web.client.RestTemplate;

@Configuration
@Import(value={DataFlowClientAutoConfiguration.class})
@EnableConfigurationProperties(value={IntegrationTestProperties.class})
public class DataFlowOperationsITConfiguration {
    @Bean
    public RestTemplate restTemplate(DataFlowClientProperties dataFlowClientProperties) throws URISyntaxException {
        RestTemplate restTemplate = new RestTemplate(HttpClientConfigurer.create((URI)new URI(dataFlowClientProperties.getServerUri())).skipTlsCertificateVerification(dataFlowClientProperties.isSkipSslValidation()).buildClientHttpRequestFactory());
        restTemplate.setInterceptors(Arrays.asList(new AcceptCharsetInterceptor(), new LoggingInterceptor()));
        return restTemplate;
    }

    @Bean
    public RuntimeApplicationHelper runtimeApplicationHelper(DataFlowTemplate dataFlowOperations, IntegrationTestProperties testProperties) {
        return new RuntimeApplicationHelper(dataFlowOperations, testProperties.getPlatform().getConnection().getPlatformName(), testProperties.getPlatform().getConnection().isApplicationOverHttps());
    }

    static class LoggingInterceptor
    implements ClientHttpRequestInterceptor {
        private static final Logger log = LoggerFactory.getLogger(LoggingInterceptor.class);

        LoggingInterceptor() {
        }

        public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
            this.logRequest(request, body);
            ClientHttpResponse response = execution.execute(request, body);
            this.logResponse(response);
            return response;
        }

        private void logRequest(HttpRequest request, byte[] body) {
            if (log.isDebugEnabled()) {
                log.debug("=========================request begin================================================");
                log.debug("URI         : {}", (Object)request.getURI());
                log.debug("Method      : {}", (Object)request.getMethod());
                log.debug("Headers     : {}", (Object)request.getHeaders());
                log.debug("Request body: {}", (Object)new String(body, StandardCharsets.UTF_8));
                log.debug("==========================request end================================================");
            }
        }

        private void logResponse(ClientHttpResponse response) throws IOException {
            if (log.isDebugEnabled()) {
                log.debug("============================response begin==========================================");
                log.debug("Status code  : {}", (Object)response.getStatusCode());
                log.debug("Status text  : {}", (Object)response.getStatusText());
                log.debug("Headers      : {}", (Object)response.getHeaders());
                log.debug("Response body: {}", (Object)StreamUtils.copyToString((InputStream)response.getBody(), (Charset)Charset.defaultCharset()));
                log.debug("=======================response end=================================================");
            }
        }
    }

    static class AcceptCharsetInterceptor
    implements ClientHttpRequestInterceptor {
        AcceptCharsetInterceptor() {
        }

        public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
            request.getHeaders().setAcceptCharset(Collections.singletonList(StandardCharsets.UTF_8));
            return execution.execute(request, body);
        }
    }
}

