/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.integration.test.db;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.dataflow.integration.test.db.AbstractDatabaseTests;
import org.springframework.cloud.dataflow.integration.test.tags.Database;
import org.springframework.cloud.dataflow.integration.test.tags.DatabaseFailure;
import org.springframework.cloud.dataflow.integration.test.tags.DataflowMain;
import org.testcontainers.containers.ContainerLaunchException;

@Database
public abstract class AbstractPostgresDatabaseTests
extends AbstractDatabaseTests {
    private final Logger log = LoggerFactory.getLogger(AbstractPostgresDatabaseTests.class);

    @Test
    @DataflowMain
    @DatabaseFailure
    public void testMigrationError() {
        this.log.info("Running testMigrationError()");
        this.dataflowCluster.startSkipperDatabase(this.getDatabaseTag());
        this.dataflowCluster.startDataflowDatabase(this.getDatabaseTag());
        this.runExecute(this.getTestMigrationErrorBreakClause());
        this.dataflowCluster.startSkipper("skipper_main");
        AbstractPostgresDatabaseTests.assertSkipperServerRunning(this.dataflowCluster);
        Assertions.assertThatThrownBy(() -> this.dataflowCluster.startDataflow("dataflow_main")).isInstanceOf(ContainerLaunchException.class);
        Integer count = this.runCountQuery("select count(*) from flyway_schema_history_dataflow");
        Assertions.assertThat((Integer)count).isEqualTo(-1);
        this.runExecute(this.getTestMigrationErrorFixClause());
        this.dataflowCluster.startDataflow("dataflow_main");
        AbstractPostgresDatabaseTests.assertDataflowServerRunning(this.dataflowCluster);
        count = this.runCountQuery("select count(*) from flyway_schema_history_dataflow");
        Assertions.assertThat((Integer)count).isGreaterThan(1);
    }

    protected abstract String getTestMigrationErrorBreakClause();

    protected abstract String getTestMigrationErrorFixClause();
}

