/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.integration.test.oauth;

import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.dataflow.integration.test.db.AbstractDataflowTests;
import org.springframework.cloud.dataflow.integration.test.tags.Oauth;
import org.springframework.test.context.ActiveProfiles;
import org.testcontainers.containers.Container;

@Oauth
@ActiveProfiles(value={"oauth"})
public class DataflowOAuthIT
extends AbstractDataflowTests {
    private final Logger log = LoggerFactory.getLogger(DataflowOAuthIT.class);

    @Test
    public void testSecuredSetup() throws Exception {
        this.log.info("Running testSecuredSetup()");
        this.dataflowCluster.startIdentityProvider("uaa_4_32");
        this.dataflowCluster.startSkipper("skipper_main");
        this.dataflowCluster.startDataflow("dataflow_main");
        Awaitility.with().pollInterval(5L, TimeUnit.SECONDS).and().await().ignoreExceptions().atMost(120L, TimeUnit.SECONDS).until(() -> {
            this.log.debug("Checking auth using curl");
            Container.ExecResult cmdResult = this.execInToolsContainer("curl", "-u", "janne:janne", "http://dataflow:9393/about");
            String response = cmdResult.getStdout();
            this.log.debug("Response is {}", (Object)response);
            boolean ok = response.contains("\"authenticated\":true") && response.contains("\"username\":\"janne\"");
            this.log.info("Check for oauth {}", (Object)ok);
            return ok;
        });
    }
}

