/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.server.single;

import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.client.v2.Metadata;
import org.cloudfoundry.client.v2.info.GetInfoResponse;
import org.cloudfoundry.client.v2.organizations.ListOrganizationsRequest;
import org.cloudfoundry.client.v2.organizations.ListOrganizationsResponse;
import org.cloudfoundry.client.v2.organizations.OrganizationResource;
import org.cloudfoundry.client.v2.organizations.Organizations;
import org.cloudfoundry.client.v2.spaces.ListSpacesRequest;
import org.cloudfoundry.client.v2.spaces.ListSpacesResponse;
import org.cloudfoundry.client.v2.spaces.SpaceResource;
import org.cloudfoundry.client.v2.spaces.Spaces;
import org.cloudfoundry.reactor.TokenProvider;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.dataflow.core.Launcher;
import org.springframework.cloud.dataflow.core.TaskPlatform;
import org.springframework.cloud.dataflow.server.config.cloudfoundry.CloudFoundryPlatformClientProvider;
import org.springframework.cloud.dataflow.server.config.cloudfoundry.CloudFoundryPlatformTokenProvider;
import org.springframework.cloud.dataflow.server.single.DataFlowServerApplication;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryTaskLauncher;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesTaskLauncher;
import org.springframework.cloud.deployer.spi.local.LocalTaskLauncher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.test.context.junit4.SpringRunner;
import reactor.core.publisher.Mono;

@SpringBootTest(classes={DataFlowServerApplication.class, TestConfig.class}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT, properties={"spring.cloud.dataflow.features.schedules-enabled=true", "spring.cloud.dataflow.task.platform.kubernetes.accounts[k8s].namespace=default", "spring.cloud.dataflow.task.platform.cloudfoundry.accounts[cf].connection.url=https://localhost", "spring.cloud.dataflow.task.platform.cloudfoundry.accounts[cf].connection.org=org", "spring.cloud.dataflow.task.platform.cloudfoundry.accounts[cf].connection.space=space", "spring.cloud.dataflow.task.platform.cloudfoundry.accounts[cf].deployment.scheduler-url=https://localhost"})
@RunWith(value=SpringRunner.class)
public class MultiplePlatformTypeTests {
    @Autowired
    List<TaskPlatform> taskPlatforms;

    @Test
    public void localTaskPlatform() {
        Assertions.assertThat(this.taskPlatforms).hasSize(3);
        TaskPlatform localDefault = this.taskPlatforms.stream().filter(taskPlatform -> taskPlatform.getName().equals("Local")).findFirst().get();
        Assertions.assertThat((boolean)localDefault.isPrimary());
        Assertions.assertThat((Object)localDefault).isNotNull();
        Assertions.assertThat((List)localDefault.getLaunchers()).hasSize(1);
        Assertions.assertThat((String)((Launcher)localDefault.getLaunchers().get(0)).getType()).isEqualTo(localDefault.getName());
        Assertions.assertThat((String)((Launcher)localDefault.getLaunchers().get(0)).getName()).isEqualTo("default");
        Assertions.assertThat((Object)((Launcher)localDefault.getLaunchers().get(0)).getTaskLauncher()).isInstanceOf(LocalTaskLauncher.class);
    }

    @Test
    public void cloudFoundryTaskPlatform() {
        TaskPlatform cloudFoundry = this.taskPlatforms.stream().filter(taskPlatform -> taskPlatform.getName().equals("Cloud Foundry")).findFirst().get();
        Assertions.assertThat((Object)cloudFoundry).isNotNull();
        Assertions.assertThat((List)cloudFoundry.getLaunchers()).hasSize(1);
        Assertions.assertThat((String)((Launcher)cloudFoundry.getLaunchers().get(0)).getType()).isEqualTo(cloudFoundry.getName());
        Assertions.assertThat((String)((Launcher)cloudFoundry.getLaunchers().get(0)).getName()).isEqualTo("cf");
        Assertions.assertThat((Object)((Launcher)cloudFoundry.getLaunchers().get(0)).getTaskLauncher()).isInstanceOf(CloudFoundryTaskLauncher.class);
    }

    @Test
    public void kubernetesTaskPlatform() {
        TaskPlatform kubernetes = this.taskPlatforms.stream().filter(taskPlatform -> taskPlatform.getName().equals("Kubernetes")).findFirst().get();
        Assertions.assertThat((Object)kubernetes).isNotNull();
        Assertions.assertThat((List)kubernetes.getLaunchers()).hasSize(1);
        Assertions.assertThat((String)((Launcher)kubernetes.getLaunchers().get(0)).getType()).isEqualTo(kubernetes.getName());
        Assertions.assertThat((String)((Launcher)kubernetes.getLaunchers().get(0)).getName()).isEqualTo("k8s");
        Assertions.assertThat((Object)((Launcher)kubernetes.getLaunchers().get(0)).getTaskLauncher()).isInstanceOf(KubernetesTaskLauncher.class);
    }

    @Configuration
    static class TestConfig {
        private CloudFoundryClient cloudFoundryClient = (CloudFoundryClient)Mockito.mock(CloudFoundryClient.class);
        private TokenProvider tokenProvider = (TokenProvider)Mockito.mock(TokenProvider.class);

        TestConfig() {
        }

        @Bean
        @Primary
        public CloudFoundryPlatformClientProvider mockCloudFoundryClientProvider() {
            Mockito.when((Object)this.cloudFoundryClient.info()).thenReturn(getInfoRequest -> Mono.just((Object)GetInfoResponse.builder().apiVersion("0.0.0").build()));
            Mockito.when((Object)this.cloudFoundryClient.organizations()).thenReturn(Mockito.mock(Organizations.class));
            Mockito.when((Object)this.cloudFoundryClient.spaces()).thenReturn(Mockito.mock(Spaces.class));
            Mockito.when((Object)this.cloudFoundryClient.organizations().list((ListOrganizationsRequest)ArgumentMatchers.any())).thenReturn(this.listOrganizationsResponse());
            Mockito.when((Object)this.cloudFoundryClient.spaces().list((ListSpacesRequest)ArgumentMatchers.any())).thenReturn(this.listSpacesResponse());
            CloudFoundryPlatformClientProvider cloudFoundryClientProvider = (CloudFoundryPlatformClientProvider)Mockito.mock(CloudFoundryPlatformClientProvider.class);
            Mockito.when((Object)cloudFoundryClientProvider.cloudFoundryClient(ArgumentMatchers.anyString())).thenAnswer(invocation -> {
                System.out.println("Returning " + this.cloudFoundryClient);
                return this.cloudFoundryClient;
            });
            return cloudFoundryClientProvider;
        }

        private Mono<ListOrganizationsResponse> listOrganizationsResponse() {
            ListOrganizationsResponse response = ListOrganizationsResponse.builder().addAllResources(Collections.singletonList(OrganizationResource.builder().metadata(Metadata.builder().id("123").build()).build())).build();
            return Mono.just((Object)response);
        }

        private Mono<ListSpacesResponse> listSpacesResponse() {
            ListSpacesResponse response = ListSpacesResponse.builder().addAllResources(Collections.singletonList(SpaceResource.builder().metadata(Metadata.builder().id("123").build()).build())).build();
            return Mono.just((Object)response);
        }

        @Bean
        @Primary
        public CloudFoundryPlatformTokenProvider mockPlatformTokenProvider() {
            CloudFoundryPlatformTokenProvider platformTokenProvider = (CloudFoundryPlatformTokenProvider)Mockito.mock(CloudFoundryPlatformTokenProvider.class);
            Mockito.when((Object)platformTokenProvider.tokenProvider(ArgumentMatchers.anyString())).thenReturn((Object)this.tokenProvider);
            return platformTokenProvider;
        }
    }
}

