/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.core.dsl.tck;

import java.util.List;
import java.util.Properties;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.dataflow.core.dsl.AppNode;
import org.springframework.cloud.dataflow.core.dsl.ArgumentNode;
import org.springframework.cloud.dataflow.core.dsl.DSLMessage;
import org.springframework.cloud.dataflow.core.dsl.ParseException;
import org.springframework.cloud.dataflow.core.dsl.SourceDestinationNode;
import org.springframework.cloud.dataflow.core.dsl.StreamNode;

public abstract class AbstractStreamDslTests {
    protected abstract StreamNode parse(String var1);

    protected abstract StreamNode parse(String var1, String var2);

    @Test
    public void oneApp() {
        StreamNode sn = this.parse("foo");
        Assertions.assertThat((List)sn.getAppNodes()).hasSize(1);
        AppNode appNode = sn.getApp("foo");
        Assertions.assertThat((String)appNode.getName()).isEqualTo("foo");
        Assertions.assertThat((Object[])appNode.getArguments()).hasSize(0);
        Assertions.assertThat((int)appNode.getStartPos()).isEqualTo(0);
        Assertions.assertThat((int)appNode.getEndPos()).isEqualTo(3);
    }

    @Test
    public void hyphenatedAppName() {
        StreamNode sn = this.parse("gemfire-cq");
        sn = this.parse("gemfire-cq");
        Assertions.assertThat((String)sn.stringify(true)).isEqualTo("[(AppNode:gemfire-cq:0>10)]");
    }

    @Test
    public void listApps() {
        this.checkForParseError(":aaa > fff||bbb", DSLMessage.DONT_USE_DOUBLEPIPE_WITH_CHANNELS, 10, new Object[0]);
        this.checkForParseError("fff||bbb > :zzz", DSLMessage.DONT_USE_DOUBLEPIPE_WITH_CHANNELS, 3, new Object[0]);
        this.checkForParseError("aaa | bbb|| ccc", DSLMessage.DONT_MIX_PIPE_AND_DOUBLEPIPE, 9, new Object[0]);
        this.checkForParseError("aaa || bbb| ccc", DSLMessage.DONT_MIX_PIPE_AND_DOUBLEPIPE, 10, new Object[0]);
        StreamNode sn = this.parse("aaa | filter --expression=#jsonPath(payload,'$.lang')=='en'");
        Assertions.assertThat((String)"--expression=#jsonPath(payload,'$.lang')=='en'").isEqualTo(((AppNode)sn.getAppNodes().get(1)).getArguments()[0].toString());
    }

    @Test
    public void doublePipeEndingArgs() {
        this.checkForParseError("aaa --bbb=ccc||", DSLMessage.OOD, 15, new Object[0]);
        StreamNode sn = this.parse("aaa --bbb=ccc,");
        Assertions.assertThat((String)"[(AppNode:aaa --bbb=ccc,)]").isEqualTo(sn.stringify(false));
        this.checkForParseError("aaa --bbb='ccc'||", DSLMessage.OOD, 17, new Object[0]);
        sn = this.parse("aaa --bbb='ccc'|| bbb");
        Assertions.assertThat((String)"[(AppNode:aaa --bbb=ccc:0>15)(AppNode:bbb:18>21)]").isEqualTo(sn.stringify(true));
        ArgumentNode argumentNode = ((AppNode)sn.getAppNodes().get(0)).getArguments()[0];
        Assertions.assertThat((String)"ccc").isEqualTo(argumentNode.getValue());
    }

    @Test
    public void shortArgValues_2499() {
        this.checkForParseError("aaa --bbb= --ccc=ddd", DSLMessage.EXPECTED_ARGUMENT_VALUE, 11, new Object[0]);
        this.checkForParseError("aaa --bbb=| --ccc=ddd", DSLMessage.EXPECTED_ARGUMENT_VALUE, 10, new Object[0]);
        this.checkForParseError("aaa --bbb=; --ccc=ddd", DSLMessage.EXPECTED_ARGUMENT_VALUE, 10, new Object[0]);
        this.checkForParseError("aaa --bbb=> --ccc=ddd", DSLMessage.EXPECTED_ARGUMENT_VALUE, 10, new Object[0]);
        this.checkForParseError("aaa --bbb=\t --ccc=ddd", DSLMessage.EXPECTED_ARGUMENT_VALUE, 12, new Object[0]);
        this.checkForParseError("aaa --bbb=\t --ccc=ddd", DSLMessage.EXPECTED_ARGUMENT_VALUE, 12, new Object[0]);
        this.checkForParseError("aaa --bbb=\n --ccc=ddd", DSLMessage.EXPECTED_ARGUMENT_VALUE, 10, new Object[0]);
    }

    @Test
    public void streamNaming() {
        StreamNode sn = this.parse("mystream = foo");
        Assertions.assertThat((String)"[mystream = (AppNode:foo:11>14)]").isEqualTo(sn.stringify(true));
        Assertions.assertThat((String)"mystream").isEqualTo(sn.getName());
    }

    @Test
    public void testStreamNameAsAppName() {
        String streamName = "bar";
        String stream = "bar = foo | bar";
        StreamNode sn = this.parse(stream);
        Assertions.assertThat((String)streamName).isEqualTo(sn.getName());
    }

    @Test
    public void twoApps() {
        StreamNode ast = this.parse("foo | bar");
        Assertions.assertThat((String)"[(AppNode:foo:0>3)(AppNode:bar:6>9)]").isEqualTo(ast.stringify(true));
    }

    @Test
    public void appLabels() {
        StreamNode ast = this.parse("label: http");
        Assertions.assertThat((String)"[((Label:label:0>5) AppNode:http:0>11)]").isEqualTo(ast.stringify(true));
    }

    @Test
    public void appLabels3() {
        StreamNode ast = this.parse("food = http | label3: foo");
        Assertions.assertThat((String)"[food = (AppNode:http:7>11)((Label:label3:14>20) AppNode:foo:14>25)]").isEqualTo(ast.stringify(true));
        StreamNode sn = this.parse("http | foo: bar | file");
        Assertions.assertThat((String)"[(AppNode:http)((Label:foo) AppNode:bar)(AppNode:file)]").isEqualTo(sn.stringify());
        this.checkForParseError("http | foo: goggle: bar | file", DSLMessage.NO_DOUBLE_LABELS, 12, new Object[0]);
        this.checkForParseError("http | foo :bar | file", DSLMessage.UNEXPECTED_DATA_AFTER_STREAMDEF, 11, new Object[0]);
    }

    @Test
    public void oneAppWithParam() {
        StreamNode ast = this.parse("foo --name=value");
        Assertions.assertThat((String)"[(AppNode:foo --name=value:0>16)]").isEqualTo(ast.stringify(true));
    }

    @Test
    public void oneAppWithTwoParams() {
        StreamNode sn = this.parse("foo --name=value --x=y");
        List appNodes = sn.getAppNodes();
        Assertions.assertThat((int)1).isEqualTo(appNodes.size());
        AppNode mn = (AppNode)appNodes.get(0);
        Assertions.assertThat((String)"foo").isEqualTo(mn.getName());
        Object[] args = mn.getArguments();
        Assertions.assertThat((Object[])args).isNotNull();
        Assertions.assertThat((int)2).isEqualTo(args.length);
        Assertions.assertThat((String)"name").isEqualTo(args[0].getName());
        Assertions.assertThat((String)"value").isEqualTo(args[0].getValue());
        Assertions.assertThat((String)"x").isEqualTo(args[1].getName());
        Assertions.assertThat((String)"y").isEqualTo(args[1].getValue());
        Assertions.assertThat((String)"[(AppNode:foo --name=value --x=y:0>22)]").isEqualTo(sn.stringify(true));
    }

    @Test
    public void testParameters() {
        String app = "gemfire-cq --query='Select * from /Stocks where symbol=''VMW''' --regionName=foo --foo=bar";
        StreamNode ast = this.parse(app);
        AppNode gemfireApp = ast.getApp("gemfire-cq");
        Properties parameters = gemfireApp.getArgumentsAsProperties();
        Assertions.assertThat((int)3).isEqualTo(parameters.size());
        Assertions.assertThat((String)"Select * from /Stocks where symbol='VMW'").isEqualTo(parameters.get("query"));
        Assertions.assertThat((String)"foo").isEqualTo(parameters.get("regionName"));
        Assertions.assertThat((String)"bar").isEqualTo(parameters.get("foo"));
        app = "test";
        parameters = this.parse(app).getApp("test").getArgumentsAsProperties();
        Assertions.assertThat((int)0).isEqualTo(parameters.size());
        app = "foo --x=1 --y=two ";
        parameters = this.parse(app).getApp("foo").getArgumentsAsProperties();
        Assertions.assertThat((int)2).isEqualTo(parameters.size());
        Assertions.assertThat((String)"1").isEqualTo(parameters.get("x"));
        Assertions.assertThat((String)"two").isEqualTo(parameters.get("y"));
        app = "foo --x=1a2b --y=two ";
        parameters = this.parse(app).getApp("foo").getArgumentsAsProperties();
        Assertions.assertThat((int)2).isEqualTo(parameters.size());
        Assertions.assertThat((String)"1a2b").isEqualTo(parameters.get("x"));
        Assertions.assertThat((String)"two").isEqualTo(parameters.get("y"));
        app = "foo --x=2";
        parameters = this.parse(app).getApp("foo").getArgumentsAsProperties();
        Assertions.assertThat((int)1).isEqualTo(parameters.size());
        Assertions.assertThat((String)"2").isEqualTo(parameters.get("x"));
        app = "--foo = bar";
        try {
            this.parse(app);
            throw new AssertionError((Object)(app + " is invalid. Should throw exception"));
        }
        catch (Exception exception) {
            return;
        }
    }

    @Test
    public void testInvalidApps() {
        String config = "test | foo--x=13";
        try {
            this.parse("t", config);
            throw new AssertionError((Object)(config + " is invalid. Should throw exception"));
        }
        catch (Exception exception) {
            return;
        }
    }

    @Test
    public void tapWithLabelReference() {
        this.parse("mystream = http | filter | group1: transform | group2: transform | file");
        StreamNode ast = this.parse(":mystream.group1 > file");
        Assertions.assertThat((String)"[(mystream.group1)>(AppNode:file)]").isEqualTo(ast.stringify());
        ast = this.parse(":mystream.group2 > file");
        Assertions.assertThat((String)"[(mystream.group2)>(AppNode:file)]").isEqualTo(ast.stringify());
    }

    @Test
    public void tapWithQualifiedAppReference() {
        this.parse("mystream = http | foobar | file");
        StreamNode sn = this.parse(":mystream.foobar > file");
        Assertions.assertThat((String)"[(mystream.foobar:1>16)>(AppNode:file:19>23)]").isEqualTo(sn.stringify(true));
    }

    @Test
    public void expressions_xd159() {
        StreamNode ast = this.parse("foo | transform --expression=--payload | bar");
        AppNode mn = ast.getApp("transform");
        Properties props = mn.getArgumentsAsProperties();
        Assertions.assertThat((String)"--payload").isEqualTo(props.get("expression"));
    }

    @Test
    public void expressions_xd159_2() {
        this.checkForParseError("foo | transform --expression=new StringBuilder(payload).reverse() | bar", DSLMessage.UNEXPECTED_DATA, 46, new Object[0]);
    }

    @Test
    public void ensureStreamNamesValid_xd1344() {
        this.checkForIllegalStreamName("foo.bar", "http | transform | sink");
        this.checkForIllegalStreamName("-bar", "http | transform | sink");
        this.checkForIllegalStreamName(".bar", "http | transform | sink");
        this.checkForIllegalStreamName("foo-.-bar", "http | transform | sink");
        this.checkForIllegalStreamName("0foobar", "http | transform | sink");
        this.checkForIllegalStreamName("foo%bar", "http | transform | sink");
        this.parse("foo-bar", "http | transform | sink");
        this.parse("foo_bar", "http | transform | sink");
    }

    @Test
    public void parametersContainingNewlineCarriageReturn() {
        StreamNode ast = this.parse(":producer > foobar --expression='aaa=bbb \n ccc=ddd' > :consumer");
        Assertions.assertThat((String)"aaa=bbb \n ccc=ddd").isEqualTo(ast.getApp("foobar").getArguments()[0].getValue());
        ast = this.parse(":producer > foobar --expression='aaa=bbb \r ccc=ddd' > :consumer");
        Assertions.assertThat((String)"aaa=bbb \r ccc=ddd").isEqualTo(ast.getApp("foobar").getArguments()[0].getValue());
    }

    @Test
    public void expressions_xd159_3() {
        StreamNode ast = this.parse("foo |  transform --expression='new StringBuilder(payload).reverse()' | bar");
        AppNode mn = ast.getApp("transform");
        Properties props = mn.getArgumentsAsProperties();
        Assertions.assertThat((String)"new StringBuilder(payload).reverse()").isEqualTo(props.get("expression"));
    }

    @Test
    public void testUnbalancedSingleQuotes() {
        this.checkForParseError("foo | bar --expression='select foo", DSLMessage.NON_TERMINATING_QUOTED_STRING, 23, new Object[0]);
    }

    @Test
    public void testUnbalancedDoubleQuotes() {
        this.checkForParseError("foo | bar --expression=\"select foo", DSLMessage.NON_TERMINATING_DOUBLE_QUOTED_STRING, 23, new Object[0]);
    }

    @Test
    public void appArguments_xd1613() {
        StreamNode ast = null;
        ast = this.parse(":producer > transform --expression='payload.toUpperCase()' | filter --expression='payload.length() > 4'> :consumer");
        Assertions.assertThat((String)"payload.toUpperCase()").isEqualTo(ast.getApp("transform").getArguments()[0].getValue());
        Assertions.assertThat((String)"payload.length() > 4").isEqualTo(ast.getApp("filter").getArguments()[0].getValue());
        ast = this.parse("time | transform --expression='T(org.joda.time.format.DateTimeFormat).forPattern(\"yyyy-MM-dd HH:mm:ss\").parseDateTime(payload)'");
        Assertions.assertThat((String)"T(org.joda.time.format.DateTimeFormat).forPattern(\"yyyy-MM-dd HH:mm:ss\").parseDateTime(payload)").isEqualTo(ast.getApp("transform").getArguments()[0].getValue());
        ast = this.parse("http | transform --outputType='text/plain|charset=UTF-8'  | log");
        Assertions.assertThat((String)"text/plain|charset=UTF-8").isEqualTo(ast.getApp("transform").getArguments()[0].getValue());
        ast = this.parse("http | transform --outputType='text/plain;charset=UTF-8'  | log");
        Assertions.assertThat((String)"text/plain;charset=UTF-8").isEqualTo(ast.getApp("transform").getArguments()[0].getValue());
        ast = this.parse("http | transform --expression='hi'+payload | log");
        Assertions.assertThat((String)"'hi'+payload").isEqualTo(ast.getApp("transform").getArguments()[0].getValue());
        ast = this.parse("http | transform --expression=payload+'hi' | log");
        Assertions.assertThat((String)"payload+'hi'").isEqualTo(ast.getApp("transform").getArguments()[0].getValue());
        ast = this.parse("http | transform --expression='payload+''hi''' | log");
        Assertions.assertThat((String)"payload+'hi'").isEqualTo(ast.getApp("transform").getArguments()[0].getValue());
        ast = this.parse("http | transform --expression='''hi''+payload' | log");
        Assertions.assertThat((String)"'hi'+payload").isEqualTo(ast.getApp("transform").getArguments()[0].getValue());
        ast = this.parse("http | transform --expression=\"payload+'hi'\" | log");
        Assertions.assertThat((String)"payload+'hi'").isEqualTo(ast.getApp("transform").getArguments()[0].getValue());
        ast = this.parse("http | transform --expression=\"'hi'+payload\" | log");
        Assertions.assertThat((String)"'hi'+payload").isEqualTo(ast.getApp("transform").getArguments()[0].getValue());
        ast = this.parse("http | transform --expression=payload+'hi'--param2='foobar' | log");
        Assertions.assertThat((String)"payload+'hi'--param2='foobar'").isEqualTo(ast.getApp("transform").getArguments()[0].getValue());
        ast = this.parse("http | transform --expression='hi'+payload--param2='foobar' | log");
        Assertions.assertThat((String)"'hi'+payload--param2='foobar'").isEqualTo(ast.getApp("transform").getArguments()[0].getValue());
        ast = this.parse("http | transform --expression='hi'+'world' | log");
        Assertions.assertThat((String)"'hi'+'world'").isEqualTo(ast.getApp("transform").getArguments()[0].getValue());
        ast = this.parse("http | transform --expression=\"'hi'+'world'\" | log");
        Assertions.assertThat((String)"'hi'+'world'").isEqualTo(ast.getApp("transform").getArguments()[0].getValue());
        ast = this.parse("http | filter --expression=payload.matches('hello world') | log");
        Assertions.assertThat((String)"payload.matches('hello world')").isEqualTo(ast.getApp("filter").getArguments()[0].getValue());
        ast = this.parse("http | transform --expression='''hi''' | log");
        Assertions.assertThat((String)"'hi'").isEqualTo(ast.getApp("transform").getArguments()[0].getValue());
        ast = this.parse("http | transform --expression=\"''''hi''''\" | log");
        Assertions.assertThat((String)"''''hi''''").isEqualTo(ast.getApp("transform").getArguments()[0].getValue());
    }

    @Test
    public void expressions_xd159_4() {
        StreamNode ast = this.parse("foo |  transform --expression=\"'Hello, world!'\" | bar");
        AppNode mn = ast.getApp("transform");
        Properties props = mn.getArgumentsAsProperties();
        Assertions.assertThat((String)"'Hello, world!'").isEqualTo(props.get("expression"));
        ast = this.parse("foo |  transform --expression='''Hello, world!''' | bar");
        mn = ast.getApp("transform");
        props = mn.getArgumentsAsProperties();
        Assertions.assertThat((String)"'Hello, world!'").isEqualTo(props.get("expression"));
        this.checkForParseError("foo |  transform --expression=''Hello, world!'' | bar", DSLMessage.UNEXPECTED_DATA, 44, new Object[0]);
    }

    @Test
    public void expressions_gh1() {
        StreamNode ast = this.parse("http --port=9014 | filter --expression=\"payload == 'foo'\" | log");
        AppNode mn = ast.getApp("filter");
        Properties props = mn.getArgumentsAsProperties();
        Assertions.assertThat((String)"payload == 'foo'").isEqualTo(props.get("expression"));
    }

    @Test
    public void expressions_gh1_2() {
        StreamNode ast = this.parse("http --port=9014 | filter --expression='new Foo()' | log");
        AppNode mn = ast.getApp("filter");
        Properties props = mn.getArgumentsAsProperties();
        Assertions.assertThat((String)"new Foo()").isEqualTo(props.get("expression"));
    }

    @Test
    public void sourceDestination() {
        StreamNode sn = this.parse(":foobar > file");
        Assertions.assertThat((String)"[(foobar:1>7)>(AppNode:file:10>14)]").isEqualTo(sn.stringify(true));
    }

    @Test
    public void sourceDestinationsWithExtraWildcards() {
        StreamNode sn = this.parse(":a/ > file");
        Assertions.assertThat((String)"[(a/:1>3)>(AppNode:file:6>10)]").isEqualTo(sn.stringify(true));
        sn = this.parse(":a/*# > file");
        Assertions.assertThat((String)"[(a/*#:1>5)>(AppNode:file:8>12)]").isEqualTo(sn.stringify(true));
        sn = this.parse(":foo.* > file");
        Assertions.assertThat((String)"[(foo.*:1>6)>(AppNode:file:9>13)]").isEqualTo(sn.stringify(true));
        sn = this.parse(":*foo > file");
        Assertions.assertThat((String)"[(*foo:1>5)>(AppNode:file:8>12)]").isEqualTo(sn.stringify(true));
    }

    @Test
    public void sinkDestination() {
        StreamNode sn = this.parse("http > :foo");
        Assertions.assertThat((String)"[(AppNode:http:0>4)>(foo:8>11)]").isEqualTo(sn.stringify(true));
    }

    @Test
    public void sinkDestinationsWithExtraWildcards() {
        StreamNode sn = this.parse("http > :foo/");
        Assertions.assertThat((String)"[(AppNode:http:0>4)>(foo/:8>12)]").isEqualTo(sn.stringify(true));
        sn = this.parse("http > :foo/*#");
        Assertions.assertThat((String)"[(AppNode:http:0>4)>(foo/*#:8>14)]").isEqualTo(sn.stringify(true));
        sn = this.parse("http > :foo.*");
        Assertions.assertThat((String)"[(AppNode:http:0>4)>(foo.*:8>13)]").isEqualTo(sn.stringify(true));
    }

    @Test
    public void destinationVariants() {
        this.checkForParseError("http > :test value", DSLMessage.UNEXPECTED_DATA_AFTER_STREAMDEF, 13, new Object[0]);
        this.checkForParseError(":boo .xx > file", DSLMessage.NO_WHITESPACE_IN_DESTINATION_DEFINITION, 5, new Object[0]);
        this.checkForParseError(":boo . xx > file", DSLMessage.NO_WHITESPACE_IN_DESTINATION_DEFINITION, 5, new Object[0]);
        this.checkForParseError(":boo. xx > file", DSLMessage.NO_WHITESPACE_IN_DESTINATION_DEFINITION, 6, new Object[0]);
        this.checkForParseError(":boo.xx. yy > file", DSLMessage.NO_WHITESPACE_IN_DESTINATION_DEFINITION, 9, new Object[0]);
        this.checkForParseError(":boo.xx .yy > file", DSLMessage.NO_WHITESPACE_IN_DESTINATION_DEFINITION, 8, new Object[0]);
        this.checkForParseError(":boo.xx . yy > file", DSLMessage.NO_WHITESPACE_IN_DESTINATION_DEFINITION, 8, new Object[0]);
        StreamNode sn = this.parse("wibble: http > :bar");
        Assertions.assertThat((String)"[((Label:wibble) AppNode:http)>(bar)]").isEqualTo(sn.stringify());
    }

    @Test
    public void sourceDestination2() {
        this.parse("foo = http | bar | file");
        StreamNode ast = this.parse(":foo.bar > file");
        Assertions.assertThat((String)"[(foo.bar:1>8)>(AppNode:file:11>15)]").isEqualTo(ast.stringify(true));
        Assertions.assertThat((String)"foo.bar").isEqualTo(ast.getSourceDestinationNode().getDestinationName());
    }

    @Test
    public void sourceTapDestination() {
        this.parse("mystream = http | file");
        StreamNode ast = this.parse(":mystream.http > file");
        Assertions.assertThat((String)"[(mystream.http:1>14)>(AppNode:file:17>21)]").isEqualTo(ast.stringify(true));
        SourceDestinationNode sourceDestinationNode = ast.getSourceDestinationNode();
        Assertions.assertThat((String)"mystream.http").isEqualTo(sourceDestinationNode.getDestinationName());
    }

    @Test
    public void nameSpaceTestWithSpaces() {
        this.checkForParseError("trigger > :myjob   too", DSLMessage.UNEXPECTED_DATA_AFTER_STREAMDEF, 19, "too");
    }

    @Test
    public void errorCases01() {
        this.checkForParseError(".", DSLMessage.EXPECTED_APPNAME, 0, ".");
        this.checkForParseError(";", DSLMessage.EXPECTED_APPNAME, 0, ";");
    }

    @Test
    public void errorCases04() {
        this.checkForParseError("foo bar=yyy", DSLMessage.UNEXPECTED_DATA_AFTER_STREAMDEF, 4, "bar");
        this.checkForParseError("foo bar", DSLMessage.UNEXPECTED_DATA_AFTER_STREAMDEF, 4, "bar");
    }

    @Test
    public void errorCases05() {
        this.checkForParseError("foo --", DSLMessage.OOD, 6, new Object[0]);
        this.checkForParseError("foo --bar", DSLMessage.OOD, 9, new Object[0]);
        this.checkForParseError("foo --bar=", DSLMessage.OOD, 10, new Object[0]);
    }

    @Test
    public void errorCases06() {
        this.checkForParseError("|", DSLMessage.EXPECTED_APPNAME, 0, new Object[0]);
    }

    @Test
    public void errorCases07() {
        this.checkForParseError("foo > bar", DSLMessage.EXPECTED_DESTINATION_PREFIX, 6, "bar");
        this.checkForParseError(":foo >", DSLMessage.OOD, 6, new Object[0]);
        this.checkForParseError(":foo > --2323", DSLMessage.EXPECTED_APPNAME, 7, "--");
        this.checkForParseError(":foo > (", DSLMessage.UNEXPECTED_DATA, 7, "(");
        this.checkForParseError(":foo > *", DSLMessage.EXPECTED_APPNAME, 7, "*");
        this.checkForParseError("::foo > *", DSLMessage.UNEXPECTED_DATA_IN_DESTINATION_NAME, 1, ":");
        this.checkForParseError(":foo > :", DSLMessage.OOD, 7, new Object[0]);
    }

    @Test
    public void errorCases08() {
        this.checkForParseError(":foo | bar", DSLMessage.EXPECTED_APPNAME, 0, ":");
    }

    @Test
    public void errorCases09() {
        this.checkForParseError("( = http | file", DSLMessage.UNEXPECTED_DATA, 0, "(");
        this.checkForParseError("* = http | file", DSLMessage.ILLEGAL_STREAM_NAME, 0, "*");
        this.checkForParseError(": = http | file", DSLMessage.ILLEGAL_STREAM_NAME, 0, ":");
    }

    @Test
    public void duplicateExplicitLabels() {
        this.checkForParseError("xxx: http | xxx: file", DSLMessage.DUPLICATE_LABEL, 12, "xxx", "http", 0, "file", 1);
        this.checkForParseError("xxx: http | yyy: filter | transform | xxx: transform | file", DSLMessage.DUPLICATE_LABEL, 38, "xxx", "http", 0, "transform", 3);
        this.checkForParseError("xxx: http | yyy: filter | transform | xxx: transform | xxx: file", DSLMessage.DUPLICATE_LABEL, 38, "xxx", "http", 0, "transform", 3);
    }

    @Test
    public void addingALabelLiftsAmbiguity() {
        StreamNode ast = this.parse("file | out: file");
        Assertions.assertThat((String)"file").isEqualTo(((AppNode)ast.getAppNodes().get(0)).getLabelName());
        Assertions.assertThat((String)"out").isEqualTo(((AppNode)ast.getAppNodes().get(1)).getLabelName());
    }

    @Test
    public void duplicateImplicitLabels() {
        this.checkForParseError("http | filter | transform | transform | file", DSLMessage.DUPLICATE_LABEL, 28, "transform", "transform", 2, "transform", 3);
    }

    @Test
    public void tapWithLabels() {
        this.parse("mystream = http | flibble: transform | file");
        StreamNode sn = this.parse(":mystream.flibble > file");
        Assertions.assertThat((String)"mystream.flibble").isEqualTo(sn.getSourceDestinationNode().getDestinationName());
    }

    @Test
    public void bridge01() {
        StreamNode sn = this.parse(":bar > :boo");
        Assertions.assertThat((String)"[(bar:1>4)>(AppNode:bridge:5>6)>(boo:8>11)]").isEqualTo(sn.stringify(true));
    }

    @Test
    public void testSourceDestinationArgs() {
        StreamNode sn = this.parse(":test --group=test > file");
        Assertions.assertThat((String)"[(test:1>5 --group=test)>(AppNode:file:21>25)]").isEqualTo(sn.stringify(true));
    }

    @Test
    public void needAdjacentTokensForParameters() {
        this.checkForParseError("foo -- name=value", DSLMessage.NO_WHITESPACE_BEFORE_ARG_NAME, 7, new Object[0]);
        this.checkForParseError("foo --name =value", DSLMessage.NO_WHITESPACE_BEFORE_ARG_EQUALS, 11, new Object[0]);
        this.checkForParseError("foo --name= value", DSLMessage.NO_WHITESPACE_BEFORE_ARG_VALUE, 12, new Object[0]);
    }

    @Test
    public void testComposedOptionNameErros() {
        this.checkForParseError("foo --name.=value", DSLMessage.NOT_EXPECTED_TOKEN, 11, new Object[0]);
        this.checkForParseError("foo --name .sub=value", DSLMessage.NO_WHITESPACE_IN_DOTTED_NAME, 11, new Object[0]);
        this.checkForParseError("foo --name. sub=value", DSLMessage.NO_WHITESPACE_IN_DOTTED_NAME, 12, new Object[0]);
    }

    @Test
    public void testXD2416() {
        StreamNode ast = this.parse("http | transform --expression='payload.replace(\"abc\", \"\")' | log");
        Assertions.assertThat((String)((String)((AppNode)ast.getAppNodes().get(1)).getArgumentsAsProperties().get("expression"))).isEqualTo("payload.replace(\"abc\", \"\")");
        ast = this.parse("http | transform --expression='payload.replace(\"abc\", '''')' | log");
        Assertions.assertThat((String)((String)((AppNode)ast.getAppNodes().get(1)).getArgumentsAsProperties().get("expression"))).isEqualTo("payload.replace(\"abc\", '')");
    }

    @Test
    public void testParseUnboundStreamApp() {
        StreamNode sn = this.parse("foo");
        List appNodes = sn.getAppNodes();
        Assertions.assertThat((boolean)((AppNode)appNodes.get(0)).isUnboundStreamApp()).isTrue();
    }

    @Test
    public void testParseUnboundStreamApps() {
        StreamNode sn = this.parse("foo|| bar|| baz");
        List appNodes = sn.getAppNodes();
        Assertions.assertThat((int)3).isEqualTo(appNodes.size());
        Assertions.assertThat((String)"foo").isEqualTo(((AppNode)appNodes.get(0)).getName());
        Assertions.assertThat((String)"baz").isEqualTo(((AppNode)appNodes.get(2)).getName());
        Assertions.assertThat((boolean)((AppNode)appNodes.get(0)).isUnboundStreamApp()).isTrue();
        sn = this.parse("foo | bar");
        appNodes = sn.getAppNodes();
        Assertions.assertThat((int)2).isEqualTo(appNodes.size());
        Assertions.assertThat((String)"foo").isEqualTo(((AppNode)appNodes.get(0)).getName());
        Assertions.assertThat((String)"bar").isEqualTo(((AppNode)appNodes.get(1)).getName());
        Assertions.assertThat((boolean)((AppNode)appNodes.get(0)).isUnboundStreamApp()).isFalse();
        this.checkForParseError("foo||", DSLMessage.OOD, 5, new Object[0]);
        sn = this.parse("foo --aaa=,|| bar");
        appNodes = sn.getAppNodes();
        Assertions.assertThat((int)2).isEqualTo(appNodes.size());
        Assertions.assertThat((String)"foo --aaa=,").isEqualTo(((AppNode)appNodes.get(0)).toString());
        Assertions.assertThat((String)"bar").isEqualTo(((AppNode)appNodes.get(1)).toString());
    }

    @Test
    public void testParseUnboundStreamAppsWithParams() {
        StreamNode sn = this.parse("foo --aaa=bbb || bar");
        List appNodes = sn.getAppNodes();
        Assertions.assertThat((int)2).isEqualTo(appNodes.size());
        Assertions.assertThat((String)"foo --aaa=bbb").isEqualTo(((AppNode)appNodes.get(0)).toString());
        Assertions.assertThat((String)"bar").isEqualTo(((AppNode)appNodes.get(1)).toString());
        sn = this.parse("foo --aaa=bbb|| bar");
        appNodes = sn.getAppNodes();
        Assertions.assertThat((int)2).isEqualTo(appNodes.size());
        Assertions.assertThat((String)"foo --aaa=bbb").isEqualTo(((AppNode)appNodes.get(0)).toString());
        Assertions.assertThat((String)"bar").isEqualTo(((AppNode)appNodes.get(1)).toString());
        sn = this.parse("foo --aaa=\"bbb\"|| bar");
        appNodes = sn.getAppNodes();
        Assertions.assertThat((int)2).isEqualTo(appNodes.size());
        Assertions.assertThat((String)"foo --aaa=bbb").isEqualTo(((AppNode)appNodes.get(0)).toString());
        Assertions.assertThat((String)"bar").isEqualTo(((AppNode)appNodes.get(1)).toString());
        sn = this.parse("foo --aaa=\"bbb\" || bar");
        appNodes = sn.getAppNodes();
        Assertions.assertThat((int)2).isEqualTo(appNodes.size());
        Assertions.assertThat((String)"foo --aaa=bbb").isEqualTo(((AppNode)appNodes.get(0)).toString());
        Assertions.assertThat((String)"bar").isEqualTo(((AppNode)appNodes.get(1)).toString());
        this.checkForParseError("foo --aaa=\"bbb\"||", DSLMessage.OOD, 17, new Object[0]);
        this.checkForParseError("foo --aaa=\"bbb\" ||", DSLMessage.OOD, 18, new Object[0]);
    }

    protected void checkForIllegalStreamName(String streamName, String streamDef) {
        try {
            StreamNode sn = this.parse(streamName, streamDef);
            throw new AssertionError((Object)("expected to fail but parsed " + sn.stringify()));
        }
        catch (ParseException e) {
            Assertions.assertThat((Comparable)e.getMessageCode()).isEqualTo((Object)DSLMessage.ILLEGAL_STREAM_NAME);
            Assertions.assertThat((int)e.getPosition()).isEqualTo(0);
            Assertions.assertThat((String)streamName).isEqualTo(e.getInserts()[0]);
            return;
        }
    }

    protected void checkForParseError(String stream, DSLMessage msg, int pos, Object ... inserts) {
        try {
            StreamNode sn = this.parse(stream);
            throw new AssertionError((Object)("expected to fail but parsed " + sn.stringify()));
        }
        catch (ParseException e) {
            Assertions.assertThat((Comparable)msg).isEqualTo((Object)e.getMessageCode());
            Assertions.assertThat((int)pos).isEqualTo(e.getPosition());
            if (inserts != null) {
                for (int i = 0; i < inserts.length; ++i) {
                    Assertions.assertThat((Object)inserts[i]).isEqualTo(e.getInserts()[i]);
                }
            }
            return;
        }
    }
}

