/*
 * Decompiled with CFR 0.152.
 */
package sample;

import java.util.HashMap;
import org.springframework.cloud.deployer.resource.maven.MavenResource;
import org.springframework.cloud.deployer.spi.core.AppDefinition;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.local.LocalDeployerProperties;
import org.springframework.cloud.deployer.spi.local.LocalTaskLauncher;
import org.springframework.core.io.Resource;

public class TimeStamp {
    public static void main(String[] args) throws InterruptedException {
        LocalTaskLauncher launcher = new LocalTaskLauncher(new LocalDeployerProperties());
        String timestampId = launcher.launch(TimeStamp.createAppDeploymentRequest("timestamp-task"));
        for (int i = 0; i < 50; ++i) {
            Thread.sleep(100L);
            System.out.println("timestamp: " + launcher.status(timestampId));
        }
        launcher.cancel(timestampId);
        System.out.println("timestamp after cancel: " + launcher.status(timestampId));
    }

    private static AppDeploymentRequest createAppDeploymentRequest(String app) {
        MavenResource resource = new MavenResource.Builder().artifactId(app).groupId("org.springframework.cloud.task.app").version("1.0.0.BUILD-SNAPSHOT").build();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("server.port", "0");
        AppDefinition definition = new AppDefinition(app, properties);
        AppDeploymentRequest request = new AppDeploymentRequest(definition, (Resource)resource);
        return request;
    }
}

