/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.thin;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.loader.archive.Archive;
import org.springframework.boot.loader.archive.ExplodedArchive;
import org.springframework.boot.loader.archive.JarFileArchive;
import org.springframework.boot.loader.thin.ArchiveUtils;
import org.springframework.boot.loader.thin.DependencyResolver;
import org.springframework.boot.loader.thin.PathResolver;
import org.springframework.boot.loader.tools.MainClassFinder;
import org.springframework.cloud.deployer.spi.task.LaunchState;
import org.springframework.cloud.deployer.thin.ContextRunner;
import org.springframework.core.io.Resource;
import org.springframework.util.ClassUtils;
import org.springframework.util.DigestUtils;
import org.springframework.util.ReflectionUtils;

public class ThinJarAppWrapper {
    private static Log logger = LogFactory.getLog(ThinJarAppWrapper.class);
    private String id;
    private Object app;
    private Object status;
    private Resource resource;
    private LaunchState state = LaunchState.unknown;
    private final String name;
    private final String[] profiles;

    public ThinJarAppWrapper(Resource resource, String name, String[] profiles) {
        this.resource = resource;
        this.name = name;
        this.profiles = profiles;
        try {
            this.id = DigestUtils.md5DigestAsHex((byte[])resource.getFile().getAbsolutePath().getBytes(Charset.forName("UTF-8")));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Not a valid file resource");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Map<String, String> properties, List<String> args) {
        if (this.app == null) {
            this.state = LaunchState.launching;
            ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
            try {
                Archive child = this.getRootArchive();
                Class<?> cls = this.createContextRunnerClass(child, args);
                this.app = cls.newInstance();
                this.runContext(this.getMainClass(child), properties, args.toArray(new String[0]));
                boolean running = this.isRunning();
                this.state = running ? LaunchState.running : (this.getError() != null ? LaunchState.failed : LaunchState.complete);
            }
            catch (Exception e) {
                this.state = LaunchState.failed;
                logger.error((Object)("Cannot deploy " + this.resource), (Throwable)e);
            }
            finally {
                ClassUtils.overrideThreadContextClassLoader((ClassLoader)contextLoader);
            }
        }
    }

    private Archive getRootArchive() throws IOException {
        File file = this.resource.getFile();
        if (file.isDirectory()) {
            return new ExplodedArchive(file);
        }
        return new JarFileArchive(file);
    }

    private boolean isRunning() {
        if (this.app == null) {
            return false;
        }
        Method method = ReflectionUtils.findMethod(this.app.getClass(), (String)"isRunning");
        return (Boolean)ReflectionUtils.invokeMethod((Method)method, (Object)this.app);
    }

    private Throwable getError() {
        if (this.app == null) {
            return null;
        }
        Method method = ReflectionUtils.findMethod(this.app.getClass(), (String)"getError");
        return (Throwable)ReflectionUtils.invokeMethod((Method)method, (Object)this.app);
    }

    private void runContext(String mainClass, Map<String, String> properties, String ... args) {
        Method method = ReflectionUtils.findMethod(this.app.getClass(), (String)"run", (Class[])new Class[]{String.class, Map.class, String[].class});
        ReflectionUtils.invokeMethod((Method)method, (Object)this.app, (Object[])new Object[]{mainClass, properties, args});
    }

    private Class<?> createContextRunnerClass(Archive child, List<String> args) throws Exception, ClassNotFoundException {
        Archive parent = this.createArchive();
        PathResolver archives = new PathResolver(DependencyResolver.instance());
        if (args.contains("--debug")) {
            // empty if block
        }
        List extracted = archives.resolve(child, this.name, this.profiles);
        ClassLoader loader = this.createClassLoader(extracted, parent, child);
        ClassUtils.overrideThreadContextClassLoader((ClassLoader)loader);
        this.reset();
        Class<?> cls = loader.loadClass(ContextRunner.class.getName());
        return cls;
    }

    private void reset() {
        if (ClassUtils.isPresent((String)"org.apache.catalina.webresources.TomcatURLStreamHandlerFactory", null)) {
            this.setField(ClassUtils.resolveClassName((String)"org.apache.catalina.webresources.TomcatURLStreamHandlerFactory", null), "instance", null);
            this.setField(URL.class, "factory", null);
        }
    }

    private void setField(Class<?> type, String name, Object value) {
        Field field = ReflectionUtils.findField(type, (String)name);
        ReflectionUtils.makeAccessible((Field)field);
        ReflectionUtils.setField((Field)field, null, (Object)value);
    }

    public void cancel() {
        if (this.isRunning()) {
            this.state = LaunchState.cancelled;
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void close() {
        if (this.app == null) return;
        try {
            Method method = ReflectionUtils.findMethod(this.app.getClass(), (String)"close");
            ReflectionUtils.invokeMethod((Method)method, (Object)this.app);
            return;
        }
        catch (Exception e) {
            this.state = LaunchState.error;
            logger.error((Object)("Cannot undeploy " + this.resource), (Throwable)e);
            return;
        }
        finally {
            this.reset();
            if (this.app != null) {
                try {
                    ((URLClassLoader)this.app.getClass().getClassLoader()).close();
                    this.app = null;
                }
                catch (Exception e) {
                    this.state = LaunchState.error;
                    logger.error((Object)("Cannot clean up " + this.resource), (Throwable)e);
                }
                finally {
                    this.app = null;
                    System.gc();
                }
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public Object status() {
        return this.status;
    }

    public Object getApp() {
        return this.app;
    }

    public LaunchState getState() {
        if (!this.isRunning() && this.app != null) {
            this.close();
        }
        return this.state;
    }

    public String toString() {
        return "Wrapper [id=" + this.id + ", resource=" + this.resource + ", state=" + this.state + "]";
    }

    protected String getMainClass(Archive archive) {
        try {
            Manifest manifest = archive.getManifest();
            String mainClass = null;
            if (manifest != null) {
                mainClass = manifest.getMainAttributes().getValue("Start-Class");
            }
            if (mainClass == null) {
                throw new IllegalStateException("No 'Start-Class' manifest entry specified in " + this);
            }
            return mainClass;
        }
        catch (Exception e) {
            try {
                File root = new File(archive.getUrl().toURI());
                String mainClass = null;
                mainClass = archive instanceof ExplodedArchive ? MainClassFinder.findSingleMainClass((File)root) : MainClassFinder.findSingleMainClass((JarFile)new JarFile(root), (String)"/");
                return mainClass;
            }
            catch (Exception ex) {
                throw new IllegalStateException("Cannot find main class", e);
            }
        }
    }

    private ClassLoader createClassLoader(List<Archive> archives, Archive ... roots) {
        URL[] urls = this.getUrls(archives, roots);
        URLClassLoader classLoader = new URLClassLoader(urls, this.getClass().getClassLoader().getParent());
        Thread.currentThread().setContextClassLoader(classLoader);
        return classLoader;
    }

    private URL[] getUrls(List<Archive> archives, Archive ... roots) {
        try {
            ArrayList<URL> urls = new ArrayList<URL>(archives.size());
            for (Archive archive : archives) {
                urls.add(archive.getUrl());
            }
            for (int i = 0; i < roots.length; ++i) {
                urls.add(i, roots[i].getUrl());
            }
            URL[] result = urls.toArray(new URL[0]);
            for (int i = 0; i < roots.length; ++i) {
                result = ArchiveUtils.addNestedClasses((Archive)roots[i], (URL[])result, (String[])new String[]{"BOOT-INF/classes/"});
            }
            return result;
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Cannot create URL", e);
        }
    }

    protected final Archive createArchive() {
        try {
            String path;
            ProtectionDomain protectionDomain = this.getClass().getProtectionDomain();
            CodeSource codeSource = protectionDomain.getCodeSource();
            URI location = codeSource == null ? null : codeSource.getLocation().toURI();
            String string = path = location == null ? null : location.getSchemeSpecificPart();
            if (path == null) {
                throw new IllegalStateException("Unable to determine code source archive");
            }
            File root = new File(path);
            if (!root.exists()) {
                throw new IllegalStateException("Unable to determine code source archive from " + root);
            }
            return root.isDirectory() ? new ExplodedArchive(root) : new JarFileArchive(root);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannt create local archive", e);
        }
    }

    public void status(Object status) {
        this.status = status;
    }
}

