/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.yarn;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.deployer.spi.yarn.YarnCloudAppService;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.task.TaskExecutor;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.action.Action;
import org.springframework.statemachine.config.StateMachineBuilder;
import org.springframework.statemachine.config.model.StateMachineModelFactory;
import org.springframework.statemachine.guard.Guard;
import org.springframework.statemachine.uml.UmlStateMachineModelFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractDeployerStateMachine {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDeployerStateMachine.class);
    public static final String STATE_READY = "READY";
    public static final String STATE_ERROR = "ERROR";
    public static final String VAR_ERROR = "error";
    public static final String VAR_APP_VERSION = "appVersion";
    public static final String VAR_APPLICATION_ID = "applicationId";
    public static final String VAR_ARTIFACT = "artifact";
    public static final String VAR_MESSAGE_ID = "messageId";
    public static final String HEADER_APPLICATION_ID = "applicationId";
    public static final String HEADER_APP_VERSION = "appVersion";
    public static final String HEADER_GROUP_ID = "groupId";
    public static final String HEADER_ERROR = "error";
    public static final String HEADER_ARTIFACT = "artifact";
    public static final String HEADER_ARTIFACT_DIR = "artifactDir";
    public static final String HEADER_CONTEXT_RUN_ARGS = "contextRunArgs";
    public static final String HEADER_DEFINITION_PARAMETERS = "definitionParameters";
    private final YarnCloudAppService yarnCloudAppService;
    private final TaskExecutor taskExecutor;
    private final BeanFactory beanFactory;
    private final ResourceLoader resourceLoader;
    private final String modelLocation;
    private boolean autoStart = true;

    public AbstractDeployerStateMachine(YarnCloudAppService yarnCloudAppService, TaskExecutor taskExecutor, BeanFactory beanFactory, ResourceLoader resourceLoader, String modelLocation) {
        Assert.notNull((Object)yarnCloudAppService, (String)"YarnCloudAppService must be set");
        Assert.notNull((Object)taskExecutor, (String)"TaskExecutor must be set");
        Assert.notNull((Object)beanFactory, (String)"BeanFactory must be set");
        Assert.notNull((Object)resourceLoader, (String)"ResourceLoader must be set");
        Assert.notNull((Object)modelLocation, (String)"Model must be set");
        this.yarnCloudAppService = yarnCloudAppService;
        this.taskExecutor = taskExecutor;
        this.beanFactory = beanFactory;
        this.resourceLoader = resourceLoader;
        this.modelLocation = modelLocation;
    }

    public final StateMachine<String, String> buildStateMachine() throws Exception {
        Map<String, Guard<String, String>> registeredGuards;
        StateMachineBuilder.Builder builder = StateMachineBuilder.builder();
        builder.configureConfiguration().withConfiguration().autoStartup(this.autoStart).taskExecutor(this.taskExecutor).beanFactory(this.beanFactory);
        UmlStateMachineModelFactory modelFactory = new UmlStateMachineModelFactory(this.modelLocation);
        Map<String, Action<String, String>> registeredActions = this.getRegisteredActions();
        if (registeredActions != null) {
            for (Map.Entry<String, Action<String, String>> entry : registeredActions.entrySet()) {
                modelFactory.registerAction(entry.getKey(), (Action)new ExceptionCatchingAction(entry.getValue()));
            }
        }
        if ((registeredGuards = this.getRegisteredGuards()) != null) {
            for (Map.Entry<String, Guard<String, String>> entry : registeredGuards.entrySet()) {
                modelFactory.registerGuard(entry.getKey(), entry.getValue());
            }
        }
        modelFactory.setResourceLoader(this.resourceLoader);
        builder.configureModel().withModel().factory((StateMachineModelFactory)modelFactory);
        return builder.build();
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    protected abstract Map<String, Action<String, String>> getRegisteredActions();

    protected abstract Map<String, Guard<String, String>> getRegisteredGuards();

    protected YarnCloudAppService getYarnCloudAppService() {
        return this.yarnCloudAppService;
    }

    private boolean isHdfsResource(Resource resource) {
        try {
            return resource != null && resource.getURI().getScheme().equals("hdfs");
        }
        catch (IOException e) {
            return false;
        }
    }

    private class ExceptionCatchingAction
    implements Action<String, String> {
        private final Action<String, String> delegate;

        public ExceptionCatchingAction(Action<String, String> delegate) {
            Assert.notNull(delegate, (String)"Delegate action must be set");
            this.delegate = delegate;
        }

        public void execute(StateContext<String, String> context) {
            try {
                this.delegate.execute(context);
            }
            catch (Exception e) {
                context.getExtendedState().getVariables().put("error", e);
            }
        }
    }

    protected class ErrorAction
    implements Action<String, String> {
        protected ErrorAction() {
        }

        public void execute(StateContext<String, String> context) {
            logger.error("Passing through error state {}", context);
        }
    }

    protected class ErrorGuard
    implements Guard<String, String> {
        protected ErrorGuard() {
        }

        public boolean evaluate(StateContext<String, String> context) {
            return context.getExtendedState().getVariables().containsKey("error");
        }
    }

    protected class PushAppGuard
    implements Guard<String, String> {
        protected PushAppGuard() {
        }

        public boolean evaluate(StateContext<String, String> context) {
            return !context.getExtendedState().getVariables().containsKey("appVersion");
        }
    }

    protected class PushArtifactAction
    implements Action<String, String> {
        protected PushArtifactAction() {
        }

        public void execute(StateContext<String, String> context) {
            Resource artifact = (Resource)context.getMessageHeader((Object)"artifact");
            String artifactDir = (String)context.getMessageHeader((Object)AbstractDeployerStateMachine.HEADER_ARTIFACT_DIR);
            if (!AbstractDeployerStateMachine.this.isHdfsResource(artifact)) {
                AbstractDeployerStateMachine.this.yarnCloudAppService.pushArtifact(artifact, artifactDir);
            } else if (!artifact.exists()) {
                context.getExtendedState().getVariables().put("error", new RuntimeException("hdfs artifact missing"));
            }
        }
    }

    protected class PushAppAction
    implements Action<String, String> {
        private final YarnCloudAppService.CloudAppType cloudAppType;

        public PushAppAction(YarnCloudAppService.CloudAppType cloudAppType) {
            this.cloudAppType = cloudAppType;
        }

        public void execute(StateContext<String, String> context) {
            String appVersion = (String)context.getMessageHeader((Object)"appVersion");
            AbstractDeployerStateMachine.this.yarnCloudAppService.pushApplication(appVersion, this.cloudAppType);
        }
    }

    protected class CheckAppAction
    implements Action<String, String> {
        private final YarnCloudAppService.CloudAppType cloudAppType;

        public CheckAppAction(YarnCloudAppService.CloudAppType cloudAppType) {
            this.cloudAppType = cloudAppType;
        }

        public void execute(StateContext<String, String> context) {
            String appVersion = (String)context.getMessageHeader((Object)"appVersion");
            if (!StringUtils.hasText((String)appVersion)) {
                context.getExtendedState().getVariables().put("error", new RuntimeException("appVersion not defined"));
            } else {
                Collection<YarnCloudAppService.CloudAppInfo> appInfos = AbstractDeployerStateMachine.this.yarnCloudAppService.getApplications(this.cloudAppType);
                for (YarnCloudAppService.CloudAppInfo appInfo : appInfos) {
                    if (!appInfo.getName().equals(appVersion)) continue;
                    context.getExtendedState().getVariables().put("appVersion", appVersion);
                }
            }
        }
    }

    protected class ResetVariablesAction
    implements Action<String, String> {
        protected ResetVariablesAction() {
        }

        public void execute(StateContext<String, String> context) {
            context.getExtendedState().getVariables().clear();
        }
    }
}

