/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.internal;

import java.io.File;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.maven.model.Model;
import org.springframework.cloud.internal.ArtifactFetcher;
import org.springframework.cloud.internal.ConfigurationPropertiesAggregator;
import org.springframework.cloud.internal.ConfigurationProperty;
import org.springframework.cloud.internal.Logger;
import org.springframework.cloud.internal.PomReader;
import org.springframework.cloud.internal.Project;
import org.springframework.cloud.internal.ResourcesCopier;
import org.springframework.cloud.internal.TemplateGenerator;

public class GenerateReleaseTrainDocs {
    final ExecutorService service = Executors.newFixedThreadPool(4);

    public static void main(String ... args) {
        File bomPath = new File(args[0]);
        File starterParentPath = new File(args[1]);
        String repoUrl = args[2];
        File unzippedDocs = new File(args[3]);
        File generatedTrainDocs = new File(args[4]);
        new GenerateReleaseTrainDocs().generate(bomPath, starterParentPath, repoUrl, unzippedDocs, generatedTrainDocs);
    }

    GenerateReleaseTrainDocs() {
    }

    void generate(File bomPath, File starterParentPath, String repoUrl, File unzippedDocs, File generatedTrainDocs) {
        List<Project> projects = this.mavenPropertiesToDocsProjects(bomPath);
        Logger.info("Found the following projects [" + projects + "]");
        List<File> outputFolders = this.downloadSources(unzippedDocs, projects, repoUrl);
        projects.add(this.springBootVersion(starterParentPath));
        projects.sort(Comparator.comparing(o -> o.name));
        List<ConfigurationProperty> configurationProperties = this.mergeConfigurationProperties(unzippedDocs);
        File file = this.renderAsciidocTemplates(generatedTrainDocs, projects, configurationProperties);
        Logger.info("Rendered docs templates to [" + file + "]");
        new ResourcesCopier().copy(outputFolders, file);
    }

    List<Project> mavenPropertiesToDocsProjects(File file) {
        Model model = PomReader.readPom(file);
        Properties properties = model.getProperties();
        return properties.entrySet().stream().filter(e -> e.getKey().toString().endsWith(".version") && !e.getKey().toString().contains("spring-cloud-stream")).map(e -> new Project(e.getKey().toString().replace(".version", ""), e.getValue().toString())).collect(Collectors.toCollection(LinkedList::new));
    }

    Project springBootVersion(File file) {
        Model model = PomReader.readPom(file);
        return new Project("spring-boot", model.getParent().getVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<File> downloadSources(File outputFolder, List<Project> projects, String repoUrl) {
        ArtifactFetcher fetcher = new ArtifactFetcher(outputFolder, repoUrl);
        try {
            LinkedList<Future<File>> futures = new LinkedList<Future<File>>();
            for (Project project : projects) {
                futures.add(this.service.submit(() -> fetcher.unpackedDocs(project)));
            }
            List<File> files = futures.stream().map(future -> {
                try {
                    return (File)future.get(5L, TimeUnit.MINUTES);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
            Logger.info("Unpacked docs modules to the following directories [" + files + "]");
            List<File> list = files;
            return list;
        }
        finally {
            this.service.shutdown();
        }
    }

    List<ConfigurationProperty> mergeConfigurationProperties(File outputFolderWithDocs) {
        ConfigurationPropertiesAggregator aggregator = new ConfigurationPropertiesAggregator();
        return aggregator.mergedConfigurationProperties(outputFolderWithDocs.toPath());
    }

    File renderAsciidocTemplates(File generatedTrainDocs, List<Project> projects, List<ConfigurationProperty> configurationProperties) {
        TemplateGenerator templateGenerator = new TemplateGenerator(generatedTrainDocs);
        return templateGenerator.generate(projects, configurationProperties);
    }
}

