/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.adapter.aws;

import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class CustomRuntimeEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    private static final String CUSTOM_RUNTIME = "spring.cloud.function.aws.custom";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (!environment.containsProperty(CUSTOM_RUNTIME)) {
            Map<String, Object> defaults = this.getDefaultProperties(environment);
            defaults.put(CUSTOM_RUNTIME, true);
        }
    }

    private Map<String, Object> getDefaultProperties(ConfigurableEnvironment environment) {
        if (environment.getPropertySources().contains("defaultProperties")) {
            MapPropertySource source = (MapPropertySource)environment.getPropertySources().get("defaultProperties");
            return (Map)source.getSource();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        environment.getPropertySources().addLast((PropertySource)new MapPropertySource("defaultProperties", map));
        return map;
    }
}

