/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.grpc;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ExperimentalApi;
import io.grpc.MethodDescriptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.protobuf.ProtoFileDescriptorSupplier;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import java.util.Iterator;
import org.springframework.cloud.function.grpc.GrpcSpringMessage;
import org.springframework.cloud.function.grpc.MessageService;

public final class MessagingServiceGrpc {
    public static final String SERVICE_NAME = "org.springframework.cloud.function.grpc.MessagingService";
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1901")
    public static final MethodDescriptor<GrpcSpringMessage, GrpcSpringMessage> METHOD_BI_STREAM = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.BIDI_STREAMING).setFullMethodName(MethodDescriptor.generateFullMethodName((String)"org.springframework.cloud.function.grpc.MessagingService", (String)"biStream")).setRequestMarshaller(ProtoUtils.marshaller((Message)GrpcSpringMessage.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)GrpcSpringMessage.getDefaultInstance())).build();
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1901")
    public static final MethodDescriptor<GrpcSpringMessage, GrpcSpringMessage> METHOD_CLIENT_STREAM = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.CLIENT_STREAMING).setFullMethodName(MethodDescriptor.generateFullMethodName((String)"org.springframework.cloud.function.grpc.MessagingService", (String)"clientStream")).setRequestMarshaller(ProtoUtils.marshaller((Message)GrpcSpringMessage.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)GrpcSpringMessage.getDefaultInstance())).build();
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1901")
    public static final MethodDescriptor<GrpcSpringMessage, GrpcSpringMessage> METHOD_SERVER_STREAM = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.SERVER_STREAMING).setFullMethodName(MethodDescriptor.generateFullMethodName((String)"org.springframework.cloud.function.grpc.MessagingService", (String)"serverStream")).setRequestMarshaller(ProtoUtils.marshaller((Message)GrpcSpringMessage.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)GrpcSpringMessage.getDefaultInstance())).build();
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1901")
    public static final MethodDescriptor<GrpcSpringMessage, GrpcSpringMessage> METHOD_REQUEST_REPLY = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName(MethodDescriptor.generateFullMethodName((String)"org.springframework.cloud.function.grpc.MessagingService", (String)"requestReply")).setRequestMarshaller(ProtoUtils.marshaller((Message)GrpcSpringMessage.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)GrpcSpringMessage.getDefaultInstance())).build();
    private static final int METHODID_SERVER_STREAM = 0;
    private static final int METHODID_REQUEST_REPLY = 1;
    private static final int METHODID_BI_STREAM = 2;
    private static final int METHODID_CLIENT_STREAM = 3;
    private static volatile ServiceDescriptor serviceDescriptor;

    private MessagingServiceGrpc() {
    }

    public static MessagingServiceStub newStub(Channel channel) {
        return new MessagingServiceStub(channel);
    }

    public static MessagingServiceBlockingStub newBlockingStub(Channel channel) {
        return new MessagingServiceBlockingStub(channel);
    }

    public static MessagingServiceFutureStub newFutureStub(Channel channel) {
        return new MessagingServiceFutureStub(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServiceDescriptor getServiceDescriptor() {
        ServiceDescriptor result = serviceDescriptor;
        if (result != null) return result;
        Class<MessagingServiceGrpc> clazz = MessagingServiceGrpc.class;
        synchronized (MessagingServiceGrpc.class) {
            result = serviceDescriptor;
            if (result != null) return result;
            serviceDescriptor = result = ServiceDescriptor.newBuilder((String)SERVICE_NAME).setSchemaDescriptor((Object)new MessagingServiceDescriptorSupplier()).addMethod(METHOD_BI_STREAM).addMethod(METHOD_CLIENT_STREAM).addMethod(METHOD_SERVER_STREAM).addMethod(METHOD_REQUEST_REPLY).build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    private static final class MessagingServiceDescriptorSupplier
    implements ProtoFileDescriptorSupplier {
        private MessagingServiceDescriptorSupplier() {
        }

        public Descriptors.FileDescriptor getFileDescriptor() {
            return MessageService.getDescriptor();
        }
    }

    private static final class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final MessagingServiceImplBase serviceImpl;
        private final int methodId;

        MethodHandlers(MessagingServiceImplBase serviceImpl, int methodId) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
        }

        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    this.serviceImpl.serverStream((GrpcSpringMessage)request, responseObserver);
                    break;
                }
                case 1: {
                    this.serviceImpl.requestReply((GrpcSpringMessage)request, responseObserver);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 2: {
                    return this.serviceImpl.biStream(responseObserver);
                }
                case 3: {
                    return this.serviceImpl.clientStream(responseObserver);
                }
            }
            throw new AssertionError();
        }
    }

    public static final class MessagingServiceFutureStub
    extends AbstractStub<MessagingServiceFutureStub> {
        private MessagingServiceFutureStub(Channel channel) {
            super(channel);
        }

        private MessagingServiceFutureStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected MessagingServiceFutureStub build(Channel channel, CallOptions callOptions) {
            return new MessagingServiceFutureStub(channel, callOptions);
        }

        public ListenableFuture<GrpcSpringMessage> requestReply(GrpcSpringMessage request) {
            return ClientCalls.futureUnaryCall((ClientCall)this.getChannel().newCall(METHOD_REQUEST_REPLY, this.getCallOptions()), (Object)request);
        }
    }

    public static final class MessagingServiceBlockingStub
    extends AbstractStub<MessagingServiceBlockingStub> {
        private MessagingServiceBlockingStub(Channel channel) {
            super(channel);
        }

        private MessagingServiceBlockingStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected MessagingServiceBlockingStub build(Channel channel, CallOptions callOptions) {
            return new MessagingServiceBlockingStub(channel, callOptions);
        }

        public Iterator<GrpcSpringMessage> serverStream(GrpcSpringMessage request) {
            return ClientCalls.blockingServerStreamingCall((Channel)this.getChannel(), METHOD_SERVER_STREAM, (CallOptions)this.getCallOptions(), (Object)request);
        }

        public GrpcSpringMessage requestReply(GrpcSpringMessage request) {
            return (GrpcSpringMessage)ClientCalls.blockingUnaryCall((Channel)this.getChannel(), METHOD_REQUEST_REPLY, (CallOptions)this.getCallOptions(), (Object)request);
        }
    }

    public static final class MessagingServiceStub
    extends AbstractStub<MessagingServiceStub> {
        private MessagingServiceStub(Channel channel) {
            super(channel);
        }

        private MessagingServiceStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected MessagingServiceStub build(Channel channel, CallOptions callOptions) {
            return new MessagingServiceStub(channel, callOptions);
        }

        public StreamObserver<GrpcSpringMessage> biStream(StreamObserver<GrpcSpringMessage> responseObserver) {
            return ClientCalls.asyncBidiStreamingCall((ClientCall)this.getChannel().newCall(METHOD_BI_STREAM, this.getCallOptions()), responseObserver);
        }

        public StreamObserver<GrpcSpringMessage> clientStream(StreamObserver<GrpcSpringMessage> responseObserver) {
            return ClientCalls.asyncClientStreamingCall((ClientCall)this.getChannel().newCall(METHOD_CLIENT_STREAM, this.getCallOptions()), responseObserver);
        }

        public void serverStream(GrpcSpringMessage request, StreamObserver<GrpcSpringMessage> responseObserver) {
            ClientCalls.asyncServerStreamingCall((ClientCall)this.getChannel().newCall(METHOD_SERVER_STREAM, this.getCallOptions()), (Object)request, responseObserver);
        }

        public void requestReply(GrpcSpringMessage request, StreamObserver<GrpcSpringMessage> responseObserver) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(METHOD_REQUEST_REPLY, this.getCallOptions()), (Object)request, responseObserver);
        }
    }

    public static abstract class MessagingServiceImplBase
    implements BindableService {
        public StreamObserver<GrpcSpringMessage> biStream(StreamObserver<GrpcSpringMessage> responseObserver) {
            return ServerCalls.asyncUnimplementedStreamingCall(METHOD_BI_STREAM, responseObserver);
        }

        public StreamObserver<GrpcSpringMessage> clientStream(StreamObserver<GrpcSpringMessage> responseObserver) {
            return ServerCalls.asyncUnimplementedStreamingCall(METHOD_CLIENT_STREAM, responseObserver);
        }

        public void serverStream(GrpcSpringMessage request, StreamObserver<GrpcSpringMessage> responseObserver) {
            ServerCalls.asyncUnimplementedUnaryCall(METHOD_SERVER_STREAM, responseObserver);
        }

        public void requestReply(GrpcSpringMessage request, StreamObserver<GrpcSpringMessage> responseObserver) {
            ServerCalls.asyncUnimplementedUnaryCall(METHOD_REQUEST_REPLY, responseObserver);
        }

        public final ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder((ServiceDescriptor)MessagingServiceGrpc.getServiceDescriptor()).addMethod(METHOD_BI_STREAM, ServerCalls.asyncBidiStreamingCall(new MethodHandlers(this, 2))).addMethod(METHOD_CLIENT_STREAM, ServerCalls.asyncClientStreamingCall(new MethodHandlers(this, 3))).addMethod(METHOD_SERVER_STREAM, ServerCalls.asyncServerStreamingCall(new MethodHandlers(this, 0))).addMethod(METHOD_REQUEST_REPLY, ServerCalls.asyncUnaryCall(new MethodHandlers(this, 1))).build();
        }
    }
}

