/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.rsocket;

import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.cloud.function.context.catalog.FunctionTypeUtils;
import org.springframework.cloud.function.json.JsonMapper;
import org.springframework.cloud.function.rsocket.FunctionRSocketUtils;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.AbstractEncoder;
import org.springframework.core.codec.ByteArrayEncoder;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import reactor.core.publisher.Flux;

class MessageAwareJsonEncoder
extends AbstractEncoder<Object> {
    private final JsonMapper mapper;
    private final boolean isClient;
    private final ByteArrayEncoder byteArrayEncoder;

    MessageAwareJsonEncoder(JsonMapper mapper) {
        this(mapper, false);
    }

    MessageAwareJsonEncoder(JsonMapper mapper, boolean isClient) {
        super(new MimeType[]{MimeTypeUtils.APPLICATION_JSON});
        this.mapper = mapper;
        this.isClient = isClient;
        this.byteArrayEncoder = new ByteArrayEncoder();
    }

    public boolean canEncode(ResolvableType elementType, MimeType mimeType) {
        boolean canEncode;
        boolean bl = canEncode = mimeType != null && mimeType.isCompatibleWith(MimeTypeUtils.APPLICATION_JSON);
        if (canEncode && this.isClient) {
            canEncode = FunctionTypeUtils.isMessage((Type)elementType.getType()) || Map.class.isAssignableFrom(FunctionTypeUtils.getRawType((Type)elementType.getType()));
        }
        return canEncode;
    }

    public List<MimeType> getEncodableMimeTypes() {
        return Collections.singletonList(MimeTypeUtils.APPLICATION_JSON);
    }

    public DataBuffer encodeValue(Object value, DataBufferFactory bufferFactory, ResolvableType valueType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        if (value instanceof Message) {
            Object payload = ((Message)value).getPayload();
            value = FunctionRSocketUtils.sanitizeMessageToMap((Message)value);
            if (payload instanceof byte[]) {
                payload = new String((byte[])payload, StandardCharsets.UTF_8);
                ((Map)value).put(FunctionRSocketUtils.PAYLOAD, payload);
            }
        } else if (!(value instanceof Map)) {
            if (JsonMapper.isJsonString((Object)value)) {
                value = this.mapper.fromJson(value, valueType.getType());
            }
            value = Collections.singletonMap(FunctionRSocketUtils.PAYLOAD, value);
        }
        byte[] data = this.mapper.toJson(value);
        return this.byteArrayEncoder.encodeValue(data, bufferFactory, valueType, mimeType, hints);
    }

    public Flux<DataBuffer> encode(Publisher<? extends Object> inputStream, DataBufferFactory bufferFactory, ResolvableType elementType, MimeType mimeType, Map<String, Object> hints) {
        return Flux.from(inputStream).map(value -> this.encodeValue(value, bufferFactory, elementType, mimeType, hints));
    }
}

