/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.rsocket;

import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.messaging.Message;
import org.springframework.messaging.rsocket.RSocketRequester;
import org.springframework.messaging.support.GenericMessage;
import reactor.core.publisher.Mono;

class RSocketForwardingFunction
implements Function<Message<byte[]>, Publisher<Message<byte[]>>> {
    private static final Log LOGGER = LogFactory.getLog(RSocketForwardingFunction.class);
    private final SimpleFunctionRegistry.FunctionInvocationWrapper targetFunction;
    private final RSocketRequester rSocketRequester;

    RSocketForwardingFunction(SimpleFunctionRegistry.FunctionInvocationWrapper targetFunction, RSocketRequester rsocketRequester, String remoteFunctionName) {
        this.targetFunction = targetFunction;
        this.rSocketRequester = rsocketRequester;
    }

    @Override
    public Publisher<Message<byte[]>> apply(Message<byte[]> input) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Executing: " + this.targetFunction));
        }
        Mono targetFunctionCall = Mono.just(input).map((Function)this.targetFunction).cast(Message.class).map(Message::getPayload);
        return this.rSocketRequester.route("", new Object[0]).data((Object)targetFunctionCall, byte[].class).retrieveFlux(byte[].class).map(GenericMessage::new);
    }
}

