/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.config;

import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.aot.generate.GeneratedClass;
import org.springframework.aot.generate.GeneratedMethods;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.generate.MethodReference;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.predicate.RuntimeHintsPredicates;
import org.springframework.aot.test.generate.TestGenerationContext;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotContribution;
import org.springframework.beans.factory.aot.BeanFactoryInitializationCode;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.cloud.gateway.config.ConfigurableHintsRegistrationProcessor;
import org.springframework.cloud.gateway.filter.factory.SpringCloudCircuitBreakerFilterFactory;
import org.springframework.cloud.gateway.filter.factory.SpringCloudCircuitBreakerResilience4JFilterFactory;
import org.springframework.javapoet.TypeSpec;

class ConfigurableHintsRegistrationProcessorTests {
    private final ConfigurableHintsRegistrationProcessor processor = new ConfigurableHintsRegistrationProcessor();
    private final TestGenerationContext generationContext = new TestGenerationContext();
    private final BeanFactoryInitializationCode beanFactoryInitializationCode = new MockBeanFactoryInitializationCode((GenerationContext)this.generationContext);
    private final DefaultListableBeanFactory beanFactory = new DefaultListableBeanFactory();

    ConfigurableHintsRegistrationProcessorTests() {
    }

    @Test
    void shouldRegisterReflectionHintsForTypeAndSuperTypesAndGenerics() {
        AbstractBeanDefinition beanDefinition = BeanDefinitionBuilder.rootBeanDefinition(SpringCloudCircuitBreakerResilience4JFilterFactory.class).getBeanDefinition();
        this.beanFactory.registerBeanDefinition("test", (BeanDefinition)beanDefinition);
        BeanFactoryInitializationAotContribution contribution = this.processor.processAheadOfTime((ConfigurableListableBeanFactory)this.beanFactory);
        Assertions.assertThat((Object)contribution).isNotNull();
        contribution.applyTo((GenerationContext)this.generationContext, this.beanFactoryInitializationCode);
        RuntimeHints hints = this.generationContext.getRuntimeHints();
        Assertions.assertThat((Predicate)RuntimeHintsPredicates.reflection().onType(SpringCloudCircuitBreakerResilience4JFilterFactory.class)).accepts((Object[])new RuntimeHints[]{hints});
        Assertions.assertThat((Predicate)RuntimeHintsPredicates.reflection().onType(SpringCloudCircuitBreakerFilterFactory.class)).accepts((Object[])new RuntimeHints[]{hints});
        Assertions.assertThat((Predicate)RuntimeHintsPredicates.reflection().onType(SpringCloudCircuitBreakerFilterFactory.Config.class)).accepts((Object[])new RuntimeHints[]{hints});
    }

    static class MockBeanFactoryInitializationCode
    implements BeanFactoryInitializationCode {
        private static final Consumer<TypeSpec.Builder> emptyTypeCustomizer = type -> {};
        private final GeneratedClass generatedClass;

        MockBeanFactoryInitializationCode(GenerationContext generationContext) {
            this.generatedClass = generationContext.getGeneratedClasses().addForFeature("Test", emptyTypeCustomizer);
        }

        public GeneratedMethods getMethods() {
            return this.generatedClass.getMethods();
        }

        public void addInitializer(MethodReference methodReference) {
            new ArrayList();
        }
    }
}

